/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.config;

import java.io.File;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.client.gui.hud.HealthStatusRenderer;
import net.tslat.aoa3.client.render.custom.AoAResourceRenderer;
import net.tslat.aoa3.client.render.custom.AoASkillRenderer;
import net.tslat.aoa3.common.networking.AoANetworking;
import net.tslat.aoa3.common.networking.packets.HaloSelectPacket;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.player.halo.HaloTypes;

public final class ClientConfig {
    public final ModConfigSpec.BooleanValue hideSurvivalUnobtainableItems;
    public final ModConfigSpec.BooleanValue showXpParticles;
    public final ModConfigSpec.BooleanValue showWelcomeMessage;
    public final ModConfigSpec.BooleanValue showPlayerHalos;
    public final ModConfigSpec.EnumValue<HaloTypes.Selectable> personalHaloPreference;
    public final ModConfigSpec.ConfigValue<String> adventGuiTheme;
    public final ModConfigSpec.BooleanValue thirdPartyBestiary;
    public final ModConfigSpec.EnumValue<AoASkillRenderer.ProgressRenderType> hudSkillProgressRenderType;
    public final ModConfigSpec.EnumValue<AoAResourceRenderer.HudResourcesPosition> hudResourcesPosition;
    public final ModConfigSpec.BooleanValue hudResourcesHorizontal;
    public final ModConfigSpec.BooleanValue disableHudPotionOffset;
    public final ModConfigSpec.BooleanValue useToasts;
    public final ModConfigSpec.BooleanValue rotatingTrophies;
    public final ModConfigSpec.BooleanValue screenShake;
    public final ModConfigSpec.BooleanValue partyDeaths;
    public final ModConfigSpec.EnumValue<HealthStatusRenderer.HealthRenderType> healthRenderType;

    public ClientConfig(ModConfigSpec.Builder specBuilder) {
        AdventOfAscension.getModEventBus().addListener(ClientConfig::onConfigUpdate);
        specBuilder.comment("AoA client-side configuration options").push("general_settings");
        this.hideSurvivalUnobtainableItems = specBuilder.comment("Set this to false to allow items that cannot currently be obtained in survival to be shown in the Creative Inventory").translation("config.aoa3.client.hideSurvivalUnobtainableItems").define("hideSurvivalUnobtainableItems", true);
        this.showXpParticles = specBuilder.comment("Set this to false to disable the small scrolling popups that appear when you gain xp in a skill").translation("config.aoa3.client.showXpParticles").define("showXpParticles", true);
        this.showWelcomeMessage = specBuilder.comment("Set this to false to disable the message that welcomes you to Advent of Ascension when logging in").translation("config.aoa3.client.showWelcomeMessage").define("showWelcomeMessage", true);
        this.showPlayerHalos = specBuilder.comment("Set this to false to hide player halos for those that have them").translation("config.aoa3.client.showPlayerHalos").define("showPlayerHalos", true);
        this.personalHaloPreference = specBuilder.comment("If multiple halos are available, which one would you prefer to have on?").translation("config.aoa3.client.personalHaloPreference").defineEnum("personalHaloPreference", (Enum)HaloTypes.Selectable.DONATOR);
        this.adventGuiTheme = specBuilder.comment("The current theme for the main Advent of Ascension window.").translation("config.aoa3.client.adventGuiTheme").define("adventGuiTheme", (Object)"Default");
        this.thirdPartyBestiary = specBuilder.comment("Set this to false to disable third party and vanilla entities from showing in the bestiary").translation("config.aoa3.client.thirdPartyBestiary").define("thirdPartyBestiary", true);
        this.hudResourcesPosition = specBuilder.comment("Choose a corner to have your resources indicators render in.").translation("config.aoa3.client.hudResourcesPosition").defineEnum("hudResourcesPosition", (Enum)AoAResourceRenderer.HudResourcesPosition.Top_Right);
        this.hudResourcesHorizontal = specBuilder.comment("Set this to false to switch to a vertical layout for the HUD resources").translation("config.aoa3.client.hudResourcesHorizontal").define("hudResourcesHorizontal", true);
        this.disableHudPotionOffset = specBuilder.comment("Set this to true to stop the skills and resources HUD elements shifting down when players have potion effects.").translation("config.aoa3.client.disableHudPotionOffset").define("disableHudPotionOffset", false);
        this.hudSkillProgressRenderType = specBuilder.comment("Choose which type of progress indication you would prefer for skills in the HUD").translation("config.aoa3.client.hudSkillProgressRenderType").defineEnum("hudSkillProgressRenderType", (Enum)AoASkillRenderer.ProgressRenderType.Bar);
        this.useToasts = specBuilder.comment("Set this to false to use chat messages for mod feedback instead of toasts").translation("config.aoa3.client.useToasts").define("useToasts", true);
        this.rotatingTrophies = specBuilder.comment("Set this to false to disable rotation of entities on trophy blocks.").translation("config.aoa3.client.rotatingTrophies").define("rotatingTrophies", true);
        this.healthRenderType = specBuilder.comment("Select what type of rendering AoA replaces the vanila health bar with").translation("config.aoa3.client.healthRenderType").defineEnum("healthRenderType", (Enum)HealthStatusRenderer.HealthRenderType.BAR_NUMERIC);
        this.screenShake = specBuilder.comment("Whether AoA should do screen shaking effects where relevant").translation("config.aoa3.client.screenShake").define("screenShake", true);
        specBuilder.pop();
        specBuilder.comment("Just for fun :)").push("fun_options");
        this.partyDeaths = specBuilder.comment("Set this to true to enable party deaths").translation("config.aoa3.client.partyDeaths").define("partyDeaths", false);
        specBuilder.pop();
    }

    public void changeAdventGuiTheme(String themeKey) {
        this.adventGuiTheme.set((Object)themeKey);
        this.adventGuiTheme.save();
    }

    private static void onConfigUpdate(ModConfigEvent.Reloading ev) {
        if (ev.getConfig().getFileName().equals("aoa3" + File.separator + "client_config.toml") && ClientOperations.getPlayer() != null) {
            AoANetworking.sendToServer(new HaloSelectPacket((HaloTypes.Selectable)((Object)AoAConfigs.CLIENT.personalHaloPreference.get())));
        }
    }
}

