/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration.loot;

import com.mojang.serialization.MapCodec;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.content.loottable.condition.BlockHasTag;
import net.tslat.aoa3.content.loottable.condition.IsBaby;
import net.tslat.aoa3.content.loottable.condition.IsHostileEntity;
import net.tslat.aoa3.content.loottable.condition.PlayerHasLevel;
import net.tslat.aoa3.content.loottable.condition.PlayerHasResource;
import net.tslat.aoa3.content.loottable.condition.WearingOrHoldingItem;

public final class AoALootConditions {
    public static final DeferredHolder<LootItemConditionType, LootItemConditionType> HOLDING_ITEM = AoALootConditions.register("holding_item", WearingOrHoldingItem.CODEC);
    public static final DeferredHolder<LootItemConditionType, LootItemConditionType> PLAYER_HAS_LEVEL = AoALootConditions.register("player_has_level", PlayerHasLevel.CODEC);
    public static final DeferredHolder<LootItemConditionType, LootItemConditionType> PLAYER_HAS_RESOURCE = AoALootConditions.register("player_has_resource", PlayerHasResource.CODEC);
    public static final DeferredHolder<LootItemConditionType, LootItemConditionType> HAS_BLOCK_TAG = AoALootConditions.register("has_block_tag", BlockHasTag.CODEC);
    public static final DeferredHolder<LootItemConditionType, LootItemConditionType> IS_HOSTILE_ENTITY = AoALootConditions.register("is_hostile_entity", IsHostileEntity.CODEC);
    public static final DeferredHolder<LootItemConditionType, LootItemConditionType> IS_BABY = AoALootConditions.register("is_baby", IsBaby.CODEC);

    public static void init() {
    }

    private static DeferredHolder<LootItemConditionType, LootItemConditionType> register(String id, MapCodec<? extends LootItemCondition> codec) {
        return AoARegistries.LOOT_CONDITIONS.register(id, () -> new LootItemConditionType(codec));
    }
}

