/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration.item;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.content.enchantment.valueeffect.Clamp;
import org.apache.commons.lang3.mutable.MutableFloat;

public final class AoAEnchantments {
    public static final ResourceKey<Enchantment> ARCHMAGE = AoAEnchantments.key("archmage");
    public static final ResourceKey<Enchantment> BRACE = AoAEnchantments.key("brace");
    public static final ResourceKey<Enchantment> CONTROL = AoAEnchantments.key("control");
    public static final ResourceKey<Enchantment> FORM = AoAEnchantments.key("form");
    public static final ResourceKey<Enchantment> GREED = AoAEnchantments.key("greed");
    public static final ResourceKey<Enchantment> INTERVENTION = AoAEnchantments.key("intervention");
    public static final ResourceKey<Enchantment> RECHARGE = AoAEnchantments.key("recharge");
    public static final ResourceKey<Enchantment> SEVER = AoAEnchantments.key("sever");
    public static final ResourceKey<Enchantment> SHELL = AoAEnchantments.key("shell");
    public static final DeferredHolder<MapCodec<? extends EnchantmentValueEffect>, MapCodec<Clamp>> CLAMP = AoAEnchantments.registerValueProvider("clamp", () -> Clamp.CODEC);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<List<ConditionalEffect<EnchantmentValueEffect>>>> CRIT_DAMAGE = AoAEnchantments.registerEffectType("crit_damage", builder -> builder.persistent(ConditionalEffect.codec((Codec)EnchantmentValueEffect.CODEC, (LootContextParamSet)LootContextParamSets.ENCHANTED_DAMAGE).listOf()));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<List<ConditionalEffect<EnchantmentValueEffect>>>> SPIRIT_CONSUMPTION = AoAEnchantments.registerEffectType("spirit_consumption", builder -> builder.persistent(ConditionalEffect.codec((Codec)EnchantmentValueEffect.CODEC, (LootContextParamSet)LootContextParamSets.ENCHANTED_ITEM).listOf()));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<List<ConditionalEffect<EnchantmentValueEffect>>>> RUNE_COST = AoAEnchantments.registerEffectType("rune_cost", builder -> builder.persistent(ConditionalEffect.codec((Codec)EnchantmentValueEffect.CODEC, (LootContextParamSet)LootContextParamSets.ENCHANTED_ITEM).listOf()));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<List<ConditionalEffect<EnchantmentValueEffect>>>> RECOIL = AoAEnchantments.registerEffectType("recoil", builder -> builder.persistent(ConditionalEffect.codec((Codec)EnchantmentValueEffect.CODEC, (LootContextParamSet)LootContextParamSets.ENCHANTED_ITEM).listOf()));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<List<ConditionalEffect<EnchantmentValueEffect>>>> PELLET_SPREAD = AoAEnchantments.registerEffectType("pellet_spread", builder -> builder.persistent(ConditionalEffect.codec((Codec)EnchantmentValueEffect.CODEC, (LootContextParamSet)LootContextParamSets.ENCHANTED_ITEM).listOf()));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<List<ConditionalEffect<EnchantmentValueEffect>>>> AMMO_COST = AoAEnchantments.registerEffectType("ammo_cost", builder -> builder.persistent(ConditionalEffect.codec((Codec)EnchantmentValueEffect.CODEC, (LootContextParamSet)LootContextParamSets.ENCHANTED_ITEM).listOf()));

    public static void init() {
    }

    public static float modifyCritDamage(ServerLevel level, ItemStack stack, Entity target, DamageSource source, float damage) {
        MutableFloat mutableFloat = new MutableFloat(damage);
        EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchant, enchantLevel) -> ((Enchantment)enchant.value()).modifyDamageFilteredValue((DataComponentType)CRIT_DAMAGE.get(), level, enchantLevel, stack, target, source, mutableFloat));
        return mutableFloat.floatValue();
    }

    public static float modifySpiritConsumption(Level level, ItemStack stack, float spiritCost) {
        if (!(level instanceof ServerLevel)) {
            return spiritCost;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        MutableFloat mutableFloat = new MutableFloat(spiritCost);
        EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchant, enchantLevel) -> ((Enchantment)enchant.value()).modifyItemFilteredCount((DataComponentType)SPIRIT_CONSUMPTION.get(), serverLevel, enchantLevel, stack, mutableFloat));
        return mutableFloat.floatValue();
    }

    public static int modifyRuneCost(ServerLevel level, ItemStack stack, int runeCost) {
        MutableFloat mutableFloat = new MutableFloat((float)runeCost);
        EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchant, enchantLevel) -> ((Enchantment)enchant.value()).modifyItemFilteredCount((DataComponentType)RUNE_COST.get(), level, enchantLevel, stack, mutableFloat));
        return Mth.ceil((float)mutableFloat.floatValue());
    }

    public static float modifyRecoil(ServerLevel level, ItemStack stack, float recoil) {
        MutableFloat mutableFloat = new MutableFloat(recoil);
        EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchant, enchantLevel) -> ((Enchantment)enchant.value()).modifyItemFilteredCount((DataComponentType)RECOIL.get(), level, enchantLevel, stack, mutableFloat));
        return mutableFloat.floatValue();
    }

    public static float modifyPelletSpread(ServerLevel level, ItemStack stack, float spread) {
        MutableFloat mutableFloat = new MutableFloat(spread);
        EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchant, enchantLevel) -> ((Enchantment)enchant.value()).modifyItemFilteredCount((DataComponentType)PELLET_SPREAD.get(), level, enchantLevel, stack, mutableFloat));
        return mutableFloat.floatValue();
    }

    public static int modifyAmmoCost(Level level, ItemStack stack, int cost) {
        if (!(level instanceof ServerLevel)) {
            return cost;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        MutableFloat mutableFloat = new MutableFloat((float)cost);
        EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchant, enchantLevel) -> ((Enchantment)enchant.value()).modifyItemFilteredCount((DataComponentType)AMMO_COST.get(), serverLevel, enchantLevel, stack, mutableFloat));
        return Mth.ceil((float)mutableFloat.floatValue());
    }

    private static ResourceKey<Enchantment> key(String id) {
        return ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)AdventOfAscension.id(id));
    }

    private static <T> DeferredHolder<DataComponentType<?>, DataComponentType<T>> registerEffectType(String id, UnaryOperator<DataComponentType.Builder<T>> builder) {
        return AoARegistries.ENCHANTMENT_EFFECT_COMPONENTS.register(id, () -> ((DataComponentType.Builder)builder.apply(DataComponentType.builder())).build());
    }

    private static <T extends EnchantmentValueEffect> DeferredHolder<MapCodec<? extends EnchantmentValueEffect>, MapCodec<T>> registerValueProvider(String id, Supplier<MapCodec<T>> codec) {
        return AoARegistries.ENCHANTMENT_VALUE_EFFECTS.register(id, codec);
    }
}

