/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration.item;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoARegistries;

public final class AoAArmourMaterials {
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> ACHELOS_HELMET = AoAArmourMaterials.register("achelos_helmet", Builder.helmet(5).toughness(7.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> OCEANUS_HELMET = AoAArmourMaterials.register("oceanus_helmet", Builder.helmet(5).toughness(7.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> SEALORD_HELMET = AoAArmourMaterials.register("sealord_helmet", Builder.helmet(5).toughness(7.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> FACE_MASK = AoAArmourMaterials.register("face_mask", Builder.helmet(5).toughness(5.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> CHROMA_GOGGLES = AoAArmourMaterials.register("chroma_goggles", Builder.helmet(2).toughness(1.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> SKILL_HELMET = AoAArmourMaterials.register("skill_helmet", Builder.helmet(5).toughness(7.0f).enchantValue(20).equipSound((Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> OLD_BOOT = AoAArmourMaterials.register("old_boot", Builder.boots(2).enchantValue(0).equipSound((Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> ALACRITY = AoAArmourMaterials.register("alacrity", Builder.armour(4, 8, 9, 3).toughness(5.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> ARCHAIC = AoAArmourMaterials.register("archaic", Builder.armour(5, 9, 8, 4).toughness(7.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> BARON = AoAArmourMaterials.register("baron", Builder.armour(4, 6, 9, 3).toughness(3.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> BATTLEBORN = AoAArmourMaterials.register("battleborn", Builder.armour(4, 8, 9, 5).toughness(7.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> BIOGENIC = AoAArmourMaterials.register("biogenic", Builder.armour(3, 6, 8, 3).toughness(3.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> BOREIC = AoAArmourMaterials.register("boreic", Builder.armour(4, 8, 10, 4).toughness(7.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> CANDY = AoAArmourMaterials.register("candy", Builder.armour(4, 7, 9, 4).toughness(5.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> COMMANDER = AoAArmourMaterials.register("commander", Builder.armour(4, 9, 9, 4).toughness(7.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> CRYSTALLIS = AoAArmourMaterials.register("crystallis", Builder.armour(5, 6, 10, 3).toughness(5.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> ELECANYTE = AoAArmourMaterials.register("elecanyte", Builder.armour(4, 8, 9, 5).toughness(7.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> EMBRODIUM = AoAArmourMaterials.register("embrodium", Builder.armour(4, 7, 8, 3).toughness(3.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> EXOPLATE = AoAArmourMaterials.register("exoplate", Builder.armour(4, 6, 8, 4).toughness(3.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> EXPLOSIVE = AoAArmourMaterials.register("explosive", Builder.armour(4, 7, 9, 3).toughness(3.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> FUNGAL = AoAArmourMaterials.register("fungal", Builder.armour(5, 6, 8, 5).toughness(5.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> GHASTLY = AoAArmourMaterials.register("ghastly", Builder.armour(5, 8, 8, 5).toughness(7.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> GHOULISH = AoAArmourMaterials.register("ghoulish", Builder.armour(6, 6, 8, 6).toughness(7.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> HAZMAT = AoAArmourMaterials.register("hazmat", Builder.armour(2, 5, 6, 2).equipSound((Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> HYDRANGIC = AoAArmourMaterials.register("hydrangic", Builder.armour(4, 7, 9, 4).toughness(5.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> HYDROPLATE = AoAArmourMaterials.register("hydroplate", Builder.armour(4, 8, 10, 4).toughness(7.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> ICE = AoAArmourMaterials.register("ice", Builder.armour(2, 6, 6, 2).toughness(2.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> INFERNAL = AoAArmourMaterials.register("infernal", Builder.armour(4, 7, 8, 3).toughness(3.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> KNIGHT = AoAArmourMaterials.register("knight", Builder.armour(4, 8, 9, 5).toughness(7.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> LUNAR = AoAArmourMaterials.register("lunar", Builder.armour(4, 7, 10, 5).toughness(7.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> LYNDAMYTE = AoAArmourMaterials.register("lyndamyte", Builder.armour(3, 6, 8, 3).toughness(2.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> LYONIC = AoAArmourMaterials.register("lyonic", Builder.armour(4, 7, 8, 4).toughness(5.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> MERCURIAL = AoAArmourMaterials.register("mercurial", Builder.armour(3, 8, 8, 3).toughness(3.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> NECRO = AoAArmourMaterials.register("necro", Builder.armour(5, 8, 9, 4).toughness(7.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> NETHENGEIC = AoAArmourMaterials.register("nethengeic", Builder.armour(3, 7, 8, 4).toughness(3.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> NIGHTMARE = AoAArmourMaterials.register("nightmare", Builder.armour(4, 9, 8, 5).toughness(7.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> OMNI = AoAArmourMaterials.register("omni", Builder.armour(3, 6, 8, 3).toughness(3.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> PHANTASM = AoAArmourMaterials.register("phantasm", Builder.armour(3, 8, 8, 5).toughness(5.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> POISON = AoAArmourMaterials.register("poison", Builder.armour(5, 6, 9, 4).toughness(5.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> PREDATIOUS = AoAArmourMaterials.register("predatious", Builder.armour(3, 7, 9, 3).toughness(3.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> PRIMORDIAL = AoAArmourMaterials.register("primordial", Builder.armour(5, 8, 9, 4).toughness(7.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> PURITY = AoAArmourMaterials.register("purity", Builder.armour(5, 8, 8, 3).toughness(7.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> ROCKBONE = AoAArmourMaterials.register("rockbone", Builder.armour(3, 7, 9, 3).toughness(3.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> ROSIDIAN = AoAArmourMaterials.register("rosidian", Builder.armour(4, 7, 9, 4).toughness(5.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> RUNIC = AoAArmourMaterials.register("runic", Builder.armour(5, 8, 9, 5).toughness(7.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> SHARPSHOT = AoAArmourMaterials.register("sharpshot", Builder.armour(4, 6, 9, 5).toughness(5.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> SKELETAL = AoAArmourMaterials.register("skeletal", Builder.armour(3, 7, 8, 4).toughness(3.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> SPACEKING = AoAArmourMaterials.register("spaceking", Builder.armour(4, 8, 9, 5).toughness(7.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> SPEED = AoAArmourMaterials.register("speed", Builder.armour(4, 9, 9, 3).toughness(7.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> SUBTERRANEAN = AoAArmourMaterials.register("subterranean", Builder.armour(3, 7, 8, 4).toughness(3.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> UTOPIAN = AoAArmourMaterials.register("utopian", Builder.armour(3, 6, 8, 3).toughness(2.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> VOID = AoAArmourMaterials.register("void", Builder.armour(3, 6, 8, 3).toughness(2.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> WEAKEN = AoAArmourMaterials.register("weaken", Builder.armour(4, 6, 8, 4).toughness(3.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> WITHER = AoAArmourMaterials.register("wither", Builder.armour(4, 8, 8, 4).toughness(5.0f));
    public static final DeferredHolder<ArmorMaterial, ArmorMaterial> ZARGONITE = AoAArmourMaterials.register("zargonite", Builder.armour(5, 8, 9, 4).toughness(7.0f));

    public static void init() {
    }

    private static DeferredHolder<ArmorMaterial, ArmorMaterial> register(String id, Builder builder) {
        ArmorMaterial.Layer baseLayer = new ArmorMaterial.Layer(AdventOfAscension.id(id));
        if (builder.layers == null) {
            builder.layers = Collections.singletonList(baseLayer);
        } else {
            builder.layers.addFirst(baseLayer);
        }
        return AoAArmourMaterials.register(id, builder::build);
    }

    private static DeferredHolder<ArmorMaterial, ArmorMaterial> register(String id, Supplier<ArmorMaterial> material) {
        return AoARegistries.ARMOUR_MATERIALS.register(id, material);
    }

    static class Builder {
        private final int bootsArmour;
        private final int legsArmour;
        private final int chestplateArmour;
        private final int helmetArmour;
        private int animalArmour = 0;
        private float toughness = 0.0f;
        private float knockbackResist = 0.0f;
        private int enchantValue = 10;
        private Holder<SoundEvent> equipSound = SoundEvents.ARMOR_EQUIP_GENERIC;
        private Supplier<Ingredient> repairIngredient = () -> Ingredient.EMPTY;
        private List<ArmorMaterial.Layer> layers;

        Builder(int bootsArmour, int legsArmour, int chestplateArmour, int helmetArmour) {
            this.bootsArmour = bootsArmour;
            this.legsArmour = legsArmour;
            this.chestplateArmour = chestplateArmour;
            this.helmetArmour = helmetArmour;
        }

        static Builder armour(int bootsArmour, int legsArmour, int chestplateArmour, int helmetArmour) {
            return new Builder(bootsArmour, legsArmour, chestplateArmour, helmetArmour);
        }

        static Builder helmet(int helmetArmour) {
            return Builder.armour(0, 0, 0, helmetArmour);
        }

        static Builder boots(int bootsArmour) {
            return Builder.armour(bootsArmour, 0, 0, 0);
        }

        Builder animalArmour(int armour) {
            this.animalArmour = armour;
            return this;
        }

        Builder toughness(float toughness) {
            this.toughness = toughness;
            return this;
        }

        Builder knockbackResist(float knockbackResist) {
            this.knockbackResist = knockbackResist;
            return this;
        }

        Builder enchantValue(int enchantValue) {
            this.enchantValue = enchantValue;
            return this;
        }

        Builder equipSound(Holder<SoundEvent> equipSound) {
            this.equipSound = equipSound;
            return this;
        }

        Builder repairIngredient(Holder<Item> item) {
            return this.repairIngredient((Item)item.value());
        }

        Builder repairIngredient(Item item) {
            return this.repairIngredient(() -> Ingredient.of((ItemLike[])new ItemLike[]{item}));
        }

        Builder repairIngredient(Supplier<Ingredient> ingredient) {
            this.repairIngredient = ingredient;
            return this;
        }

        Builder extraLayers(ArmorMaterial.Layer ... layers) {
            if (this.layers == null) {
                this.layers = new ObjectArrayList(layers.length);
            }
            this.layers.addAll(Arrays.asList(layers));
            return this;
        }

        ArmorMaterial build() {
            return new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
                map.put(ArmorItem.Type.BOOTS, this.bootsArmour);
                map.put(ArmorItem.Type.LEGGINGS, this.legsArmour);
                map.put(ArmorItem.Type.CHESTPLATE, this.chestplateArmour);
                map.put(ArmorItem.Type.HELMET, this.helmetArmour);
                map.put(ArmorItem.Type.BODY, this.animalArmour);
            }), this.enchantValue, this.equipSound, this.repairIngredient, this.layers, this.toughness, this.knockbackResist);
        }
    }
}

