/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration.entity.variant;

import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface VariantSpawnPredicate {
    public static final VariantSpawnPredicate ALWAYS = (level, difficulty, spawnReason, mob, biome, spawnData) -> true;
    public static final VariantSpawnPredicate NEVER = (level, difficulty, spawnReason, mob, biome, spawnData) -> false;

    public boolean canSpawnVariant(ServerLevel var1, DifficultyInstance var2, MobSpawnType var3, Entity var4, Supplier<Holder<Biome>> var5, @Nullable SpawnGroupData var6);

    public static VariantSpawnPredicate checkingBiome(Predicate<Holder<Biome>> predicate) {
        return (level, difficulty, spawnReason, mob, biome, spawnData) -> predicate.test((Holder)biome.get());
    }

    public static VariantSpawnPredicate randomChance(Function<RandomSource, Boolean> predicate) {
        return (level, difficulty, spawnReason, mob, biome, spawnData) -> (Boolean)predicate.apply(level.random);
    }

    public static VariantSpawnPredicate checkBasic(BiPredicate<ServerLevel, Entity> predicate) {
        return (level, difficulty, spawnReason, mob, biome, spawnData) -> predicate.test(level, mob);
    }
}

