/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration.entity.variant;

import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.entity.base.AoATrader;
import net.tslat.aoa3.content.entity.npc.trader.UndeadHeraldEntity;

public record UndeadHeraldTrade(Predicate<UndeadHeraldEntity> isApplicable, VillagerTrades.ItemListing trade) {
    public static final DeferredHolder<UndeadHeraldTrade, UndeadHeraldTrade> SHADOW_BANNER = UndeadHeraldTrade.register("shadow_banner", () -> new UndeadHeraldTrade(AoADimensions.ABYSS, (ItemLike)AoABlocks.SHADOW_BANNER.base));
    public static final DeferredHolder<UndeadHeraldTrade, UndeadHeraldTrade> BARON_BANNER = UndeadHeraldTrade.register("baron_banner", () -> new UndeadHeraldTrade(AoADimensions.BARATHOS, (ItemLike)AoABlocks.BARON_BANNER.base));
    public static final DeferredHolder<UndeadHeraldTrade, UndeadHeraldTrade> CANDY_BANNER = UndeadHeraldTrade.register("candy_banner", () -> new UndeadHeraldTrade(AoADimensions.CANDYLAND, (ItemLike)AoABlocks.CANDY_BANNER.base));
    public static final DeferredHolder<UndeadHeraldTrade, UndeadHeraldTrade> CLOWN_BANNER = UndeadHeraldTrade.register("clown_banner", () -> new UndeadHeraldTrade(AoADimensions.CELEVE, (ItemLike)AoABlocks.CLOWN_BANNER.base));
    public static final DeferredHolder<UndeadHeraldTrade, UndeadHeraldTrade> CREEPY_BANNER = UndeadHeraldTrade.register("creepy_banner", () -> new UndeadHeraldTrade(AoADimensions.CREEPONIA, (ItemLike)AoABlocks.CREEPY_BANNER.base));
    public static final DeferredHolder<UndeadHeraldTrade, UndeadHeraldTrade> CRYSTAL_BANNER = UndeadHeraldTrade.register("crystal_banner", () -> new UndeadHeraldTrade(AoADimensions.CRYSTEVIA, (ItemLike)AoABlocks.CRYSTAL_BANNER.base));
    public static final DeferredHolder<UndeadHeraldTrade, UndeadHeraldTrade> DEEP_BANNER = UndeadHeraldTrade.register("deep_banner", () -> new UndeadHeraldTrade(AoADimensions.DEEPLANDS, (ItemLike)AoABlocks.DEEP_BANNER.base));
    public static final DeferredHolder<UndeadHeraldTrade, UndeadHeraldTrade> DUSTOPIAN_BANNER = UndeadHeraldTrade.register("dustopian_banner", () -> new UndeadHeraldTrade(AoADimensions.DUSTOPIA, (ItemLike)AoABlocks.DUSTOPIAN_BANNER.base));
    public static final DeferredHolder<UndeadHeraldTrade, UndeadHeraldTrade> ROSIDIAN_BANNER = UndeadHeraldTrade.register("rosidian_banner", () -> new UndeadHeraldTrade(AoADimensions.GARDENCIA, (ItemLike)AoABlocks.ROSIDIAN_BANNER.base));
    public static final DeferredHolder<UndeadHeraldTrade, UndeadHeraldTrade> HAUNTED_BANNER = UndeadHeraldTrade.register("haunted_banner", () -> new UndeadHeraldTrade(AoADimensions.GRECKON, (ItemLike)AoABlocks.HAUNTED_BANNER.base));
    public static final DeferredHolder<UndeadHeraldTrade, UndeadHeraldTrade> UTOPIAN_BANNER = UndeadHeraldTrade.register("utopian_banner", () -> new UndeadHeraldTrade(AoADimensions.HAVEN, (ItemLike)AoABlocks.UTOPIAN_BANNER.base));
    public static final DeferredHolder<UndeadHeraldTrade, UndeadHeraldTrade> MECHA_BANNER = UndeadHeraldTrade.register("mecha_banner", () -> new UndeadHeraldTrade(AoADimensions.IROMINE, (ItemLike)AoABlocks.MECHA_BANNER.base));
    public static final DeferredHolder<UndeadHeraldTrade, UndeadHeraldTrade> BOREIC_BANNER = UndeadHeraldTrade.register("boreic_banner", () -> new UndeadHeraldTrade(AoADimensions.LBOREAN, (ItemLike)AoABlocks.BOREIC_BANNER.base));
    public static final DeferredHolder<UndeadHeraldTrade, UndeadHeraldTrade> LELYETIAN_BANNER = UndeadHeraldTrade.register("lelyetian_banner", () -> new UndeadHeraldTrade(AoADimensions.LELYETIA, (ItemLike)AoABlocks.LELYETIAN_BANNER.base));
    public static final DeferredHolder<UndeadHeraldTrade, UndeadHeraldTrade> LUNAR_BANNER = UndeadHeraldTrade.register("lunar_banner", () -> new UndeadHeraldTrade(AoADimensions.LUNALUS, (ItemLike)AoABlocks.LUNAR_BANNER.base));
    public static final DeferredHolder<UndeadHeraldTrade, UndeadHeraldTrade> FUNGAL_BANNER = UndeadHeraldTrade.register("fungal_banner", () -> new UndeadHeraldTrade(AoADimensions.MYSTERIUM, (ItemLike)AoABlocks.FUNGAL_BANNER.base));
    public static final DeferredHolder<UndeadHeraldTrade, UndeadHeraldTrade> NETHER_BANNER = UndeadHeraldTrade.register("nether_banner", () -> new UndeadHeraldTrade(AoADimensions.NETHER, (ItemLike)AoABlocks.NETHER_BANNER.base));
    public static final DeferredHolder<UndeadHeraldTrade, UndeadHeraldTrade> VOID_BANNER = UndeadHeraldTrade.register("void_banner", () -> new UndeadHeraldTrade(AoADimensions.OVERWORLD, (ItemLike)AoABlocks.VOID_BANNER.base));
    public static final DeferredHolder<UndeadHeraldTrade, UndeadHeraldTrade> ANCIENT_BANNER = UndeadHeraldTrade.register("ancient_banner", () -> new UndeadHeraldTrade(AoADimensions.PRECASIA, (ItemLike)AoABlocks.ANCIENT_BANNER.base));
    public static final DeferredHolder<UndeadHeraldTrade, UndeadHeraldTrade> RUNIC_BANNER = UndeadHeraldTrade.register("runic_banner", () -> new UndeadHeraldTrade(AoADimensions.RUNANDOR, (ItemLike)AoABlocks.RUNIC_BANNER.base));
    public static final DeferredHolder<UndeadHeraldTrade, UndeadHeraldTrade> SHYRE_BANNER = UndeadHeraldTrade.register("shyre_banner", () -> new UndeadHeraldTrade(AoADimensions.SHYRELANDS, (ItemLike)AoABlocks.SHYRE_BANNER.base));
    public static final DeferredHolder<UndeadHeraldTrade, UndeadHeraldTrade> VOX_BANNER = UndeadHeraldTrade.register("vox_banner", () -> new UndeadHeraldTrade(AoADimensions.VOX_PONDS, (ItemLike)AoABlocks.VOX_BANNER.base));

    public UndeadHeraldTrade(ResourceKey<Level> dimKey, ItemLike banner) {
        this((UndeadHeraldEntity herald) -> herald.level().dimension() == dimKey, AoATrader.BuildableTrade.forItem(banner).itemCost((ItemLike)AoAItems.SILVER_COIN, 4).stock(729).xp(20).priceMultiplier(0.05f));
    }

    private static DeferredHolder<UndeadHeraldTrade, UndeadHeraldTrade> register(String id, Supplier<UndeadHeraldTrade> trade) {
        return AoARegistries.UNDEAD_HERALD_TRADES.register(id, trade);
    }

    public static List<MerchantOffer> getExtraTradesFor(UndeadHeraldEntity herald) {
        return AoARegistries.UNDEAD_HERALD_TRADES.getAllRegisteredObjects().filter(trade -> trade.isApplicable().test(herald)).map(UndeadHeraldTrade::trade).map(listing -> listing.getOffer((Entity)herald, herald.getRandom())).toList();
    }

    public static void init() {
    }
}

