/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.entity.AoAAnimals;
import net.tslat.aoa3.common.registration.entity.AoAMiscEntities;
import net.tslat.aoa3.common.registration.entity.AoAMonsters;
import net.tslat.aoa3.common.registration.entity.AoANpcs;
import net.tslat.aoa3.content.entity.animal.ShinySquidEntity;
import net.tslat.aoa3.content.entity.animal.fish.BasicFishEntity;
import net.tslat.aoa3.content.entity.animal.fish.BasicLavaFishEntity;
import net.tslat.aoa3.content.entity.animal.precasia.DeinotheriumEntity;
import net.tslat.aoa3.content.entity.animal.precasia.HorndronEntity;
import net.tslat.aoa3.content.entity.misc.PixonEntity;
import net.tslat.aoa3.content.entity.monster.nether.EmbrakeEntity;
import net.tslat.aoa3.content.entity.monster.nether.FlamewalkerEntity;
import net.tslat.aoa3.content.entity.monster.nether.InfernalEntity;
import net.tslat.aoa3.content.entity.monster.nether.LittleBamEntity;
import net.tslat.aoa3.content.entity.monster.nether.NethengeicBeastEntity;
import net.tslat.aoa3.content.entity.monster.overworld.AncientGolemEntity;
import net.tslat.aoa3.content.entity.monster.overworld.BombCarrierEntity;
import net.tslat.aoa3.content.entity.monster.overworld.BushBabyEntity;
import net.tslat.aoa3.content.entity.monster.overworld.ChargerEntity;
import net.tslat.aoa3.content.entity.monster.overworld.ChomperEntity;
import net.tslat.aoa3.content.entity.monster.overworld.CyclopsEntity;
import net.tslat.aoa3.content.entity.monster.overworld.GhostEntity;
import net.tslat.aoa3.content.entity.monster.overworld.GoblinEntity;
import net.tslat.aoa3.content.entity.monster.overworld.IceGiantEntity;
import net.tslat.aoa3.content.entity.monster.overworld.KingChargerEntity;
import net.tslat.aoa3.content.entity.monster.overworld.LeafyGiantEntity;
import net.tslat.aoa3.content.entity.monster.overworld.SandGiantEntity;
import net.tslat.aoa3.content.entity.monster.overworld.SasquatchEntity;
import net.tslat.aoa3.content.entity.monster.overworld.StoneGiantEntity;
import net.tslat.aoa3.content.entity.monster.overworld.TreeSpiritEntity;
import net.tslat.aoa3.content.entity.monster.overworld.VoidWalkerEntity;
import net.tslat.aoa3.content.entity.monster.overworld.WoodGiantEntity;
import net.tslat.aoa3.content.entity.monster.overworld.YetiEntity;
import net.tslat.aoa3.content.entity.monster.precasia.AttercopusEntity;
import net.tslat.aoa3.content.entity.monster.precasia.DunkleosteusEntity;
import net.tslat.aoa3.content.entity.monster.precasia.MeganeuropsisEntity;
import net.tslat.aoa3.content.entity.monster.precasia.ScolopendisEntity;
import net.tslat.aoa3.content.entity.monster.precasia.SmilodonEntity;
import net.tslat.aoa3.content.entity.monster.precasia.SpinoledonEntity;
import net.tslat.aoa3.content.entity.monster.precasia.VeloraptorEntity;
import net.tslat.aoa3.content.entity.npc.trader.LottomanEntity;
import net.tslat.aoa3.content.entity.npc.trader.UndeadHeraldEntity;
import net.tslat.aoa3.util.WorldUtil;

public final class AoAEntitySpawnPlacements {
    private static final SpawnPlacementType AMPHIBIOUS = (level, pos, entityType) -> (level.getFluidState(pos).isEmpty() ? SpawnPlacementTypes.ON_GROUND : SpawnPlacementTypes.IN_WATER).isSpawnPositionOk(level, pos, entityType);

    public static void init() {
        AdventOfAscension.getModEventBus().addListener(AoAEntitySpawnPlacements::registerSpawnPlacements);
    }

    @SubscribeEvent
    private static void registerSpawnPlacements(RegisterSpawnPlacementsEvent ev) {
        AoAEntitySpawnPlacements.setOverworldSpawnPlacements(ev);
        AoAEntitySpawnPlacements.setNetherSpawnPlacements(ev);
        AoAEntitySpawnPlacements.setPrecasiaSpawnPlacements(ev);
        AoAEntitySpawnPlacements.setMiscSpawnPlacements(ev);
    }

    private static void setOverworldSpawnPlacements(RegisterSpawnPlacementsEvent ev) {
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.ANCIENT_GOLEM.get(), AncientGolemEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.BOMB_CARRIER.get(), BombCarrierEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.BUSH_BABY.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, BushBabyEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.CHARGER.get(), ChargerEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.CHOMPER.get(), AMPHIBIOUS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ChomperEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.CYCLOPS.get(), CyclopsEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.GHOST.get(), GhostEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.GOBLIN.get(), GoblinEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.ICE_GIANT.get(), IceGiantEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.KING_CHARGER.get(), KingChargerEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.LEAFY_GIANT.get(), LeafyGiantEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.SAND_GIANT.get(), SandGiantEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.SASQUATCH.get(), SasquatchEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.STONE_GIANT.get(), StoneGiantEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.TREE_SPIRIT.get(), TreeSpiritEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.VOID_WALKER.get(), VoidWalkerEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.WOOD_GIANT.get(), WoodGiantEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.YETI.get(), YetiEntity.spawnRules());
    }

    private static void setNetherSpawnPlacements(RegisterSpawnPlacementsEvent ev) {
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.EMBRAKE.get(), EmbrakeEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.FLAMEWALKER.get(), FlamewalkerEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.INFERNAL.get(), InfernalEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.LITTLE_BAM.get(), LittleBamEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.NETHENGEIC_BEAST.get(), NethengeicBeastEntity.spawnRules());
    }

    private static void setPrecasiaSpawnPlacements(RegisterSpawnPlacementsEvent ev) {
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.SPINOLEDON.get(), SpinoledonEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.HORNDRON.get(), HorndronEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.DEINOTHERIUM.get(), DeinotheriumEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.MEGANEUROPSIS.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING, MeganeuropsisEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.SCOLOPENDIS.get(), ScolopendisEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.SMILODON.get(), SmilodonEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.ATTERCOPUS.get(), AttercopusEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.VELORAPTOR.get(), VeloraptorEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMonsters.DUNKLEOSTEUS.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.OCEAN_FLOOR, DunkleosteusEntity.spawnRules());
    }

    private static void setMiscSpawnPlacements(RegisterSpawnPlacementsEvent ev) {
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.SHINY_SQUID.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ShinySquidEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, EntityType.SNIFFER, SpawnBuilder.DEFAULT_ANIMAL);
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoANpcs.LOTTOMAN.get(), LottomanEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoANpcs.UNDEAD_HERALD.get(), UndeadHeraldEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAMiscEntities.PIXON.get(), PixonEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.BLUE_GEMTRAP.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BasicFishEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.CANDLEFISH.get(), SpawnPlacementTypes.IN_LAVA, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BasicLavaFishEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.CHARRED_CHAR.get(), SpawnPlacementTypes.IN_LAVA, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BasicLavaFishEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.CHOCAW.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BasicFishEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.CRIMSON_SKIPPER.get(), SpawnPlacementTypes.IN_LAVA, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BasicLavaFishEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.CRIMSON_STRIPEFISH.get(), SpawnPlacementTypes.IN_LAVA, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BasicLavaFishEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.DARK_HATCHETFISH.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BasicFishEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.GREEN_GEMTRAP.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BasicFishEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.HYDRONE.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BasicFishEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.IRONBACK.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BasicFishEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.JAMFISH.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BasicFishEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.PARAPIRANHA.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BasicFishEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.PEARL_STRIPEFISH.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BasicFishEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.PURPLE_GEMTRAP.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BasicFishEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.RAINBOWFISH.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BasicFishEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.RAZORFISH.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BasicFishEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.RED_GEMTRAP.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BasicFishEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.REEFTOOTH.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BasicFishEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.ROCKETFISH.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BasicFishEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.SAILBACK.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BasicFishEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.SAPPHIRE_STRIDER.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BasicFishEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.SKELECANTH.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BasicFishEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.WHITE_GEMTRAP.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BasicFishEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.YELLOW_GEMTRAP.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BasicFishEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.TURQUOISE_STRIPEFISH.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BasicFishEntity.spawnRules());
        AoAEntitySpawnPlacements.register(ev, (EntityType)AoAAnimals.VIOLET_SKIPPER.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BasicFishEntity.spawnRules());
    }

    private static <T extends Entity> void register(RegisterSpawnPlacementsEvent ev, EntityType<T> entityType, SpawnPlacements.SpawnPredicate<?> predicate) {
        AoAEntitySpawnPlacements.register(ev, entityType, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, predicate);
    }

    private static <T extends Entity> void register(RegisterSpawnPlacementsEvent ev, EntityType<T> entityType, SpawnPlacementType type, Heightmap.Types heightmap, SpawnPlacements.SpawnPredicate<?> predicate) {
        ev.register(entityType, type, heightmap, predicate, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static final class SpawnBuilder<T extends Entity>
    implements SpawnPlacements.SpawnPredicate<T> {
        public static final SpawnBuilder<Entity> DEFAULT = new SpawnBuilder();
        public static final SpawnBuilder<Mob> DEFAULT_MONSTER = DEFAULT.noPeacefulSpawn().defaultMonsterLightLevels().ifValidSpawnBlock();
        public static final SpawnBuilder<Mob> DEFAULT_DAY_NIGHT_MONSTER = DEFAULT.noPeacefulSpawn().defaultMonsterBlockLightLevels().ifValidSpawnBlock();
        public static final SpawnBuilder<Mob> DEFAULT_DAY_MONSTER = DEFAULT_DAY_NIGHT_MONSTER.onlyDuringDay().difficultyBasedSpawnChance(0.12f);
        public static final SpawnBuilder<Entity> DEFAULT_ANIMAL = DEFAULT.animalSpawnRules();
        private final SpawnPlacements.SpawnPredicate<T> predicate;

        SpawnBuilder() {
            this((entityType, world, spawnType, pos, rand) -> true);
        }

        public SpawnBuilder(SpawnPlacements.SpawnPredicate<T> predicate) {
            this.predicate = predicate;
        }

        public boolean test(EntityType<T> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource rand) {
            return this.predicate.test(entityType, level, spawnType, pos, rand);
        }

        public SpawnBuilder<T> and(SpawnPlacements.SpawnPredicate<T> predicate) {
            return new SpawnBuilder<T>((entityType, level, spawnType, pos, rand) -> this.predicate.test(entityType, level, spawnType, pos, rand) && predicate.test(entityType, level, spawnType, pos, rand));
        }

        public SpawnBuilder<T> animalSpawnRules() {
            return this.and((entityType, level, spawnType, pos, rand) -> level.getBlockState(pos.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON) && (MobSpawnType.ignoresLightRequirements((MobSpawnType)spawnType) || level.getRawBrightness(pos, 0) > 8));
        }

        public SpawnBuilder<T> noPeacefulSpawn() {
            return this.and((entityType, level, spawnType, pos, rand) -> level.getDifficulty() != Difficulty.PEACEFUL);
        }

        public <M extends Mob> SpawnBuilder<M> ifValidSpawnBlock() {
            return this.and((entityType, level, spawnType, pos, rand) -> Mob.checkMobSpawnRules((EntityType)entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)rand));
        }

        public SpawnBuilder<T> noLowerThanY(int minY) {
            return this.and((entityType, level, spawnType, pos, rand) -> pos.getY() >= minY);
        }

        public SpawnBuilder<T> noHigherThanY(int maxY) {
            return this.and((entityType, level, spawnType, pos, rand) -> pos.getY() <= maxY);
        }

        public SpawnBuilder<T> betweenYLevels(int minY, int maxY) {
            return this.and((entityType, level, spawnType, pos, rand) -> pos.getY() >= minY && pos.getY() <= maxY);
        }

        public SpawnBuilder<T> spawnChance(float chance) {
            return this.and((entityType, level, spawnType, pos, rand) -> rand.nextFloat() < chance);
        }

        public SpawnBuilder<T> difficultyBasedSpawnChance(float chance) {
            return this.and((entityType, level, spawnType, pos, rand) -> rand.nextFloat() < chance * level.getCurrentDifficultyAt(pos).getEffectiveDifficulty());
        }

        public SpawnBuilder<T> noSpawnOn(TagKey<Block> blockTag) {
            return this.and((entityType, level, spawnType, pos, rand) -> !level.getBlockState(pos.below()).is(blockTag));
        }

        public SpawnBuilder<T> noSpawnOn(Block block) {
            return this.and((entityType, level, spawnType, pos, rand) -> !level.getBlockState(pos.below()).is(block));
        }

        public SpawnBuilder<T> onlySpawnOn(TagKey<Block> blockTag) {
            return this.and((entityType, level, spawnType, pos, rand) -> level.getBlockState(pos.below()).is(blockTag));
        }

        public SpawnBuilder<T> onlySpawnOn(Block block) {
            return this.and((entityType, level, spawnType, pos, rand) -> level.getBlockState(pos.below()).is(block));
        }

        public SpawnBuilder<T> onlySpawnIn(TagKey<Block> blockTag) {
            return this.and((entityType, level, spawnType, pos, rand) -> level.getBlockState(pos).is(blockTag));
        }

        public SpawnBuilder<T> onlySpawnIn(Block block) {
            return this.and((entityType, level, spawnType, pos, rand) -> level.getBlockState(pos).is(block));
        }

        public SpawnBuilder<T> onlySpawnUnder(TagKey<Block> blockTag) {
            return this.and((entityType, level, spawnType, pos, rand) -> level.getBlockState(pos.above()).is(blockTag));
        }

        public SpawnBuilder<T> onlySpawnUnder(Block block) {
            return this.and((entityType, level, spawnType, pos, rand) -> level.getBlockState(pos.above()).is(block));
        }

        public SpawnBuilder<T> minLightLevel(int lightLevel) {
            return this.and((entityType, level, spawnType, pos, rand) -> WorldUtil.getLightLevel(level, pos, false, false) >= lightLevel);
        }

        public SpawnBuilder<T> maxLightLevel(int lightLevel) {
            return this.and((entityType, level, spawnType, pos, rand) -> WorldUtil.getLightLevel(level, pos, false, false) <= lightLevel);
        }

        public SpawnBuilder<T> defaultMonsterLightLevels() {
            return this.and((entityType, level, spawnType, pos, rand) -> Monster.isDarkEnoughToSpawn((ServerLevelAccessor)level, (BlockPos)pos, (RandomSource)rand));
        }

        public SpawnBuilder<T> defaultMonsterBlockLightLevels() {
            return this.and((entityType, level, spawnType, pos, rand) -> WorldUtil.getLightLevel(level, pos, true, false) <= level.dimensionType().monsterSpawnBlockLightLimit());
        }

        public SpawnBuilder<T> onlyDuringDay() {
            return this.and((entityType, level, spawnType, pos, rand) -> level.getLevel().isDay());
        }
    }
}

