/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration.block.group;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.tslat.aoa3.common.registration.block.BlockRegistrar;
import net.tslat.aoa3.common.registration.block.group.BlockRegistrarFactory;

public final class SignBlockGroup {
    public final DeferredBlock<StandingSignBlock> freestanding;
    public final DeferredBlock<WallSignBlock> wall;
    public final DeferredBlock<CeilingHangingSignBlock> hanging;
    public final DeferredBlock<WallHangingSignBlock> wallHanging;

    public SignBlockGroup(String baseId, BlockRegistrarFactory registry, Consumer<BlockRegistrar<Block>> baseBlockRegistrar, WoodType woodType) {
        this.freestanding = registry.register(baseId + "_sign", baseBlockRegistrar.andThen(registrar -> registrar.itemFactory((block, properties) -> new SignItem(properties.stacksTo(16), block, (Block)this.wall()))));
        this.wall = registry.register(baseId + "_wall_sign", registrar -> registrar.baseSign(this.freestanding, false).noItem().useDropsFrom((Supplier<Block>)this.freestanding).factory(properties -> new WallSignBlock(woodType, properties)));
        this.hanging = registry.register(baseId + "_hanging_sign", registrar -> registrar.baseSign(this.freestanding, true).factory(properties -> new CeilingHangingSignBlock(woodType, properties)).itemFactory((block, properties) -> new HangingSignItem((Block)block, (Block)this.wallHanging(), properties.stacksTo(16))));
        this.wallHanging = registry.register(baseId + "_wall_hanging_sign", registrar -> registrar.baseSign(this.freestanding, true).noItem().useDropsFrom((Supplier<Block>)this.hanging).factory(properties -> new WallHangingSignBlock(woodType, properties)));
    }

    public StandingSignBlock standing() {
        return (StandingSignBlock)this.freestanding.get();
    }

    public WallSignBlock wall() {
        return (WallSignBlock)this.wall.get();
    }

    public CeilingHangingSignBlock hanging() {
        return (CeilingHangingSignBlock)this.hanging.get();
    }

    public WallHangingSignBlock wallHanging() {
        return (WallHangingSignBlock)this.wallHanging.get();
    }
}

