/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration.block;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ColorRGBA;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.tslat.aoa3.common.registration.block.AoABlockEntities;
import net.tslat.aoa3.common.registration.item.AoACreativeModeTabs;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.block.decoration.banner.BannerBlock;
import net.tslat.aoa3.content.block.generation.log.LogBlock;
import net.tslat.aoa3.content.block.generation.misc.StaticMushroomBlock;
import net.tslat.aoa3.content.block.generation.plants.GenericPlantBlock;
import net.tslat.aoa3.content.block.generation.plants.GenericWaterPlant;
import org.jetbrains.annotations.Nullable;

public final class BlockRegistrar<T extends Block> {
    private final List<Consumer<T>> callbacks = new ObjectArrayList();
    private DeferredBlock<T> registryObject = null;
    private BlockBehaviour.Properties properties = BlockBehaviour.Properties.of();
    private Function<BlockBehaviour.Properties, Block> factory = Block::new;
    ResourceKey<CreativeModeTab>[] creativeTabs = null;
    Item.Properties itemProperties = new Item.Properties();
    BiFunction<T, Item.Properties, ? extends Item> itemFactory = BlockItem::new;

    public BlockRegistrar<T> basedOn(DeferredBlock<? extends Block> block) {
        return this.basedOn((Block)block.get());
    }

    public BlockRegistrar<T> basedOn(Block block) {
        this.properties = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block);
        return this;
    }

    public BlockRegistrar<T> baseStone() {
        this.basedOn(Blocks.STONE);
        this.generationBlocksTab();
        return this;
    }

    public BlockRegistrar<T> baseCobblestone() {
        this.basedOn(Blocks.COBBLESTONE);
        this.generationBlocksTab();
        return this;
    }

    public BlockRegistrar<T> baseGrass() {
        this.basedOn(Blocks.GRASS_BLOCK);
        this.generationBlocksTab();
        return this;
    }

    public BlockRegistrar<T> baseDirt() {
        this.basedOn(Blocks.DIRT);
        this.generationBlocksTab();
        return this;
    }

    public BlockRegistrar<T> baseSand(int colour) {
        this.basedOn(Blocks.SAND);
        this.factory(properties -> new ColoredFallingBlock(new ColorRGBA(colour), properties));
        this.generationBlocksTab();
        return this;
    }

    public BlockRegistrar<T> baseLeaves() {
        this.mapColour(MapColor.PLANT);
        this.stats(0.2f);
        this.sounds(SoundType.GRASS);
        this.noOcclusion();
        this.specialSpawns((state, level, pos, entityType) -> entityType == EntityType.OCELOT || entityType == EntityType.PARROT);
        this.breathable();
        this.noScreenCover();
        this.flammable();
        this.pistonBreaks();
        this.noRedstone();
        this.generationBlocksTab();
        return this;
    }

    public BlockRegistrar<T> baseFlammable(final int spreadSpeed, final int flammability) {
        this.factory(properties -> new Block(this, (BlockBehaviour.Properties)properties){

            public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
                return spreadSpeed;
            }

            public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
                return flammability;
            }
        });
        return this;
    }

    public BlockRegistrar<T> baseLog(MapColor endColour, MapColor sideColour, Supplier<? extends Block> strippedBlock) {
        this.mapColour((BlockState state) -> state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? endColour : sideColour);
        this.factory(properties -> new LogBlock((BlockBehaviour.Properties)properties, strippedBlock));
        this.instrument(NoteBlockInstrument.BASS);
        this.stats(2.0f);
        this.sounds(SoundType.WOOD);
        this.flammable();
        this.generationBlocksTab();
        return this;
    }

    public BlockRegistrar<T> baseSapling() {
        this.basedOn(Blocks.OAK_SAPLING);
        this.utilityBlocksTab();
        return this;
    }

    public BlockRegistrar<T> baseMushroom() {
        this.mapColour(MapColor.PLANT);
        this.sounds(SoundType.FUNGUS);
        this.noClip();
        this.neverSolid();
        this.pistonBreaks();
        this.instabreak();
        this.factory(StaticMushroomBlock::new);
        this.needsPostPlacementCheck();
        this.generationBlocksTab();
        return this;
    }

    public BlockRegistrar<T> baseWaterPlant() {
        this.mapColour(MapColor.PLANT);
        this.sounds(SoundType.FUNGUS);
        this.noClip();
        this.neverSolid();
        this.pistonBreaks();
        this.modelOffset(BlockBehaviour.OffsetType.XZ);
        this.instabreak();
        this.replaceable();
        this.factory(GenericWaterPlant::new);
        this.generationBlocksTab();
        return this;
    }

    public BlockRegistrar<T> basePlant(Predicate<BlockState> validSurface, float width, float height) {
        this.mapColour(MapColor.PLANT);
        this.sounds(SoundType.GRASS);
        this.flammable();
        this.noClip();
        this.neverSolid();
        this.pistonBreaks();
        this.modelOffset(BlockBehaviour.OffsetType.XZ);
        this.instabreak();
        this.replaceable();
        this.factory(properties -> new GenericPlantBlock((BlockBehaviour.Properties)properties, validSurface, width, height));
        this.generationBlocksTab();
        return this;
    }

    public BlockRegistrar<T> basePlantOld() {
        this.mapColour(MapColor.PLANT);
        this.sounds(SoundType.GRASS);
        this.flammable();
        this.noClip();
        this.neverSolid();
        this.pistonBreaks();
        this.modelOffset(BlockBehaviour.OffsetType.XZ);
        this.instabreak();
        this.replaceable();
        this.factory(properties -> new BushBlock(this, (BlockBehaviour.Properties)properties){

            protected MapCodec<? extends BushBlock> codec() {
                return null;
            }
        });
        this.generationBlocksTab();
        return this;
    }

    public BlockRegistrar<T> baseStackablePlant(Function<BlockBehaviour.Properties, Block> factory) {
        this.basePlantOld();
        this.modelOffset(BlockBehaviour.OffsetType.NONE);
        this.factory(factory);
        return this;
    }

    public BlockRegistrar<T> baseFlower(@Nullable Holder<? extends MobEffect> potionEffect, int duration) {
        this.mapColour(MapColor.PLANT);
        this.sounds(SoundType.GRASS);
        this.noClip();
        this.instabreak();
        this.modelOffset(BlockBehaviour.OffsetType.XZ);
        this.pistonBreaks();
        this.factory(properties -> new FlowerBlock(potionEffect, (float)duration, properties));
        this.generationBlocksTab();
        return this;
    }

    public BlockRegistrar<T> baseOre(IntProvider xpProvider) {
        this.basedOn(Blocks.IRON_ORE);
        this.generationBlocksTab();
        this.factory(properties -> new DropExperienceBlock(xpProvider, properties));
        return this;
    }

    public BlockRegistrar<T> banner() {
        this.mapColour(MapColor.METAL);
        this.stats(0.5f, 1.0f);
        this.sounds(SoundType.WOOL);
        this.noClip();
        this.noOcclusion();
        this.pistonBreaks();
        this.alwaysSolid();
        this.factory(BannerBlock::new);
        this.instrument(NoteBlockInstrument.BASS);
        this.inTabs(AoACreativeModeTabs.BANNERS);
        return this;
    }

    public BlockRegistrar<T> basePottedPlant(Holder<? extends Block> plant) {
        this.basedOn(Blocks.FLOWER_POT);
        this.factory(properties -> new FlowerPotBlock(null, () -> ((Holder)plant).value(), properties));
        this.addPottedPlant(plant);
        this.noItem();
        return this;
    }

    public BlockRegistrar<T> baseCrop() {
        this.basedOn(Blocks.WHEAT);
        this.noItem();
        return this;
    }

    public BlockRegistrar<T> basePortal() {
        this.noClip();
        this.unbreakable();
        this.sounds(SoundType.GLASS);
        this.light(11);
        this.stopsPistons();
        this.utilityBlocksTab();
        return this;
    }

    public BlockRegistrar<T> baseGlass() {
        this.factory(TransparentBlock::new);
        this.stats(0.3f);
        this.sounds(SoundType.GLASS);
        this.instrument(NoteBlockInstrument.HAT);
        this.noOcclusion();
        this.breathable();
        this.noRedstone();
        this.noScreenCover();
        this.noSpawns();
        this.decorationBlocksTab();
        return this;
    }

    public BlockRegistrar<T> baseButton(DeferredBlock<? extends Block> base) {
        this.basedOn(base);
        this.noClip();
        this.stats(0.5f);
        this.pistonBreaks();
        this.utilityBlocksTab();
        return this;
    }

    public BlockRegistrar<T> basePressurePlate(DeferredBlock<? extends Block> base) {
        this.basedOn(base);
        this.alwaysSolid();
        this.instrument(NoteBlockInstrument.BASS);
        this.noClip();
        this.stats(0.5f);
        this.flammable();
        this.pistonBreaks();
        this.utilityBlocksTab();
        return this;
    }

    public BlockRegistrar<T> baseDoor(BlockSetType blockSet) {
        this.basedOn(Blocks.OAK_DOOR);
        this.factory(properties -> new DoorBlock(blockSet, properties));
        this.utilityBlocksTab();
        return this;
    }

    public BlockRegistrar<T> baseTrapdoor(BlockSetType blockSet) {
        this.basedOn(Blocks.OAK_TRAPDOOR);
        this.factory(properties -> new TrapDoorBlock(blockSet, properties));
        this.utilityBlocksTab();
        return this;
    }

    public BlockRegistrar<T> baseCarpet() {
        this.basedOn(Blocks.ORANGE_CARPET);
        this.decorationBlocksTab();
        return this;
    }

    public BlockRegistrar<T> baseRawOreBlock() {
        this.basedOn(Blocks.IRON_ORE);
        this.decorationBlocksTab();
        return this;
    }

    public BlockRegistrar<T> baseMineralBlock() {
        this.basedOn(Blocks.IRON_BLOCK);
        this.decorationBlocksTab();
        return this;
    }

    public BlockRegistrar<T> basePlanks() {
        this.basedOn(Blocks.OAK_PLANKS);
        this.factory(properties -> new Block(this, (BlockBehaviour.Properties)properties){

            public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
                return 5;
            }

            public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
                return 20;
            }
        });
        this.decorationBlocksTab();
        return this;
    }

    public BlockRegistrar<T> baseFence(DeferredBlock<? extends Block> block) {
        Block base = (Block)block.get();
        this.instrument(base.defaultBlockState().instrument());
        this.stats(base.defaultDestroyTime(), base.getExplosionResistance());
        this.sounds(base.defaultBlockState().getSoundType());
        this.mapColour(base.defaultMapColor());
        this.light(base.defaultBlockState().getLightEmission());
        this.alwaysSolid();
        this.decorationBlocksTab();
        this.factory(FenceBlock::new);
        if (base.defaultBlockState().ignitedByLava()) {
            this.flammable();
        }
        return this;
    }

    public BlockRegistrar<T> baseWall(DeferredBlock<? extends Block> block) {
        this.basedOn(block);
        this.alwaysSolid();
        this.factory(WallBlock::new);
        this.decorationBlocksTab();
        return this;
    }

    public BlockRegistrar<T> baseStairs(DeferredBlock<? extends Block> block) {
        this.basedOn(block);
        this.factory(properties -> new StairBlock(((Block)block.get()).defaultBlockState(), properties));
        this.decorationBlocksTab();
        return this;
    }

    public BlockRegistrar<T> baseSlab(DeferredBlock<? extends Block> block) {
        this.basedOn(block);
        this.factory(SlabBlock::new);
        this.decorationBlocksTab();
        return this;
    }

    public BlockRegistrar<T> baseSign(DeferredBlock<? extends Block> block, boolean hanging) {
        this.basedOn(block);
        this.alwaysSolid();
        this.instrument(NoteBlockInstrument.BASS);
        this.noClip();
        this.stats(1.0f);
        this.flammable();
        this.decorationBlocksTab();
        this.addToBlockEntity(hanging ? BlockEntityType.HANGING_SIGN : BlockEntityType.SIGN);
        return this;
    }

    public BlockRegistrar<T> baseBricks() {
        this.basedOn(Blocks.NETHER_BRICKS);
        this.decorationBlocksTab();
        return this;
    }

    public BlockRegistrar<T> baseLadder() {
        this.basedOn(Blocks.LADDER);
        this.factory(LadderBlock::new);
        this.utilityBlocksTab();
        return this;
    }

    public BlockRegistrar<T> itemFactory(BiFunction<T, Item.Properties, ? extends Item> factory) {
        this.itemFactory = factory;
        return this;
    }

    public BlockRegistrar<T> itemProperties(Consumer<Item.Properties> properties) {
        properties.accept(Objects.requireNonNull(this.itemProperties));
        return this;
    }

    public BlockRegistrar<T> noItem() {
        this.itemProperties = null;
        return this;
    }

    public BlockRegistrar<T> generationBlocksTab() {
        return this.inTabs(AoACreativeModeTabs.GENERATION_BLOCKS);
    }

    public BlockRegistrar<T> decorationBlocksTab() {
        return this.inTabs(AoACreativeModeTabs.DECORATION_BLOCKS);
    }

    public BlockRegistrar<T> utilityBlocksTab() {
        return this.inTabs(AoACreativeModeTabs.FUNCTIONAL_BLOCKS);
    }

    public BlockRegistrar<T> inTabs(DeferredHolder<CreativeModeTab, CreativeModeTab> ... tabs) {
        return this.inTabs((ResourceKey[])Arrays.stream(tabs).map(DeferredHolder::getKey).toArray(ResourceKey[]::new));
    }

    public BlockRegistrar<T> inTabs(ResourceKey<CreativeModeTab> ... tabs) {
        this.creativeTabs = tabs;
        return this;
    }

    public BlockRegistrar<T> replaceable() {
        this.properties.replaceable();
        return this;
    }

    public BlockRegistrar<T> noParticles() {
        this.properties.noTerrainParticles();
        return this;
    }

    public BlockRegistrar<T> instrument(NoteBlockInstrument instrument) {
        this.properties.instrument(instrument);
        return this;
    }

    public BlockRegistrar<T> alwaysSolid() {
        this.properties.forceSolidOn();
        return this;
    }

    public BlockRegistrar<T> neverSolid() {
        this.properties.forceSolidOff();
        return this;
    }

    public BlockRegistrar<T> needsPostPlacementCheck() {
        return this.needsPostPlacementCheck((state, level, pos) -> true);
    }

    public BlockRegistrar<T> needsPostPlacementCheck(BlockBehaviour.StatePredicate predicate) {
        this.properties.hasPostProcess(predicate);
        return this;
    }

    public BlockRegistrar<T> flammable() {
        this.properties.ignitedByLava();
        return this;
    }

    public BlockRegistrar<T> useDropsFrom(Supplier<? extends Block> block) {
        this.properties.lootFrom(block);
        return this;
    }

    public BlockRegistrar<T> liquid() {
        this.properties.liquid();
        return this;
    }

    public BlockRegistrar<T> noPistonPulling() {
        return this.pistonPush(PushReaction.PUSH_ONLY);
    }

    public BlockRegistrar<T> pistonDeletes() {
        return this.pistonPush(PushReaction.IGNORE);
    }

    public BlockRegistrar<T> stopsPistons() {
        return this.pistonPush(PushReaction.BLOCK);
    }

    public BlockRegistrar<T> pistonBreaks() {
        return this.pistonPush(PushReaction.DESTROY);
    }

    public BlockRegistrar<T> pistonPush(PushReaction pushing) {
        this.properties.pushReaction(pushing);
        return this;
    }

    public BlockRegistrar<T> air() {
        this.properties.air();
        return this;
    }

    public BlockRegistrar<T> emissive() {
        return this.emissive((state, world, pos) -> true);
    }

    public BlockRegistrar<T> emissive(BlockBehaviour.StatePredicate when) {
        this.properties.emissiveRendering(when);
        return this;
    }

    public BlockRegistrar<T> renderAdjust(BlockBehaviour.StatePredicate when) {
        this.properties.hasPostProcess(when);
        return this;
    }

    public BlockRegistrar<T> noScreenCover() {
        return this.coversScreen((state, world, pos) -> false);
    }

    public BlockRegistrar<T> coversScreen(BlockBehaviour.StatePredicate when) {
        this.properties.isViewBlocking(when);
        return this;
    }

    public BlockRegistrar<T> noRedstone() {
        return this.conductRedstone((state, world, pos) -> false);
    }

    public BlockRegistrar<T> conductRedstone(BlockBehaviour.StatePredicate when) {
        this.properties.isRedstoneConductor(when);
        return this;
    }

    public BlockRegistrar<T> noSpawns() {
        return this.specialSpawns((state, world, pos, entityType) -> false);
    }

    public BlockRegistrar<T> specialSpawns(BlockBehaviour.StateArgumentPredicate<EntityType<?>> when) {
        this.properties.isValidSpawn(when);
        return this;
    }

    public BlockRegistrar<T> breathable() {
        return this.suffocate((state, world, pos) -> false);
    }

    public BlockRegistrar<T> suffocate(BlockBehaviour.StatePredicate when) {
        this.properties.isSuffocating(when);
        return this;
    }

    public BlockRegistrar<T> unbreakable() {
        this.noDrops();
        return this.stats(-1.0f, 1.0E9f);
    }

    public BlockRegistrar<T> instabreak() {
        this.properties.instabreak();
        return this;
    }

    public BlockRegistrar<T> modelOffset(BlockBehaviour.OffsetType offset) {
        this.properties.offsetType(offset);
        return this;
    }

    public BlockRegistrar<T> noDrops() {
        this.properties.noLootTable();
        return this;
    }

    public BlockRegistrar<T> needsTool() {
        this.properties.requiresCorrectToolForDrops();
        return this;
    }

    public BlockRegistrar<T> dynamicShape() {
        this.properties.dynamicShape();
        return this;
    }

    public BlockRegistrar<T> randomTicks() {
        this.properties.randomTicks();
        return this;
    }

    public BlockRegistrar<T> stats(float hardness) {
        return this.stats(hardness, hardness);
    }

    public BlockRegistrar<T> stats(float hardness, float blastResist) {
        this.properties.strength(hardness, blastResist);
        return this;
    }

    public BlockRegistrar<T> light(int light) {
        return this.light(state -> light);
    }

    public BlockRegistrar<T> light(ToIntFunction<BlockState> light) {
        this.properties.lightLevel(light);
        return this;
    }

    public BlockRegistrar<T> sounds(SoundType sound) {
        this.properties.sound(sound);
        return this;
    }

    public BlockRegistrar<T> jumpMod(float modifier) {
        this.properties.jumpFactor(modifier);
        return this;
    }

    public BlockRegistrar<T> speedMod(float modifier) {
        this.properties.speedFactor(modifier);
        return this;
    }

    public BlockRegistrar<T> friction(float friction) {
        this.properties.friction(friction);
        return this;
    }

    public BlockRegistrar<T> noOcclusion() {
        this.properties.noOcclusion();
        return this;
    }

    public BlockRegistrar<T> noClip() {
        this.properties.noCollission();
        this.noScreenCover();
        return this;
    }

    public BlockRegistrar<T> mapColour(MapColor colour) {
        this.properties.mapColor(colour);
        return this;
    }

    public BlockRegistrar<T> mapColour(DyeColor colour) {
        this.properties.mapColor(colour);
        return this;
    }

    public BlockRegistrar<T> mapColour(Function<BlockState, MapColor> colour) {
        this.properties.mapColor(colour);
        return this;
    }

    public BlockRegistrar<T> factory(Function<BlockBehaviour.Properties, Block> factory) {
        this.factory = factory;
        return this;
    }

    public BlockRegistrar<T> addToBlockEntity(BlockEntityType<?> blockEntity) {
        this.callbacks.add(block -> AoABlockEntities.addBlockToExistingBlockEntityType(blockEntity, block));
        return this;
    }

    public BlockRegistrar<T> addPottedPlant(Holder<? extends Block> plant) {
        this.callbacks.add(block -> ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(plant.getKey().location(), this.registryObject));
        return this;
    }

    ResourceLocation getId() {
        return this.registryObject.getId();
    }

    T build(Consumer<BlockRegistrar<T>> registrar) {
        registrar.accept(this);
        if (this.itemProperties != null && this.registryObject != null) {
            AoAItems.registerItem(this.getId().getPath(), () -> this.itemFactory.apply((Block)this.registryObject.get(), this.itemProperties), this.creativeTabs);
        }
        return (T)this.factory.apply(this.properties);
    }

    void setRegistryObject(DeferredBlock<T> registryObject) {
        this.registryObject = registryObject;
    }

    T doCallbacks(T block) {
        this.callbacks.forEach(consumer -> consumer.accept(block));
        return block;
    }
}

