/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration.block;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.event.BlockEntityTypeAddBlocksEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.blockentity.BossAltarBlockEntity;
import net.tslat.aoa3.content.block.blockentity.ImbuingChamberBlockEntity;
import net.tslat.aoa3.content.block.blockentity.InfusedPressBlockEntity;
import net.tslat.aoa3.content.block.blockentity.InfusionTableBlockEntity;
import net.tslat.aoa3.content.block.blockentity.LunarCreationTableBlockEntity;
import net.tslat.aoa3.content.block.blockentity.TrophyBlockEntity;

public final class AoABlockEntities {
    private static final Multimap<BlockEntityType<?>, Block> VANILLA_BLOCK_ENTITY_BLOCK_REGISTRATIONS = MultimapBuilder.hashKeys().arrayListValues().build();
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TrophyBlockEntity>> TROPHY = AoABlockEntities.register("trophy", () -> BlockEntityType.Builder.of(TrophyBlockEntity::new, (Block[])new Block[]{(Block)AoABlocks.TROPHY.get(), (Block)AoABlocks.GOLD_TROPHY.get(), (Block)AoABlocks.ORNATE_TROPHY.get()}));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<LunarCreationTableBlockEntity>> LUNAR_CREATION_TABLE = AoABlockEntities.register("lunar_creation_table", () -> BlockEntityType.Builder.of(LunarCreationTableBlockEntity::new, (Block[])new Block[]{(Block)AoABlocks.LUNAR_CREATION_TABLE.get()}));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<InfusionTableBlockEntity>> INFUSION_TABLE = AoABlockEntities.register("infusion_table", () -> BlockEntityType.Builder.of(InfusionTableBlockEntity::new, (Block[])new Block[]{(Block)AoABlocks.INFUSION_TABLE.get()}));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<ImbuingChamberBlockEntity>> IMBUING_CHAMBER = AoABlockEntities.register("imbuing_chamber", () -> BlockEntityType.Builder.of(ImbuingChamberBlockEntity::new, (Block[])new Block[]{(Block)AoABlocks.IMBUING_CHAMBER.get()}));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<BossAltarBlockEntity>> BOSS_ALTAR = AoABlockEntities.register("boss_altar", () -> BlockEntityType.Builder.of(BossAltarBlockEntity::new, (Block[])new Block[]{(Block)AoABlocks.BOSS_ALTAR.get()}));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<InfusedPressBlockEntity>> INFUSED_PRESS = AoABlockEntities.register("infused_press", () -> BlockEntityType.Builder.of(InfusedPressBlockEntity::new, (Block[])new Block[]{(Block)AoABlocks.INFUSED_PRESS.get()}));

    public static void init() {
        AdventOfAscension.getModEventBus().addListener(AoABlockEntities::registerVanillaBlockEntityBlocks);
    }

    private static <T extends BlockEntity> DeferredHolder<BlockEntityType<?>, BlockEntityType<T>> register(String id, Supplier<BlockEntityType.Builder<T>> type) {
        return AoARegistries.BLOCK_ENTITIES.register(id, () -> ((BlockEntityType.Builder)type.get()).build(null));
    }

    private static void registerVanillaBlockEntityBlocks(BlockEntityTypeAddBlocksEvent ev) {
        for (BlockEntityType blockEntity : VANILLA_BLOCK_ENTITY_BLOCK_REGISTRATIONS.keySet()) {
            ev.modify(blockEntity, (Block[])VANILLA_BLOCK_ENTITY_BLOCK_REGISTRATIONS.get((Object)blockEntity).toArray(Block[]::new));
        }
        VANILLA_BLOCK_ENTITY_BLOCK_REGISTRATIONS.clear();
    }

    public static void addBlockToExistingBlockEntityType(BlockEntityType<?> blockEntityType, Block block) {
        VANILLA_BLOCK_ENTITY_BLOCK_REGISTRATIONS.put(blockEntityType, (Object)block);
    }
}

