/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration;

import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoAAdvancementTriggers;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.common.registration.AoACommands;
import net.tslat.aoa3.common.registration.AoADataAttachments;
import net.tslat.aoa3.common.registration.AoAMenus;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.AoAPoiTypes;
import net.tslat.aoa3.common.registration.AoARecipes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.block.AoABlockEntities;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.block.AoAFluidTypes;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.custom.AoAAspectFocus;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.common.registration.custom.AoAToastTypes;
import net.tslat.aoa3.common.registration.custom.AoAWorldEvents;
import net.tslat.aoa3.common.registration.entity.AoAAnimals;
import net.tslat.aoa3.common.registration.entity.AoABrainActivities;
import net.tslat.aoa3.common.registration.entity.AoABrainMemories;
import net.tslat.aoa3.common.registration.entity.AoABrainSensors;
import net.tslat.aoa3.common.registration.entity.AoACustomSpawners;
import net.tslat.aoa3.common.registration.entity.AoAEntityDataSerializers;
import net.tslat.aoa3.common.registration.entity.AoAMiscEntities;
import net.tslat.aoa3.common.registration.entity.AoAMobEffects;
import net.tslat.aoa3.common.registration.entity.AoAMonsters;
import net.tslat.aoa3.common.registration.entity.AoANpcs;
import net.tslat.aoa3.common.registration.entity.AoAProfessions;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.common.registration.entity.variant.ChargerVariant;
import net.tslat.aoa3.common.registration.entity.variant.DryadSpriteVariant;
import net.tslat.aoa3.common.registration.entity.variant.PixonVariant;
import net.tslat.aoa3.common.registration.entity.variant.UndeadHeraldTrade;
import net.tslat.aoa3.common.registration.entity.variant.VeloraptorVariant;
import net.tslat.aoa3.common.registration.item.AoAArmour;
import net.tslat.aoa3.common.registration.item.AoAArmourMaterials;
import net.tslat.aoa3.common.registration.item.AoACreativeModeTabs;
import net.tslat.aoa3.common.registration.item.AoADataComponents;
import net.tslat.aoa3.common.registration.item.AoAEnchantments;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.item.AoATools;
import net.tslat.aoa3.common.registration.item.AoAWeapons;
import net.tslat.aoa3.common.registration.loot.AoALootConditions;
import net.tslat.aoa3.common.registration.loot.AoALootEntryTypes;
import net.tslat.aoa3.common.registration.loot.AoALootFunctions;
import net.tslat.aoa3.common.registration.loot.AoALootModifiers;
import net.tslat.aoa3.common.registration.worldgen.AoABiomeModifiers;
import net.tslat.aoa3.common.registration.worldgen.AoABlockPredicateTypes;
import net.tslat.aoa3.common.registration.worldgen.AoAChunkGenerators;
import net.tslat.aoa3.common.registration.worldgen.AoAFeatures;
import net.tslat.aoa3.common.registration.worldgen.AoAPlacementModifiers;
import net.tslat.aoa3.common.registration.worldgen.AoAStructurePlacements;
import net.tslat.aoa3.common.registration.worldgen.AoAStructureProcessors;
import net.tslat.aoa3.common.registration.worldgen.AoAStructureTypes;
import net.tslat.aoa3.common.registration.worldgen.AoATrees;
import net.tslat.aoa3.common.toast.CustomToastData;
import net.tslat.aoa3.content.skill.hauling.HaulingSpawnPool;
import net.tslat.aoa3.content.world.event.AoAWorldEvent;
import net.tslat.aoa3.content.world.nowhere.NowhereBossArena;
import net.tslat.aoa3.content.world.nowhere.NowhereParkourCourse;
import net.tslat.aoa3.content.world.spawner.AoACustomSpawner;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AoARegistries {
    public static final ResourceKey<Registry<AoASkill>> SKILLS_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)AdventOfAscension.id("skills"));
    public static final ResourceKey<Registry<AoAResource>> RESOURCES_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)AdventOfAscension.id("resources"));
    public static final ResourceKey<Registry<AoAAbility>> ABILITIES_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)AdventOfAscension.id("abilities"));
    public static final ResourceKey<Registry<AoAAspectFocus>> ASPECT_FOCI_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)AdventOfAscension.id("aspect_focus"));
    public static final ResourceKey<Registry<AoAWorldEvent.Type<?>>> WORLD_EVENT_TYPE_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)AdventOfAscension.id("world_event_type"));
    public static final ResourceKey<Registry<CustomToastData.Type<?>>> CUSTOM_TOAST_DATA_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)AdventOfAscension.id("custom_toasts"));
    public static final ResourceKey<Registry<AoACustomSpawner.Type<?>>> CUSTOM_SPAWNER_TYPE_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)AdventOfAscension.id("custom_spawner_type"));
    public static final ResourceKey<Registry<AoACustomSpawner<?>>> CUSTOM_SPAWNERS_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)AdventOfAscension.id("custom_spawner"));
    public static final ResourceKey<Registry<NowhereBossArena>> NOWHERE_BOSS_ARENAS_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)AdventOfAscension.id("nowhere_boss_arena"));
    public static final ResourceKey<Registry<NowhereParkourCourse>> NOWHERE_PARKOUR_COURSES_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)AdventOfAscension.id("nowhere_parkour_course"));
    public static final ResourceKey<Registry<AoAWorldEvent>> WORLD_EVENTS_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)AdventOfAscension.id("world_event"));
    public static final ResourceKey<Registry<HaulingSpawnPool>> HAULING_SPAWN_POOLS_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)AdventOfAscension.id("hauling_spawn_pool"));
    public static final ResourceKey<Registry<ChargerVariant>> CHARGER_VARIANTS_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)AdventOfAscension.id("charger_variant"));
    public static final ResourceKey<Registry<VeloraptorVariant>> VELORAPTOR_VARIANTS_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)AdventOfAscension.id("veloraptor_variant"));
    public static final ResourceKey<Registry<PixonVariant>> PIXON_VARIANTS_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)AdventOfAscension.id("pixon_variant"));
    public static final ResourceKey<Registry<DryadSpriteVariant>> DRYAD_SPRITE_VARIANTS_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)AdventOfAscension.id("dryad_sprite_variant"));
    public static final ResourceKey<Registry<UndeadHeraldTrade>> UNDEAD_HERALD_TRADES_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)AdventOfAscension.id("undead_herald_trade"));
    public static final RegistryHelper<CreativeModeTab> CREATIVE_MODE_TABS = new RegistryHelper(Registries.CREATIVE_MODE_TAB, AoACreativeModeTabs::init);
    public static final RegistryHelper<EntityDataSerializer<?>> ENTITY_DATA_SERIALIZERS = new RegistryHelper(NeoForgeRegistries.Keys.ENTITY_DATA_SERIALIZERS, AoAEntityDataSerializers::init);
    public static final RegistryHelper<Block> BLOCKS = new RegistryHelper(Registries.BLOCK, (registryKey, modId) -> DeferredRegister.createBlocks((String)modId), AoABlocks::init);
    public static final RegistryHelper<ArmorMaterial> ARMOUR_MATERIALS = new RegistryHelper(Registries.ARMOR_MATERIAL, AoAArmourMaterials::init);
    public static final RegistryHelper<Item> ITEMS = new RegistryHelper(Registries.ITEM, (registryKey, modId) -> DeferredRegister.createItems((String)modId), AoAItems::init, AoAWeapons::init, AoATools::init, AoAArmour::init);
    public static final RegistryHelper<Fluid> FLUIDS = new RegistryHelper(Registries.FLUID, new Runnable[0]);
    public static final RegistryHelper<EntityType<?>> ENTITIES = new RegistryHelper(Registries.ENTITY_TYPE, AoAMonsters::init, AoAAnimals::init, AoANpcs::init, AoAMiscEntities::init, AoAProjectiles::init);
    public static final RegistryHelper<BlockEntityType<?>> BLOCK_ENTITIES = new RegistryHelper(Registries.BLOCK_ENTITY_TYPE, AoABlockEntities::init);
    public static final RegistryHelper<SoundEvent> SOUNDS = new RegistryHelper(Registries.SOUND_EVENT, AoASounds::init);
    public static final RegistryHelper<ParticleType<?>> PARTICLES = new RegistryHelper(Registries.PARTICLE_TYPE, AoAParticleTypes::init);
    public static final RegistryHelper<MenuType<?>> MENUS = new RegistryHelper(Registries.MENU, AoAMenus::init);
    public static final RegistryHelper<RecipeSerializer<?>> RECIPE_SERIALIZERS = new RegistryHelper(Registries.RECIPE_SERIALIZER, AoARecipes::init);
    public static final RegistryHelper<MapCodec<? extends IGlobalLootModifier>> LOOT_MODIFIERS = new RegistryHelper(NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, AoALootModifiers::init);
    public static final RegistryHelper<Attribute> ENTITY_ATTRIBUTES = new RegistryHelper(Registries.ATTRIBUTE, AoAAttributes::init);
    public static final RegistryHelper<PoiType> POI_TYPES = new RegistryHelper(Registries.POINT_OF_INTEREST_TYPE, AoAPoiTypes::init);
    public static final RegistryHelper<VillagerProfession> VILLAGER_PROFESSIONS = new RegistryHelper(Registries.VILLAGER_PROFESSION, AoAProfessions::init);
    public static final RegistryHelper<Activity> BRAIN_ACTIVITIES = new RegistryHelper(Registries.ACTIVITY, AoABrainActivities::init);
    public static final RegistryHelper<SensorType<?>> BRAIN_SENSORS = new RegistryHelper(Registries.SENSOR_TYPE, AoABrainSensors::init);
    public static final RegistryHelper<MemoryModuleType<?>> BRAIN_MEMORIES = new RegistryHelper(Registries.MEMORY_MODULE_TYPE, AoABrainMemories::init);
    public static final RegistryHelper<FluidType> FLUID_TYPES = new RegistryHelper(NeoForgeRegistries.Keys.FLUID_TYPES, AoAFluidTypes::init);
    public static final RegistryHelper<MobEffect> MOB_EFFECTS = new RegistryHelper(Registries.MOB_EFFECT, AoAMobEffects::init);
    public static final RegistryHelper<DataComponentType<?>> ENCHANTMENT_EFFECT_COMPONENTS = new RegistryHelper(Registries.ENCHANTMENT_EFFECT_COMPONENT_TYPE, AoAEnchantments::init);
    public static final RegistryHelper<MapCodec<? extends EnchantmentValueEffect>> ENCHANTMENT_VALUE_EFFECTS = new RegistryHelper(Registries.ENCHANTMENT_VALUE_EFFECT_TYPE, AoAEnchantments::init);
    public static final RegistryHelper<DataComponentType<?>> DATA_COMPONENTS = new RegistryHelper(Registries.DATA_COMPONENT_TYPE, AoADataComponents::init);
    public static final RegistryHelper<AttachmentType<?>> DATA_ATTACHMENTS = new RegistryHelper(NeoForgeRegistries.Keys.ATTACHMENT_TYPES, AoADataAttachments::init);
    public static final RegistryHelper<LootItemFunctionType<?>> LOOT_FUNCTIONS = new RegistryHelper(Registries.LOOT_FUNCTION_TYPE, AoALootFunctions::init);
    public static final RegistryHelper<LootItemConditionType> LOOT_CONDITIONS = new RegistryHelper(Registries.LOOT_CONDITION_TYPE, AoALootConditions::init);
    public static final RegistryHelper<LootPoolEntryType> LOOT_ENTRY_TYPES = new RegistryHelper(Registries.LOOT_POOL_ENTRY_TYPE, AoALootEntryTypes::init);
    public static final RegistryHelper<RecipeType<?>> RECIPE_TYPES = new RegistryHelper(Registries.RECIPE_TYPE, AoARecipes::init);
    public static final RegistryHelper<ArgumentTypeInfo<?, ?>> ARGUMENT_TYPES = new RegistryHelper(Registries.COMMAND_ARGUMENT_TYPE, AoACommands::init);
    public static final RegistryHelper<CriterionTrigger<?>> ADVANCEMENT_CRITERIA = new RegistryHelper(Registries.TRIGGER_TYPE, AoAAdvancementTriggers::init);
    public static final RegistryHelper<Feature<?>> FEATURES = new RegistryHelper(Registries.FEATURE, AoAFeatures::init);
    public static final RegistryHelper<StructureType<?>> STRUCTURE_TYPES = new RegistryHelper(Registries.STRUCTURE_TYPE, AoAStructureTypes::init);
    public static final RegistryHelper<PlacementModifierType<?>> PLACEMENT_MODIFIERS = new RegistryHelper(Registries.PLACEMENT_MODIFIER_TYPE, AoAPlacementModifiers::init);
    public static final RegistryHelper<MapCodec<? extends BiomeModifier>> BIOME_MODIFIERS = new RegistryHelper(NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, AoABiomeModifiers::init);
    public static final RegistryHelper<StructurePlacementType<?>> STRUCTURE_PLACEMENTS = new RegistryHelper(Registries.STRUCTURE_PLACEMENT, AoAStructurePlacements::init);
    public static final RegistryHelper<StructureProcessorType<?>> STRUCTURE_PROCESSORS = new RegistryHelper(Registries.STRUCTURE_PROCESSOR, AoAStructureProcessors::init);
    public static final RegistryHelper<MapCodec<? extends ChunkGenerator>> CHUNK_GENERATORS = new RegistryHelper(Registries.CHUNK_GENERATOR, AoAChunkGenerators::init);
    public static final RegistryHelper<TrunkPlacerType<?>> TRUNK_PLACERS = new RegistryHelper(Registries.TRUNK_PLACER_TYPE, AoATrees::init);
    public static final RegistryHelper<FoliagePlacerType<?>> FOLIAGE_PLACERS = new RegistryHelper(Registries.FOLIAGE_PLACER_TYPE, AoATrees::init);
    public static final RegistryHelper<TreeDecoratorType<?>> TREE_DECORATORS = new RegistryHelper(Registries.TREE_DECORATOR_TYPE, AoATrees::init);
    public static final RegistryHelper<BlockPredicateType<?>> BLOCK_PREDICATE_TYPE = new RegistryHelper(Registries.BLOCK_PREDICATE_TYPE, AoABlockPredicateTypes::init);
    public static final RegistryHelper<ChargerVariant> CHARGER_VARIANTS = new RegistryHelper<ChargerVariant>(CHARGER_VARIANTS_REGISTRY_KEY, ChargerVariant::init);
    public static final RegistryHelper<VeloraptorVariant> VELORAPTOR_VARIANTS = new RegistryHelper<VeloraptorVariant>(VELORAPTOR_VARIANTS_REGISTRY_KEY, VeloraptorVariant::init);
    public static final RegistryHelper<PixonVariant> PIXON_VARIANTS = new RegistryHelper<PixonVariant>(PIXON_VARIANTS_REGISTRY_KEY, PixonVariant::init);
    public static final RegistryHelper<DryadSpriteVariant> DRYAD_SPRITE_VARIANTS = new RegistryHelper<DryadSpriteVariant>(DRYAD_SPRITE_VARIANTS_REGISTRY_KEY, DryadSpriteVariant::init);
    public static final RegistryHelper<UndeadHeraldTrade> UNDEAD_HERALD_TRADES = new RegistryHelper<UndeadHeraldTrade>(UNDEAD_HERALD_TRADES_REGISTRY_KEY, UndeadHeraldTrade::init);
    public static final RegistryHelper<AoASkill> AOA_SKILLS = new RegistryHelper<AoASkill>(SKILLS_REGISTRY_KEY, AoASkills::init);
    public static final RegistryHelper<AoAResource> AOA_RESOURCES = new RegistryHelper<AoAResource>(RESOURCES_REGISTRY_KEY, AoAResources::init);
    public static final RegistryHelper<AoAAbility> AOA_ABILITIES = new RegistryHelper<AoAAbility>(ABILITIES_REGISTRY_KEY, AoAAbilities::init);
    public static final RegistryHelper<AoAAspectFocus> AOA_ASPECT_FOCI = new RegistryHelper<AoAAspectFocus>(ASPECT_FOCI_REGISTRY_KEY, AoAAspectFocus::init);
    public static final RegistryHelper<CustomToastData.Type<?>> CUSTOM_TOAST_TYPES = new RegistryHelper(CUSTOM_TOAST_DATA_REGISTRY_KEY, AoAToastTypes::init);
    public static final RegistryHelper<AoACustomSpawner.Type<?>> CUSTOM_SPAWNER_TYPES = new RegistryHelper(CUSTOM_SPAWNER_TYPE_REGISTRY_KEY, AoACustomSpawners::init);
    public static final RegistryHelper<AoAWorldEvent.Type<?>> WORLD_EVENT_TYPES = new RegistryHelper(WORLD_EVENT_TYPE_REGISTRY_KEY, AoAWorldEvents::init);

    public static void init() {
        RegistryHelper.REGISTRY_INIT_TASKS.forEach(Runnable::run);
        RegistryHelper.REGISTRY_INIT_TASKS.clear();
        AdventOfAscension.getModEventBus().addListener(EventPriority.NORMAL, false, NewRegistryEvent.class, AoARegistries::createCustomRegistries);
        AdventOfAscension.getModEventBus().addListener(EventPriority.NORMAL, false, DataPackRegistryEvent.NewRegistry.class, AoARegistries::createCustomDatapackRegistries);
    }

    private static void createCustomRegistries(NewRegistryEvent ev) {
        ev.create(new RegistryBuilder(ABILITIES_REGISTRY_KEY).maxId(0x7FFFFFFE).sync(true));
        ev.create(new RegistryBuilder(RESOURCES_REGISTRY_KEY).maxId(0x7FFFFFFE).sync(true));
        ev.create(new RegistryBuilder(SKILLS_REGISTRY_KEY).maxId(0x7FFFFFFE).sync(true));
        ev.create(new RegistryBuilder(ASPECT_FOCI_REGISTRY_KEY).maxId(0x7FFFFFFE).sync(true));
        ev.create(new RegistryBuilder(WORLD_EVENT_TYPE_REGISTRY_KEY).maxId(0x7FFFFFFE).sync(true));
        ev.create(new RegistryBuilder(CUSTOM_TOAST_DATA_REGISTRY_KEY).maxId(0x7FFFFFFE).sync(true));
        ev.create(new RegistryBuilder(CHARGER_VARIANTS_REGISTRY_KEY).maxId(0x7FFFFFFE).sync(true));
        ev.create(new RegistryBuilder(VELORAPTOR_VARIANTS_REGISTRY_KEY).maxId(0x7FFFFFFE).sync(true));
        ev.create(new RegistryBuilder(PIXON_VARIANTS_REGISTRY_KEY).maxId(0x7FFFFFFE).sync(true));
        ev.create(new RegistryBuilder(DRYAD_SPRITE_VARIANTS_REGISTRY_KEY).maxId(0x7FFFFFFE).sync(true));
        ev.create(new RegistryBuilder(UNDEAD_HERALD_TRADES_REGISTRY_KEY).sync(false).maxId(0x7FFFFFFE));
        ev.create(new RegistryBuilder(CUSTOM_SPAWNER_TYPE_REGISTRY_KEY).sync(false).maxId(0x7FFFFFFE));
    }

    private static void createCustomDatapackRegistries(DataPackRegistryEvent.NewRegistry ev) {
        ev.dataPackRegistry(CUSTOM_SPAWNERS_REGISTRY_KEY, AoACustomSpawners.CODEC, AoACustomSpawners.CODEC);
        ev.dataPackRegistry(NOWHERE_BOSS_ARENAS_REGISTRY_KEY, NowhereBossArena.CODEC, NowhereBossArena.CODEC);
        ev.dataPackRegistry(NOWHERE_PARKOUR_COURSES_REGISTRY_KEY, NowhereParkourCourse.CODEC, NowhereParkourCourse.CODEC);
        ev.dataPackRegistry(WORLD_EVENTS_REGISTRY_KEY, AoAWorldEvents.CODEC, AoAWorldEvents.CODEC);
        ev.dataPackRegistry(HAULING_SPAWN_POOLS_REGISTRY_KEY, HaulingSpawnPool.CODEC, HaulingSpawnPool.CODEC);
    }

    public record RegistryHelper<T>(Supplier<Registry<T>> registry, DeferredRegister<T> deferredRegister, Runnable registrationTasks) implements IdMap<T>,
    Keyable
    {
        private static final List<Runnable> REGISTRY_INIT_TASKS = new ObjectArrayList();

        private RegistryHelper(ResourceKey<Registry<T>> registryKey, Runnable ... registrations) {
            this(registryKey, DeferredRegister::create, registrations);
        }

        private RegistryHelper(ResourceKey<Registry<T>> registryKey, BiFunction<ResourceKey<Registry<T>>, String, DeferredRegister<T>> defRegFactory, Runnable ... registrations) {
            this((Supplier<Registry<T>>)Suppliers.memoize(() -> (Registry)BuiltInRegistries.REGISTRY.get(registryKey.location())), defRegFactory.apply(registryKey, "aoa3"), () -> Arrays.asList(registrations).forEach(Runnable::run));
            REGISTRY_INIT_TASKS.add(() -> this.deferredRegister().register(AdventOfAscension.getModEventBus()));
            REGISTRY_INIT_TASKS.add(this.registrationTasks);
        }

        public <I extends T, H extends DeferredHolder<T, I>> H register(String id, Supplier<? extends I> object) {
            return (H)this.deferredRegister().register(id, object);
        }

        public Set<ResourceLocation> getAllIds() {
            return this.registry().get().keySet();
        }

        public Stream<T> getAllRegisteredObjects() {
            return this.registry().get().stream();
        }

        public List<DeferredHolder<T, ? extends T>> getAllAoARegisteredObjects() {
            return this.deferredRegister().getEntries().stream().toList();
        }

        public boolean hasRegisteredId(ResourceLocation id) {
            return this.registry().get().containsKey(id);
        }

        @Nullable
        public T getEntry(ResourceLocation id) {
            return (T)this.registry().get().get(id);
        }

        @Nullable
        public Holder<T> getHolder(ResourceLocation id) {
            return this.registry().get().getHolder(id).orElse(null);
        }

        public ResourceLocation getKey(T object) {
            return this.registry().get().getKey(object);
        }

        public Holder<T> wrapAsHolder(T object) {
            return this.registry().get().wrapAsHolder(object);
        }

        public Codec<T> lookupCodec() {
            return this.registry().get().byNameCodec();
        }

        public int getId(T value) {
            return this.registry().get().getId(value);
        }

        @NotNull
        public Iterator<T> iterator() {
            return this.registry().get().iterator();
        }

        @Nullable
        public T byId(int id) {
            return (T)this.registry().get().byId(id);
        }

        public int size() {
            return this.registry().get().size();
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return this.registry().get().keys(ops);
        }

        public Optional<Holder.Reference<T>> getRandomElement(RandomSource random) {
            return this.registry().get().getRandom(random);
        }

        public ResourceKey<? extends Registry<T>> key() {
            return this.deferredRegister().getRegistryKey();
        }
    }
}

