/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration;

import java.util.function.Supplier;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.content.recipe.ArcanumBatteryAttachRecipe;
import net.tslat.aoa3.content.recipe.AshfernCookingRecipe;
import net.tslat.aoa3.content.recipe.GoldTrophyRecipe;
import net.tslat.aoa3.content.recipe.ImbuingRecipe;
import net.tslat.aoa3.content.recipe.InfusedPressCompressionRecipe;
import net.tslat.aoa3.content.recipe.InfusedPressDecompressionRecipe;
import net.tslat.aoa3.content.recipe.InfusionRecipe;
import net.tslat.aoa3.content.recipe.StaffChargingRecipe;
import net.tslat.aoa3.content.recipe.ToolInteractionRecipe;
import net.tslat.aoa3.content.recipe.UpgradeKitRecipe;
import net.tslat.aoa3.content.recipe.WhitewashingRecipe;

public final class AoARecipes {
    public static final RecipeTypeContainer<UpgradeKitRecipe> UPGRADE_KIT = AoARecipes.registerRecipeType("upgrade_kit", UpgradeKitRecipe.Factory::new);
    public static final RecipeTypeContainer<InfusionRecipe> INFUSION = AoARecipes.registerRecipeType("infusion", InfusionRecipe.Factory::new);
    public static final RecipeTypeContainer<ImbuingRecipe> IMBUING = AoARecipes.registerRecipeType("imbuing", ImbuingRecipe.Factory::new);
    public static final RecipeTypeContainer<GoldTrophyRecipe> GOLD_TROPHY = AoARecipes.registerRecipeType("gold_trophy", GoldTrophyRecipe.Factory::new);
    public static final RecipeTypeContainer<ToolInteractionRecipe> TOOL_INTERACTION = AoARecipes.registerRecipeType("tool_interaction", ToolInteractionRecipe.Factory::new);
    public static final RecipeTypeContainer<AshfernCookingRecipe> ASHFERN_COOKING = AoARecipes.registerRecipeType("ashfern_cooking", AshfernCookingRecipe.Factory::new);
    public static final RecipeTypeContainer<WhitewashingRecipe> WHITEWASHING = AoARecipes.registerRecipeType("whitewashing", WhitewashingRecipe.Factory::new);
    public static final RecipeTypeContainer<InfusedPressCompressionRecipe> INFUSED_PRESS_COMPRESSION = AoARecipes.registerRecipeType("infused_press_compression", InfusedPressCompressionRecipe.Factory::new);
    public static final RecipeTypeContainer<InfusedPressDecompressionRecipe> INFUSED_PRESS_DECOMPRESSION = AoARecipes.registerRecipeType("infused_press_decompression", InfusedPressDecompressionRecipe.Factory::new);
    public static final RecipeTypeContainer<StaffChargingRecipe> STAFF_CHARGING = AoARecipes.registerRecipeType("staff_charging", StaffChargingRecipe.Factory::new);
    public static final RecipeTypeContainer<ArcanumBatteryAttachRecipe> ARCANUM_BATTERY_ATTACH = AoARecipes.registerRecipeType("arcanum_battery_attach", ArcanumBatteryAttachRecipe.Factory::new);

    public static void init() {
    }

    private static <T extends Recipe<I>, I extends RecipeInput> RecipeTypeContainer<T> registerRecipeType(final String id, Supplier<RecipeSerializer<T>> serializer) {
        return new RecipeTypeContainer(AoARegistries.RECIPE_TYPES.register(id, () -> new RecipeType<T>(){

            public String toString() {
                return AdventOfAscension.id(id).toString();
            }
        }), AoARegistries.RECIPE_SERIALIZERS.register(id, serializer));
    }

    public record RecipeTypeContainer<T extends Recipe<?>>(DeferredHolder<RecipeType<?>, RecipeType<T>> type, DeferredHolder<RecipeSerializer<?>, RecipeSerializer<T>> serializer) {
    }
}

