/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.library.object.AllDirections;
import net.tslat.aoa3.library.object.explosion.ExplosionInfo;
import net.tslat.aoa3.library.object.explosion.ExtendedExplosion;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;
import org.apache.logging.log4j.util.TriConsumer;

public final class AoAExplosions {
    public static final ExplosionInfo BOMB_CARRIER_DYNAMITE = new ExplosionInfo().radius(3.0f).baseDamage(8.0f).penetration(8.5f).blocksDropChance(0.3f);
    public static final ExplosionInfo KING_BAMBAMBAM_DISCHARGE = new ExplosionInfo().radius(5.0f).baseDamage(40.0f).damageMod((explosion, target) -> Float.valueOf(PlayerUtil.getPlayerOrOwnerIfApplicable(target) != null ? 1.0f : 0.0f)).onHit((explosion, target) -> target.igniteForSeconds((float)(target.getRemainingFireTicks() / 20 + 10)));
    public static final ExplosionInfo LITTLE_BAM_OVERLOAD = new ExplosionInfo().radius(6.0f).baseDamage(20.0f).penetration(30.0f).baseKnockbackStrength(1.25f).onHit((explosion, entity) -> entity.igniteForSeconds(3.0f)).onBlockHit((TriConsumer<ExtendedExplosion, BlockState, BlockPos>)((TriConsumer)(explosion, state, pos) -> {
        if (explosion.level.random.nextInt(3) == 0 && explosion.level.getBlockState(pos.below()).isSolidRender((BlockGetter)explosion.level, pos.below())) {
            explosion.level.setBlock(pos, Blocks.FIRE.defaultBlockState(), 3);
        }
    })).particles((explosion, tick) -> {
        Vec3 pos = explosion.center();
        TELParticlePacket packet = new TELParticlePacket(new ParticleBuilder[]{ParticleBuilder.forPosition((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, (double)pos.x, (double)pos.y, (double)pos.z)});
        for (AllDirections direction : AllDirections.values()) {
            Vec3i angle = direction.angle();
            packet.particle(ParticleBuilder.forPositions((ParticleOptions)((ParticleOptions)AoAParticleTypes.GENERIC_DUST.get()), (Vec3[])new Vec3[]{pos}).lifespan(Mth.ceil((float)(5.0f * (explosion.rand().nextFloat() * 0.8f + 0.2f)))).colourOverride((explosion.rand().nextFloat() * 0.7f + 0.3f) * 124.0f / 255.0f, 0.0f, 0.0f, 1.0f).velocity((double)(angle.getX() * 10), (double)(angle.getY() * 10), (double)(angle.getZ() * 10)));
        }
        packet.sendToAllNearbyPlayers((ServerLevel)explosion.level, pos, 64.0);
    });
    public static final ExplosionInfo GRENADE = new ExplosionInfo().radius(3.0f).penetration(7.0f).baseDamage(5.0f).blocksDropChance(0.1f);
    public static final ExplosionInfo NETHENGEIC_WITHER_FIREBALL = new ExplosionInfo().radius(2.0f).penetration(50.0f).baseDamage(5.0f).onBlockHit((TriConsumer<ExtendedExplosion, BlockState, BlockPos>)((TriConsumer)(explosion, state, explodePos) -> {
        if (explosion.rand().oneInNChance(3) && explosion.level.getBlockState(explodePos.below()).isSolidRender((BlockGetter)explosion.level, explodePos.below())) {
            explosion.level.setBlock(explodePos, Blocks.FIRE.defaultBlockState(), 3);
        }
    }));
    public static final ExplosionInfo STICKY_FIREBALL = new ExplosionInfo().radius(2.0f).baseDamage(1.0f).damageMod((explosion, target) -> Float.valueOf((float)(target.level().getDifficulty().getId() + 1) * 5.0f));
    public static final ExplosionInfo EXPLOSIVE_BOW = new ExplosionInfo().radius(2.5f).baseDamage(4.0f).penetration(5.0f).knockbackMod((explosion, entity) -> Float.valueOf(1.2f)).blocksDropChance(0.1f);

    public static ExplosionInfo rpg(Function<LivingEntity, Float> damageFunction) {
        return new ExplosionInfo().radius(4.0f).penetration(20.0f).blocksDropChance(0.55f).baseDamage(12.0f).damageMod((explosion, entity) -> {
            float f;
            if (entity instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity;
                f = ((Float)damageFunction.apply(target)).floatValue();
            } else {
                f = 1.0f;
            }
            return Float.valueOf(f);
        }).baseKnockbackStrength(2.5f);
    }
}

