/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.ProjectileDispenseBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.item.AoAWeapons;
import net.tslat.aoa3.content.block.functional.misc.CarvedRuneOfPower;
import net.tslat.aoa3.content.item.misc.BlankRealmstone;
import net.tslat.aoa3.content.item.misc.Realmstone;

public final class AoADispensables {
    public static void lateInit() {
        AoADispensables.registerFluidDispensables();
        AoADispensables.registerProjectileDispensables();
        AoADispensables.registerMiscDispensables();
    }

    private static void registerProjectileDispensables() {
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)AoAWeapons.HELLFIRE.get()), (DispenseItemBehavior)new ProjectileDispenseBehavior((Item)AoAWeapons.HELLFIRE.get()));
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)AoAWeapons.GRENADE.get()), (DispenseItemBehavior)new ProjectileDispenseBehavior((Item)AoAWeapons.GRENADE.get()));
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)AoAWeapons.CHAKRAM.get()), (DispenseItemBehavior)new ProjectileDispenseBehavior((Item)AoAWeapons.CHAKRAM.get()));
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)AoAWeapons.GOO_BALL.get()), (DispenseItemBehavior)new ProjectileDispenseBehavior((Item)AoAWeapons.GOO_BALL.get()));
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)AoAWeapons.RUNIC_BOMB.get()), (DispenseItemBehavior)new ProjectileDispenseBehavior((Item)AoAWeapons.RUNIC_BOMB.get()));
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)AoAWeapons.VULKRAM.get()), (DispenseItemBehavior)new ProjectileDispenseBehavior((Item)AoAWeapons.VULKRAM.get()));
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)AoAWeapons.SLICE_STAR.get()), (DispenseItemBehavior)new ProjectileDispenseBehavior((Item)AoAWeapons.SLICE_STAR.get()));
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)AoAWeapons.HARDENED_PARAPIRANHA.get()), (DispenseItemBehavior)new ProjectileDispenseBehavior((Item)AoAWeapons.HARDENED_PARAPIRANHA.get()));
    }

    private static void registerMiscDispensables() {
        DispenseItemBehavior realmstoneBehaviour = (source, stack) -> {
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            BlockPos pos = source.pos().offset(direction.getStepX(), direction.getStepY(), direction.getStepZ());
            if (source.level().getBlockState(pos).getBlock() instanceof CarvedRuneOfPower) {
                Item item = stack.getItem();
                Objects.requireNonNull(item);
                Item selector0$temp = item;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Realmstone.class, BlankRealmstone.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        Realmstone realmstone = (Realmstone)selector0$temp;
                        CarvedRuneOfPower.fillPortal((Level)source.level(), pos, direction, stack, null);
                        break;
                    }
                    case 1: {
                        BlankRealmstone blankRealmstone = (BlankRealmstone)selector0$temp;
                        CarvedRuneOfPower.clearPortal((Level)source.level(), pos, direction, stack, null);
                        break;
                    }
                }
                return stack;
            }
            Position position = DispenserBlock.getDispensePosition((BlockSource)source);
            ItemStack itemstack = stack.split(1);
            DefaultDispenseItemBehavior.spawnItem((Level)source.level(), (ItemStack)itemstack, (int)6, (Direction)direction, (Position)position);
            source.level().levelEvent(1000, source.pos(), 0);
            source.level().levelEvent(2000, source.pos(), direction.get3DDataValue());
            return stack;
        };
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)AoAItems.NETHER_REALMSTONE.get()), (DispenseItemBehavior)realmstoneBehaviour);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)AoAItems.BLANK_REALMSTONE.get()), (DispenseItemBehavior)realmstoneBehaviour);
    }

    private static void registerFluidDispensables() {
        DefaultDispenseItemBehavior fluidDispenser = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultBehaviour = new DefaultDispenseItemBehavior();

            protected ItemStack execute(BlockSource source, ItemStack stack) {
                BucketItem bucket = (BucketItem)stack.getItem();
                BlockPos pos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
                ServerLevel world = source.level();
                if (bucket.emptyContents(null, (Level)world, pos, null)) {
                    bucket.checkExtraContent(null, (Level)world, stack, pos);
                    return new ItemStack((ItemLike)Items.BUCKET);
                }
                return this.defaultBehaviour.dispense(source, stack);
            }
        };
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)AoARegistries.ITEMS.getEntry(AdventOfAscension.id("candied_water_bucket"))), (DispenseItemBehavior)fluidDispenser);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)AoARegistries.ITEMS.getEntry(AdventOfAscension.id("toxic_waste_bucket"))), (DispenseItemBehavior)fluidDispenser);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)AoARegistries.ITEMS.getEntry(AdventOfAscension.id("clear_water_bucket"))), (DispenseItemBehavior)fluidDispenser);
    }
}

