/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.networking.packets;

import net.minecraft.commands.CommandSource;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.command.WikiCommand;
import net.tslat.aoa3.common.networking.packets.AoAPacket;

public record WikiSearchPacket(String searchString) implements AoAPacket
{
    public static final CustomPacketPayload.Type<WikiSearchPacket> TYPE = new CustomPacketPayload.Type(AdventOfAscension.id("wiki_search"));
    public static final StreamCodec<FriendlyByteBuf, WikiSearchPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, WikiSearchPacket::searchString, WikiSearchPacket::new);

    public CustomPacketPayload.Type<? extends WikiSearchPacket> type() {
        return TYPE;
    }

    @Override
    public void receiveMessage(IPayloadContext context) {
        context.enqueueWork(() -> WikiCommand.handleSearchRequest(this.searchString, (CommandSource)ClientOperations.getPlayer()));
    }
}

