/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.networking.packets;

import java.util.OptionalDouble;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.common.networking.packets.AoAPacket;
import net.tslat.aoa3.util.CodecUtil;

public record UpdateClientMovementPacket(Operation operation, OptionalDouble x, OptionalDouble y, OptionalDouble z) implements AoAPacket
{
    public static final CustomPacketPayload.Type<UpdateClientMovementPacket> TYPE = new CustomPacketPayload.Type(AdventOfAscension.id("update_client_movement"));
    public static final StreamCodec<FriendlyByteBuf, UpdateClientMovementPacket> CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(Operation.class), UpdateClientMovementPacket::operation, CodecUtil.STREAM_OPTIONAL_DOUBLE, UpdateClientMovementPacket::x, CodecUtil.STREAM_OPTIONAL_DOUBLE, UpdateClientMovementPacket::y, CodecUtil.STREAM_OPTIONAL_DOUBLE, UpdateClientMovementPacket::z, UpdateClientMovementPacket::new);

    public UpdateClientMovementPacket(Operation operation, double x, double y, double z) {
        this(operation, OptionalDouble.of(x), OptionalDouble.of(y), OptionalDouble.of(z));
    }

    public UpdateClientMovementPacket(Operation operation, double x, double z) {
        this(operation, OptionalDouble.of(x), OptionalDouble.empty(), OptionalDouble.of(z));
    }

    public UpdateClientMovementPacket(Operation operation, double y) {
        this(operation, OptionalDouble.empty(), OptionalDouble.of(y), OptionalDouble.empty());
    }

    public CustomPacketPayload.Type<? extends UpdateClientMovementPacket> type() {
        return TYPE;
    }

    @Override
    public void receiveMessage(IPayloadContext context) {
        context.enqueueWork(() -> ClientOperations.adjustPlayerMovement(this.x, this.y, this.z, this.operation));
    }

    public static enum Operation {
        SET,
        ADD,
        MULTIPLY,
        MAX,
        MIN;

    }
}

