/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.networking.packets;

import java.lang.runtime.SwitchBootstraps;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.networking.packets.AoAPacket;
import net.tslat.aoa3.common.registration.entity.AoADamageTypes;
import net.tslat.aoa3.content.entity.base.AoARangedAttacker;
import net.tslat.aoa3.library.builder.EntityPredicate;
import net.tslat.aoa3.util.DamageUtil;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public record ParticleEffectPacket(Type effectType, int senderId, int entityId) implements AoAPacket
{
    public static final CustomPacketPayload.Type<ParticleEffectPacket> TYPE = new CustomPacketPayload.Type(AdventOfAscension.id("particle_effect"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ParticleEffectPacket> CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(Type.class), ParticleEffectPacket::effectType, (StreamCodec)ByteBufCodecs.VAR_INT, ParticleEffectPacket::senderId, (StreamCodec)ByteBufCodecs.VAR_INT, ParticleEffectPacket::entityId, ParticleEffectPacket::new);

    public CustomPacketPayload.Type<? extends ParticleEffectPacket> type() {
        return TYPE;
    }

    @Override
    public void receiveMessage(IPayloadContext context) {
        context.enqueueWork(() -> {
            Level level = context.player().level();
            Entity entity = this.entityId >= 0 ? level.getEntity(this.entityId) : null;
            Entity source = this.senderId >= 0 ? level.getEntity(this.senderId) : null;
            this.effectType.effectHandler.accept((Object)level, (Object)entity, (Object)source);
        });
    }

    private static void doSnowflakeEffect(Level level, @Nullable Entity hitEntity, @Nullable Entity particleSource) {
        if (hitEntity != null) {
            if (particleSource instanceof AoARangedAttacker) {
                AoARangedAttacker rangedAttacker = (AoARangedAttacker)particleSource;
                rangedAttacker.doRangedAttackEntity(null, hitEntity);
            } else if ((float)hitEntity.getTicksFrozen() <= (float)hitEntity.getTicksRequiredToFreeze() * 2.5f) {
                hitEntity.setTicksFrozen(hitEntity.getTicksFrozen() + 14);
            }
        }
    }

    private static void doSandstormEffect(Level level, @Nullable Entity hitEntity, @Nullable Entity particleSource) {
        Entity entity = hitEntity;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LivingEntity.class, Projectile.class}, (Object)entity, n)) {
            case 0: {
                LivingEntity livingTarget = (LivingEntity)entity;
                if (!EntityPredicate.TARGETABLE_ENTITIES.test((Entity)livingTarget)) break;
                DamageSource source = particleSource == null ? DamageUtil.miscDamage((ResourceKey<DamageType>)DamageTypes.STING, livingTarget.level()) : DamageUtil.positionedEntityDamage((ResourceKey<DamageType>)DamageTypes.MOB_ATTACK_NO_AGGRO, particleSource, livingTarget.position());
                DamageUtil.safelyDealDamage(source, (Entity)livingTarget, 4.0f);
                break;
            }
            case 1: {
                Projectile projectile = (Projectile)entity;
                projectile.setDeltaMovement(projectile.getDeltaMovement().multiply(-0.5, -0.5, -0.5));
                break;
            }
        }
    }

    private static void doBurningFlameEffect(Level level, @Nullable Entity hitEntity, @Nullable Entity particleSource) {
        if (hitEntity instanceof LivingEntity) {
            if (particleSource instanceof AoARangedAttacker) {
                AoARangedAttacker rangedAttacker = (AoARangedAttacker)particleSource;
                rangedAttacker.doRangedAttackEntity(null, hitEntity);
            } else {
                DamageUtil.safelyDealDamage(DamageUtil.miscPositionedDamage(AoADamageTypes.MOB_FIRE_RANGED_ATTACK, hitEntity.level(), hitEntity.position()), hitEntity, 1.0f);
                hitEntity.igniteForSeconds((float)((int)Math.ceil((float)hitEntity.getRemainingFireTicks() / 20.0f) + 1));
            }
        }
    }

    public static enum Type {
        FREEZING_SNOWFLAKE((TriConsumer<Level, Entity, Entity>)((TriConsumer)ParticleEffectPacket::doSnowflakeEffect)),
        BURNING_FLAME((TriConsumer<Level, Entity, Entity>)((TriConsumer)ParticleEffectPacket::doBurningFlameEffect)),
        SANDSTORM((TriConsumer<Level, Entity, Entity>)((TriConsumer)ParticleEffectPacket::doSandstormEffect));

        private final TriConsumer<Level, @Nullable Entity, @Nullable Entity> effectHandler;

        private Type(TriConsumer<Level, Entity, Entity> effectHandler) {
            this.effectHandler = effectHandler;
        }
    }
}

