/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.networking.packets;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.common.networking.packets.AoAPacket;
import net.tslat.aoa3.content.entity.base.AoAMultipartEntity;

public record MultipartTogglePacket(int entityId, boolean active) implements AoAPacket
{
    public static final CustomPacketPayload.Type<MultipartTogglePacket> TYPE = new CustomPacketPayload.Type(AdventOfAscension.id("multipart_toggle"));
    public static final StreamCodec<FriendlyByteBuf, MultipartTogglePacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, MultipartTogglePacket::entityId, (StreamCodec)ByteBufCodecs.BOOL, MultipartTogglePacket::active, MultipartTogglePacket::new);

    public CustomPacketPayload.Type<? extends MultipartTogglePacket> type() {
        return TYPE;
    }

    @Override
    public void receiveMessage(IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity patt0$temp = ClientOperations.getLevel().getEntity(this.entityId);
            if (patt0$temp instanceof AoAMultipartEntity) {
                AoAMultipartEntity multipart = (AoAMultipartEntity)patt0$temp;
                multipart.toggleMultipart(this.active);
                ((Entity)multipart).refreshDimensions();
            }
        });
    }
}

