/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.menu;

import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.tslat.aoa3.common.menu.generic.ExtensibleRecipeMenu;
import net.tslat.aoa3.common.menu.generic.GenericRecipeInput;
import net.tslat.aoa3.common.menu.slot.CraftableResultSlot;
import net.tslat.aoa3.common.menu.slot.OutputSlot;
import net.tslat.aoa3.common.registration.AoAMenus;
import net.tslat.aoa3.common.registration.AoARecipes;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.blockentity.InfusionTableBlockEntity;

public class InfusionTableMenu
extends ExtensibleRecipeMenu<TransientCraftingContainer, GenericRecipeInput> {
    public InfusionTableMenu(int screenId, Inventory playerInventory, ContainerLevelAccess accessValidator) {
        super((MenuType)AoAMenus.INFUSION_TABLE.get(), screenId, playerInventory, accessValidator);
        this.createPlayerInventory(playerInventory, 8, 84);
    }

    @Override
    protected GenericRecipeInput createRecipeInput() {
        return new GenericRecipeInput(((TransientCraftingContainer)this.getInventory()).getItems());
    }

    @Override
    public int inputSlotCount() {
        return 10;
    }

    @Override
    protected TransientCraftingContainer createInventory() {
        return new TransientCraftingContainer((AbstractContainerMenu)this, 0, 0, NonNullList.withSize((int)10, (Object)ItemStack.EMPTY));
    }

    @Override
    protected Block getContainerBlock() {
        return (Block)AoABlocks.INFUSION_TABLE.get();
    }

    @Override
    protected Slot createInputSlot(int slotIndex, TransientCraftingContainer inventory) {
        if (slotIndex == 0) {
            return new Slot((Container)inventory, slotIndex, 17, 35);
        }
        return new Slot((Container)inventory, slotIndex, 45 + this.gridXFromIndex(slotIndex - 1) * 18, 17 + this.gridYFromIndex(slotIndex - 1) * 18);
    }

    @Override
    protected Slot createOutputSlot(int slotIndex, Player player) {
        return new CraftableResultSlot(player, (TransientCraftingContainer)this.getInventory(), new ResultContainer(), (RecipeType)AoARecipes.INFUSION.type().get(), this::createRecipeInput, slotIndex, 139, 35);
    }

    @Override
    protected void handleContainerUpdate() {
        OutputSlot outputSlot = (OutputSlot)this.getOutputSlot();
        this.updateRecipeOutput((RecipeType)AoARecipes.INFUSION.type().get(), outputSlot.getPlayer(), (ResultContainer)outputSlot.container, recipe -> true);
    }

    public static void openContainer(ServerPlayer player, BlockPos pos) {
        BlockEntity blockEntity = player.level().getBlockEntity(pos);
        if (!(blockEntity instanceof InfusionTableBlockEntity)) {
            return;
        }
        InfusionTableBlockEntity infusionTable = (InfusionTableBlockEntity)blockEntity;
        player.openMenu((MenuProvider)infusionTable, pos);
    }
}

