/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.menu;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.tslat.aoa3.common.menu.generic.ExtensibleContainerMenu;
import net.tslat.aoa3.common.registration.AoAMenus;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.item.AoADataComponents;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.block.blockentity.InfusedPressBlockEntity;
import net.tslat.aoa3.content.item.datacomponent.CompressedItemData;

public class InfusedPressMenu
extends ExtensibleContainerMenu<SimpleContainer> {
    public InfusedPressMenu(int screenId, Inventory playerInventory, ContainerLevelAccess accessValidator) {
        super((MenuType)AoAMenus.INFUSED_PRESS.get(), screenId, playerInventory, accessValidator);
        this.createPlayerInventory(playerInventory, 8, 84);
    }

    @Override
    public int inputSlotCount() {
        return 9;
    }

    @Override
    protected SimpleContainer createInventory() {
        return new SimpleContainer(this.inputSlotCount() + 1);
    }

    @Override
    protected Block getContainerBlock() {
        return (Block)AoABlocks.INFUSED_PRESS.get();
    }

    @Override
    protected Slot createInputSlot(int slotIndex, SimpleContainer inventory) {
        return new Slot(this, (Container)inventory, slotIndex, 30 + this.gridXFromIndex(slotIndex) * 18, 17 + this.gridYFromIndex(slotIndex) * 18){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(AoAItems.COMPRESSED_ITEM) || stack.isStackable();
            }
        };
    }

    @Override
    protected Slot createOutputSlot(int slotIndex, Player player) {
        return new Slot(this, (Container)this.getInventory(), 9, 124, 35){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(AoAItems.COMPRESSED_ITEM) && stack.has(AoADataComponents.COMPRESSED_ITEM_DATA) && ((CompressedItemData)stack.get(AoADataComponents.COMPRESSED_ITEM_DATA)).compressions() > 0;
            }
        };
    }

    @Override
    protected void handleContainerUpdate() {
    }

    public static void openContainer(ServerPlayer player, BlockPos pos) {
        BlockEntity blockEntity = player.level().getBlockEntity(pos);
        if (!(blockEntity instanceof InfusedPressBlockEntity)) {
            return;
        }
        InfusedPressBlockEntity press = (InfusedPressBlockEntity)blockEntity;
        player.openMenu((MenuProvider)press, pos);
    }
}

