/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.menu;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.event.EventHooks;
import net.tslat.aoa3.common.menu.container.ListenableResultContainer;
import net.tslat.aoa3.common.menu.generic.ExtensibleRecipeMenu;
import net.tslat.aoa3.common.menu.slot.CraftableResultSlot;
import net.tslat.aoa3.common.menu.slot.PredicatedSlot;
import net.tslat.aoa3.common.registration.AoAMenus;
import net.tslat.aoa3.common.registration.AoARecipes;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.content.block.blockentity.ImbuingChamberBlockEntity;
import net.tslat.aoa3.content.item.misc.AspectFocusItem;
import net.tslat.aoa3.content.recipe.ImbuingRecipe;
import net.tslat.aoa3.event.custom.AoAEvents;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.PlayerUtil;

public class ImbuingChamberMenu
extends ExtensibleRecipeMenu<ImbuingInventory, ImbuingRecipe.ImbuingRecipeInput> {
    public ImbuingChamberMenu(int screenId, Inventory playerInventory, ContainerLevelAccess accessValidator) {
        super((MenuType)AoAMenus.IMBUING_CHAMBER.get(), screenId, playerInventory, accessValidator);
        this.createPlayerInventory(playerInventory, 8, 84);
    }

    @Override
    protected ImbuingRecipe.ImbuingRecipeInput createRecipeInput() {
        return new ImbuingRecipe.ImbuingRecipeInput((ImbuingInventory)((Object)this.getInventory()));
    }

    @Override
    public int inputSlotCount() {
        return 6;
    }

    @Override
    protected ImbuingInventory createInventory() {
        return new ImbuingInventory(this);
    }

    @Override
    protected Block getContainerBlock() {
        return (Block)AoABlocks.IMBUING_CHAMBER.get();
    }

    @Override
    protected Slot createInputSlot(int slotIndex, ImbuingInventory inventory) {
        if (slotIndex == 0) {
            return new Slot((Container)inventory, slotIndex, 17, 35);
        }
        return new PredicatedSlot((Container)inventory, slotIndex, 19 + 19 * slotIndex, 35, stack -> stack.getItem() instanceof AspectFocusItem);
    }

    @Override
    protected Slot createOutputSlot(int slotIndex, Player player) {
        return new ImbuingResultSlot(player, (ImbuingInventory)((Object)this.getInventory()), new ListenableResultContainer(stack -> ((ImbuingInventory)((Object)((Object)this.getInventory()))).setItem(this.getOutputSlotIndex(), (ItemStack)stack)), this::createRecipeInput, slotIndex, 139, 35);
    }

    @Override
    protected void handleContainerUpdate() {
        ImbuingResultSlot outputSlot = (ImbuingResultSlot)this.getOutputSlot();
        Player player = outputSlot.getPlayer();
        if (!((ImbuingInventory)((Object)this.getInventory())).updatingOutput) {
            ((ImbuingInventory)((Object)this.getInventory())).updatingOutput = true;
            this.updateRecipeOutput((RecipeType)AoARecipes.IMBUING.type().get(), player, (ResultContainer)outputSlot.container, recipe -> ImbuingChamberMenu.canUseRecipe(player, (RecipeHolder<ImbuingRecipe>)recipe));
        }
        ((ImbuingInventory)((Object)this.getInventory())).updatingOutput = false;
    }

    @Override
    protected <R extends Recipe<ImbuingRecipe.ImbuingRecipeInput>> void updateRecipeOutput(RecipeType<R> recipeType, Player player, ResultContainer resultContainer, Predicate<RecipeHolder<R>> recipePredicate) {
        ImbuingRecipe.ImbuingRecipeInput recipeInput = this.createRecipeInput();
        Optional<RecipeHolder<R>> recipeHolder = this.getOrFindRecipe(recipeType, recipeInput, resultContainer, player.level());
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerLevel level = serverPlayer.serverLevel();
            ItemStack outputStack = recipeHolder.filter(holder -> recipePredicate.test((RecipeHolder)holder) && resultContainer.setRecipeUsed((Level)level, serverPlayer, holder)).map(RecipeHolder::value).map(recipe -> recipe.assemble((RecipeInput)recipeInput, (HolderLookup.Provider)level.registryAccess())).filter(recipeResult -> recipeResult.isItemEnabled(level.enabledFeatures())).filter(stack -> !AoAEvents.firePlayerCraftingEvent(player, stack, this.getInventory(), resultContainer)).orElse(this.getOutputItem());
            if (!ItemStack.isSameItemSameComponents((ItemStack)this.getOutputItem(), (ItemStack)outputStack)) {
                ((ImbuingInventory)this.inventory).imbuing = true;
                this.setOutputItem(outputStack);
                this.setRemoteSlot(this.getOutputSlotIndex(), outputStack);
                serverPlayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), this.getOutputSlotIndex(), outputStack));
            }
        } else {
            resultContainer.setRecipeUsed((RecipeHolder)recipeHolder.orElse(null));
        }
    }

    private static boolean canUseRecipe(Player player, RecipeHolder<ImbuingRecipe> recipe) {
        return player.isCreative() || ((ImbuingRecipe)recipe.value()).getImbuingLevelReq() <= 1 || PlayerUtil.doesPlayerHaveLevel(player, (AoASkill)AoASkills.IMBUING.get(), ((ImbuingRecipe)recipe.value()).getImbuingLevelReq());
    }

    public static void openContainer(ServerPlayer player, BlockPos pos) {
        BlockEntity blockEntity = player.level().getBlockEntity(pos);
        if (!(blockEntity instanceof ImbuingChamberBlockEntity)) {
            return;
        }
        ImbuingChamberBlockEntity imbuingChamber = (ImbuingChamberBlockEntity)blockEntity;
        player.openMenu((MenuProvider)imbuingChamber, pos);
    }

    public static class ImbuingInventory
    extends TransientCraftingContainer {
        public boolean imbuing = false;
        public boolean updatingOutput = false;

        public ImbuingInventory(ImbuingChamberMenu menu) {
            super((AbstractContainerMenu)menu, 7, 1, NonNullList.withSize((int)7, (Object)ItemStack.EMPTY));
        }
    }

    public static class ImbuingResultSlot
    extends CraftableResultSlot<ImbuingInventory, ImbuingRecipe.ImbuingRecipeInput, ImbuingRecipe> {
        public ImbuingResultSlot(Player pl, ImbuingInventory craftInv, ResultContainer inv, Supplier<ImbuingRecipe.ImbuingRecipeInput> recipeInput, int slotIndex, int xPos, int yPos) {
            super(pl, craftInv, inv, (RecipeType)AoARecipes.IMBUING.type().get(), recipeInput, slotIndex, xPos, yPos);
        }

        @Override
        public boolean mayPlace(ItemStack stack) {
            return this.getCurrentRecipe().map(recipe -> recipe.canEnchantInput(stack)).orElse(false);
        }

        @Override
        protected void onQuickCraft(ItemStack stack, int amount) {
            this.removedCount += amount;
        }

        public void set(ItemStack stack) {
            super.set(stack);
            if (!stack.isEmpty() && ((ImbuingInventory)((Object)this.getInventoryContainer())).imbuing) {
                this.awardForCrafting(stack, stack.getCount());
                this.getResultContainer().awardUsedRecipes(this.player, this.getContainerItems());
                EventHooks.firePlayerCraftingEvent((Player)this.player, (ItemStack)stack, (Container)this.container);
                this.onItemRemoved(this.player, stack);
            }
        }

        @Override
        public void onTake(Player player, ItemStack stack) {
            this.setChanged();
        }

        @Override
        protected NonNullList<ItemStack> getRemainingItems(RecipeType<ImbuingRecipe> recipeType, ImbuingRecipe.ImbuingRecipeInput recipeInput, Player player) {
            NonNullList<ItemStack> remainingStacks = super.getRemainingItems(recipeType, recipeInput, player);
            ((ImbuingInventory)((Object)this.getInventoryContainer())).imbuing = false;
            return remainingStacks;
        }

        @Override
        protected void awardForCrafting(ItemStack stack, int amount) {
            Player player = this.getPlayer();
            if (player instanceof ServerPlayer) {
                ServerPlayer pl = (ServerPlayer)player;
                this.getCurrentRecipe().ifPresent(recipe -> {
                    float xp = recipe.getXp(this.getPlayer());
                    if (xp > 0.0f) {
                        PlayerUtil.giveXpToPlayer(pl, (AoASkill)AoASkills.IMBUING.get(), xp, false);
                    }
                });
            }
        }
    }
}

