/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.menu;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.tslat.aoa3.common.registration.AoAMenus;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.npc.trader.CorruptedTravellerEntity;
import net.tslat.aoa3.util.InventoryUtil;

public class CorruptedTravellerMenu
extends AbstractContainerMenu {
    private final Container input;
    public final CorruptedTravellerEntity traveller;
    private final Player player;
    private boolean handledFood = false;

    public CorruptedTravellerMenu(int screenId, Inventory playerInventory) {
        this(screenId, playerInventory, null);
    }

    public CorruptedTravellerMenu(int screenId, Inventory playerInventory, CorruptedTravellerEntity traveller) {
        super((MenuType)AoAMenus.CORRUPTED_TRAVELLER.get(), screenId);
        this.traveller = traveller;
        this.player = playerInventory.player;
        this.input = new SimpleContainer(this, 1){

            public boolean canPlaceItem(int index, ItemStack stack) {
                return stack.getFoodProperties(null) != null;
            }
        };
        this.addSlot(new Slot(this.input, 0, 80, 34){

            public boolean mayPlace(ItemStack stack) {
                return stack.getFoodProperties(null) != null;
            }

            public void setChanged() {
                super.setChanged();
                if (this.hasItem()) {
                    CorruptedTravellerMenu.this.handleFoodInput();
                }
            }
        });
        for (int inventoryY = 0; inventoryY < 3; ++inventoryY) {
            for (int inventoryX = 0; inventoryX < 9; ++inventoryX) {
                this.addSlot(new Slot((Container)this.player.getInventory(), inventoryX + inventoryY * 9 + 9, 8 + inventoryX * 18, 65 + inventoryY * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.addSlot(new Slot((Container)this.player.getInventory(), hotbarSlot, 8 + hotbarSlot * 18, 123));
        }
    }

    private void handleFoodInput() {
        if (!this.handledFood) {
            ItemStack stack = ((Slot)this.slots.get((int)0)).container.getItem(0);
            if (!stack.isEmpty() && stack.getFoodProperties((LivingEntity)this.player) != null) {
                Player player = this.player;
                if (player instanceof ServerPlayer) {
                    ServerPlayer pl = (ServerPlayer)player;
                    InventoryUtil.giveItemTo(pl, AoAItems.WORN_BOOK);
                }
                stack.shrink(1);
            }
            this.handledFood = true;
        } else {
            this.handledFood = false;
        }
    }

    public void removed(Player player) {
        super.removed(player);
        if (!player.level().isClientSide) {
            this.clearContainer(player, this.input);
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            stack = slotStack.copy();
            if (index != 0) {
                if (index < 28) {
                    if (!this.moveItemStackTo(slotStack, 28, 36, true)) {
                        return ItemStack.EMPTY;
                    }
                    slot.onQuickCraft(slotStack, stack);
                } else if (index < 37 && !this.moveItemStackTo(slotStack, 1, 27, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (!this.moveItemStackTo(slotStack, 1, 36, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return stack;
    }

    public boolean stillValid(Player player) {
        return this.traveller != null && this.traveller.isAlive() && this.player.distanceToSqr((Entity)this.traveller) <= 64.0;
    }
}

