/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.command.AoACommand;
import net.tslat.aoa3.common.networking.AoANetworking;
import net.tslat.aoa3.common.networking.packets.WikiSearchPacket;
import net.tslat.aoa3.util.StringUtil;
import org.apache.logging.log4j.Level;

public class WikiCommand
implements Command<CommandSourceStack> {
    private static final WikiCommand CMD = new WikiCommand();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"wiki").executes((Command)CMD);
        builder.then(((RequiredArgumentBuilder)Commands.argument((String)"search", (ArgumentType)StringArgumentType.greedyString()).requires(command -> command.isPlayer() && command.hasPermission(0))).executes(WikiCommand::sendPacket));
        return builder;
    }

    private static int sendPacket(CommandContext<CommandSourceStack> cmd) throws CommandSyntaxException {
        AoANetworking.sendToPlayer(((CommandSourceStack)cmd.getSource()).getPlayer(), new WikiSearchPacket(StringArgumentType.getString(cmd, (String)"search")));
        return 1;
    }

    public static void handleSearchRequest(String search, CommandSource receiver) {
        String searchUrl = "https://adventofascension.fandom.com/wiki/" + (String)(search.equalsIgnoreCase("random") || search.equalsIgnoreCase("?") ? "Special:Random" : "Special:Search?query=" + URLEncoder.encode(search.replace(" ", "_"), StandardCharsets.UTF_8));
        URI uri = URI.create(searchUrl);
        URI updatedUri = null;
        try {
            HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection();
            connection.setInstanceFollowRedirects(true);
            connection.connect();
            updatedUri = switch (connection.getResponseCode()) {
                case 301, 302 -> URI.create(connection.getHeaderField("Location"));
                case 200 -> connection.getURL().toURI();
                default -> null;
            };
        }
        catch (UnsupportedEncodingException | MalformedURLException ex) {
            Logging.logMessage(Level.ERROR, "Failed to encode URL for AoA Wiki search: \"" + search + "\"", ex);
        }
        catch (IOException | URISyntaxException ex) {
            receiver.sendSystemMessage((Component)AoACommand.getCmdPrefix("Wiki").append((Component)Component.translatable((String)"command.aoa.wiki.connectionFail").setStyle(Style.EMPTY.applyFormat(AoACommand.CommandFeedbackType.ERROR.getColour()))));
        }
        URI finalUri = updatedUri;
        Object uriPath = finalUri != null ? finalUri.getPath() : searchUrl;
        String pageTitle = StringUtil.toTitleCase(finalUri != null && ((String)uriPath).contains("wiki/") ? ((String)uriPath).substring(((String)uriPath).lastIndexOf("wiki/") + 5) : search);
        receiver.sendSystemMessage((Component)AoACommand.getCmdPrefix("Wiki").append((Component)Component.translatable((String)"command.aoa.wiki.response", (Object[])new Object[]{Component.literal((String)pageTitle).withStyle(arg_0 -> WikiCommand.lambda$handleSearchRequest$1((String)uriPath, arg_0))}).setStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY))));
    }

    public int run(CommandContext<CommandSourceStack> context) {
        AoACommand.feedback((CommandSourceStack)context.getSource(), "Wiki", "command.aoa.wiki.desc", AoACommand.CommandFeedbackType.INFO, new Component[0]);
        return 1;
    }

    private static /* synthetic */ Style lambda$handleSearchRequest$1(String uriPath, Style style) {
        return style.withUnderlined(Boolean.valueOf(true)).withColor(ChatFormatting.RED).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, uriPath));
    }
}

