/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.tslat.aoa3.command.AoACommand;
import net.tslat.aoa3.command.argument.AoAResourceArgument;
import net.tslat.aoa3.command.argument.AoASkillArgument;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class PlayerCommand
implements Command<CommandSourceStack> {
    private static final PlayerCommand CMD = new PlayerCommand();
    public static final DynamicCommandExceptionType ERROR_SKILL_INVALID = new DynamicCommandExceptionType(obj -> Component.translatable((String)LocaleUtil.createGenericLocaleKey("argument", "skill.notFound"), (Object[])new Object[]{obj}));
    public static final DynamicCommandExceptionType ERROR_RESOURCE_INVALID = new DynamicCommandExceptionType(obj -> Component.translatable((String)LocaleUtil.createGenericLocaleKey("argument", "resource.notFound"), (Object[])new Object[]{obj}));

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"player").executes((Command)CMD);
        builder.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.literal((String)"skills").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"skill", (ArgumentType)AoASkillArgument.skill()).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"level").then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(command -> command.hasPermission(4))).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)999)).executes(context -> PlayerCommand.adjustSkills((CommandContext<CommandSourceStack>)context, "add"))))).then(((LiteralArgumentBuilder)Commands.literal((String)"subtract").requires(command -> command.hasPermission(4))).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)999)).executes(context -> PlayerCommand.adjustSkills((CommandContext<CommandSourceStack>)context, "subtract"))))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(command -> command.hasPermission(4))).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1000)).executes(context -> PlayerCommand.adjustSkills((CommandContext<CommandSourceStack>)context, "set"))))).then(Commands.literal((String)"check").executes(PlayerCommand::checkSkill)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"xp").then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(command -> command.hasPermission(4))).then(Commands.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)1.0f, (float)5.4413235E8f)).executes(context -> PlayerCommand.adjustXp((CommandContext<CommandSourceStack>)context, "add"))))).then(((LiteralArgumentBuilder)Commands.literal((String)"subtract").requires(command -> command.hasPermission(4))).then(Commands.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)1.0f, (float)5.4413235E8f)).executes(context -> PlayerCommand.adjustXp((CommandContext<CommandSourceStack>)context, "subtract"))))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(command -> command.hasPermission(4))).then(Commands.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)5.4413235E8f)).executes(context -> PlayerCommand.adjustXp((CommandContext<CommandSourceStack>)context, "set"))))).then(Commands.literal((String)"check").executes(PlayerCommand::checkXp)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"cycle").then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(command -> command.hasPermission(4))).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10)).executes(context -> PlayerCommand.adjustCycle((CommandContext<CommandSourceStack>)context, "add"))))).then(((LiteralArgumentBuilder)Commands.literal((String)"subtract").requires(command -> command.hasPermission(4))).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10)).executes(context -> PlayerCommand.adjustCycle((CommandContext<CommandSourceStack>)context, "subtract"))))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(command -> command.hasPermission(4))).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)10)).executes(context -> PlayerCommand.adjustCycle((CommandContext<CommandSourceStack>)context, "set"))))).then(Commands.literal((String)"check").executes(PlayerCommand::checkCycle)))))).then(Commands.literal((String)"resources").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"resource", (ArgumentType)AoAResourceArgument.resource()).then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(command -> command.hasPermission(4))).then(Commands.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)1.0f, (float)Float.MAX_VALUE)).executes(context -> PlayerCommand.adjustResources((CommandContext<CommandSourceStack>)context, "add"))))).then(((LiteralArgumentBuilder)Commands.literal((String)"subtract").requires(command -> command.hasPermission(4))).then(Commands.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)1.0f, (float)Float.MAX_VALUE)).executes(context -> PlayerCommand.adjustResources((CommandContext<CommandSourceStack>)context, "subtract"))))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(command -> command.hasPermission(4))).then(Commands.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)Float.MAX_VALUE)).executes(context -> PlayerCommand.adjustResources((CommandContext<CommandSourceStack>)context, "set"))))).then(Commands.literal((String)"check").executes(PlayerCommand::checkResource))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"stats").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"experience").then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(command -> command.hasPermission(4))).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).executes(context -> PlayerCommand.adjustVanillaXp((CommandContext<CommandSourceStack>)context, "add"))))).then(((LiteralArgumentBuilder)Commands.literal((String)"subtract").requires(command -> command.hasPermission(4))).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).executes(context -> PlayerCommand.adjustVanillaXp((CommandContext<CommandSourceStack>)context, "subtract"))))).then(Commands.literal((String)"check").executes(PlayerCommand::checkVanillaXp)))).then(((LiteralArgumentBuilder)Commands.literal((String)"food").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"hunger").then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(command -> command.hasPermission(4))).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)20)).executes(context -> PlayerCommand.adjustFoodStats((CommandContext<CommandSourceStack>)context, "hunger", "add"))))).then(((LiteralArgumentBuilder)Commands.literal((String)"subtract").requires(command -> command.hasPermission(4))).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)20)).executes(context -> PlayerCommand.adjustFoodStats((CommandContext<CommandSourceStack>)context, "hunger", "subtract"))))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(command -> command.hasPermission(4))).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)20)).executes(context -> PlayerCommand.adjustFoodStats((CommandContext<CommandSourceStack>)context, "hunger", "set"))))).then(Commands.literal((String)"check").executes(context -> PlayerCommand.checkFoodStats((CommandContext<CommandSourceStack>)context, "hunger"))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"saturation").then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(command -> command.hasPermission(4))).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)20)).executes(context -> PlayerCommand.adjustFoodStats((CommandContext<CommandSourceStack>)context, "saturation", "add"))))).then(((LiteralArgumentBuilder)Commands.literal((String)"subtract").requires(command -> command.hasPermission(4))).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)20)).executes(context -> PlayerCommand.adjustFoodStats((CommandContext<CommandSourceStack>)context, "saturation", "subtract"))))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(command -> command.hasPermission(4))).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)20)).executes(context -> PlayerCommand.adjustFoodStats((CommandContext<CommandSourceStack>)context, "saturation", "set"))))).then(Commands.literal((String)"check").executes(context -> PlayerCommand.checkFoodStats((CommandContext<CommandSourceStack>)context, "saturation")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"health").then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(command -> command.hasPermission(4))).then(Commands.argument((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)2.1474836E9f)).executes(context -> PlayerCommand.adjustHealth((CommandContext<CommandSourceStack>)context, "add"))))).then(((LiteralArgumentBuilder)Commands.literal((String)"subtract").requires(command -> command.hasPermission(4))).then(Commands.argument((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)2.1474836E9f)).executes(context -> PlayerCommand.adjustHealth((CommandContext<CommandSourceStack>)context, "subtract"))))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(command -> command.hasPermission(4))).then(Commands.argument((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)2.1474836E9f)).executes(context -> PlayerCommand.adjustHealth((CommandContext<CommandSourceStack>)context, "set"))))).then(Commands.literal((String)"check").executes(PlayerCommand::checkHealth)))));
        return builder;
    }

    private static int checkFoodStats(CommandContext<CommandSourceStack> context, String subsection) throws CommandSyntaxException {
        ServerPlayer pl = EntityArgument.getPlayer(context, (String)"player");
        if (subsection.equals("hunger")) {
            if (pl != ((CommandSourceStack)context.getSource()).getEntityOrException()) {
                if (!((CommandSourceStack)context.getSource()).hasPermission(2)) {
                    throw AoACommand.NO_PERMISSION_EXCEPTION.create();
                }
                AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new Component[0]);
                AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "command.aoa.player.food.hunger.check.other", AoACommand.CommandFeedbackType.SUCCESS, new Component[]{pl.getDisplayName(), LocaleUtil.numToComponent(pl.getFoodData().getFoodLevel())});
            } else {
                AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new Component[0]);
                AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "command.aoa.player.food.hunger.check.self", AoACommand.CommandFeedbackType.SUCCESS, new Component[]{LocaleUtil.numToComponent(pl.getFoodData().getFoodLevel())});
            }
        } else if (pl != ((CommandSourceStack)context.getSource()).getEntityOrException()) {
            if (!((CommandSourceStack)context.getSource()).hasPermission(2)) {
                throw AoACommand.NO_PERMISSION_EXCEPTION.create();
            }
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new Component[0]);
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "command.aoa.player.food.saturation.check.other", AoACommand.CommandFeedbackType.SUCCESS, new Component[]{pl.getDisplayName(), Component.literal((String)NumberUtil.roundToNthDecimalPlace(pl.getFoodData().getSaturationLevel(), 2))});
        } else {
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new Component[0]);
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "command.aoa.player.food.saturation.check.self", AoACommand.CommandFeedbackType.SUCCESS, new Component[]{Component.literal((String)NumberUtil.roundToNthDecimalPlace(pl.getFoodData().getSaturationLevel(), 2))});
        }
        return 1;
    }

    private static int checkVanillaXp(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer pl = EntityArgument.getPlayer(context, (String)"player");
        if (pl != ((CommandSourceStack)context.getSource()).getEntityOrException()) {
            if (!((CommandSourceStack)context.getSource()).hasPermission(2)) {
                throw AoACommand.NO_PERMISSION_EXCEPTION.create();
            }
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new Component[0]);
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "command.aoa.player.exp.check.other", AoACommand.CommandFeedbackType.SUCCESS, new Component[]{pl.getDisplayName(), LocaleUtil.numToComponent(pl.totalExperience), LocaleUtil.numToComponent(pl.experienceLevel)});
        } else {
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new Component[0]);
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "command.aoa.player.exp.check.self", AoACommand.CommandFeedbackType.SUCCESS, new Component[]{LocaleUtil.numToComponent(pl.totalExperience), LocaleUtil.numToComponent(pl.experienceLevel)});
        }
        return 1;
    }

    private static int checkHealth(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer pl = EntityArgument.getPlayer(context, (String)"player");
        if (pl != ((CommandSourceStack)context.getSource()).getEntityOrException()) {
            if (!((CommandSourceStack)context.getSource()).hasPermission(2)) {
                throw AoACommand.NO_PERMISSION_EXCEPTION.create();
            }
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new Component[0]);
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "command.aoa.player.health.check.other", AoACommand.CommandFeedbackType.SUCCESS, new Component[]{pl.getDisplayName(), Component.literal((String)NumberUtil.roundToNthDecimalPlace(pl.getHealth(), 2)), Component.literal((String)NumberUtil.roundToNthDecimalPlace(pl.getMaxHealth(), 2))});
        } else {
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new Component[0]);
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "command.aoa.player.health.check.self", AoACommand.CommandFeedbackType.SUCCESS, new Component[]{Component.literal((String)NumberUtil.roundToNthDecimalPlace(pl.getHealth(), 2)), Component.literal((String)NumberUtil.roundToNthDecimalPlace(pl.getMaxHealth(), 2))});
        }
        return 1;
    }

    private static int checkSkill(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer pl = EntityArgument.getPlayer(context, (String)"player");
        if (pl != ((CommandSourceStack)context.getSource()).getEntityOrException()) {
            if (!((CommandSourceStack)context.getSource()).hasPermission(2)) {
                throw AoACommand.NO_PERMISSION_EXCEPTION.create();
            }
            AoASkill skill = AoASkillArgument.getSkill(context, "skill");
            int level = PlayerUtil.getLevel((Player)pl, skill);
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new Component[0]);
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "command.aoa.player.skill.check.other", AoACommand.CommandFeedbackType.SUCCESS, new Component[]{pl.getDisplayName(), skill.getName(), LocaleUtil.numToComponent(level)});
        } else {
            AoASkill skill = AoASkillArgument.getSkill(context, "skill");
            int level = PlayerUtil.getLevel((Player)pl, skill);
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new Component[0]);
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "command.aoa.player.skill.check.self", AoACommand.CommandFeedbackType.SUCCESS, new Component[]{skill.getName(), LocaleUtil.numToComponent(level)});
        }
        return 1;
    }

    private static int checkXp(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer pl = EntityArgument.getPlayer(context, (String)"player");
        if (pl != ((CommandSourceStack)context.getSource()).getEntityOrException()) {
            if (!((CommandSourceStack)context.getSource()).hasPermission(2)) {
                throw AoACommand.NO_PERMISSION_EXCEPTION.create();
            }
            AoASkill skill = AoASkillArgument.getSkill(context, "skill");
            float xp = PlayerUtil.getAdventPlayer(pl).getSkill(skill).getXp();
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new Component[0]);
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "command.aoa.player.xp.check.other", AoACommand.CommandFeedbackType.SUCCESS, new Component[]{pl.getDisplayName(), skill.getName(), LocaleUtil.numToComponent(Float.valueOf(xp))});
        } else {
            AoASkill skill = AoASkillArgument.getSkill(context, "skill");
            float xp = PlayerUtil.getAdventPlayer(pl).getSkill(skill).getXp();
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new Component[0]);
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "command.aoa.player.xp.check.self", AoACommand.CommandFeedbackType.SUCCESS, new Component[]{skill.getName(), LocaleUtil.numToComponent(Float.valueOf(xp))});
        }
        return 1;
    }

    private static int checkCycle(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer pl = EntityArgument.getPlayer(context, (String)"player");
        if (pl != ((CommandSourceStack)context.getSource()).getEntityOrException()) {
            if (!((CommandSourceStack)context.getSource()).hasPermission(2)) {
                throw AoACommand.NO_PERMISSION_EXCEPTION.create();
            }
            AoASkill skill = AoASkillArgument.getSkill(context, "skill");
            int cycles = PlayerUtil.getAdventPlayer(pl).getSkill(skill).getCycles();
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new Component[0]);
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "command.aoa.player.cycle.check.other", AoACommand.CommandFeedbackType.SUCCESS, new Component[]{pl.getDisplayName(), skill.getName(), LocaleUtil.numToComponent(cycles)});
        } else {
            AoASkill skill = AoASkillArgument.getSkill(context, "skill");
            int cycles = PlayerUtil.getAdventPlayer(pl).getSkill(skill).getCycles();
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new Component[0]);
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "command.aoa.player.cycle.check.self", AoACommand.CommandFeedbackType.SUCCESS, new Component[]{skill.getName(), LocaleUtil.numToComponent(cycles)});
        }
        return 1;
    }

    private static int checkResource(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer pl = EntityArgument.getPlayer(context, (String)"player");
        if (pl != ((CommandSourceStack)context.getSource()).getEntityOrException()) {
            if (!((CommandSourceStack)context.getSource()).hasPermission(2)) {
                throw AoACommand.NO_PERMISSION_EXCEPTION.create();
            }
            AoAResource resource = AoAResourceArgument.getResource(context, "resource");
            float value = PlayerUtil.getResourceValue((Player)pl, resource);
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new Component[0]);
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "command.aoa.player.resource.check.other", AoACommand.CommandFeedbackType.SUCCESS, new Component[]{pl.getDisplayName(), LocaleUtil.numToComponent(Float.valueOf(value)), resource.getName()});
        } else {
            AoAResource resource = AoAResourceArgument.getResource(context, "resource");
            float value = PlayerUtil.getResourceValue((Player)pl, resource);
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new Component[0]);
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "command.aoa.player.resource.check.self", AoACommand.CommandFeedbackType.SUCCESS, new Component[]{resource.getName(), LocaleUtil.numToComponent(Float.valueOf(value))});
        }
        return 1;
    }

    private static int adjustSkills(CommandContext<CommandSourceStack> context, String operation) throws CommandSyntaxException {
        int value = IntegerArgumentType.getInteger(context, (String)"value");
        AoASkill skill = AoASkillArgument.getSkill(context, "skill");
        ServerPlayer pl = EntityArgument.getPlayer(context, (String)"player");
        AoASkill.Instance instance = PlayerUtil.getSkill((Player)pl, skill);
        int adjustment = 0;
        switch (operation) {
            case "add": {
                value = Math.abs(value);
                adjustment = Math.min(value, 1000 - instance.getLevel(true));
                instance.setLevel(instance.getLevel(true) + value);
                break;
            }
            case "subtract": {
                value = Math.abs(value);
                adjustment = -Math.min(value, instance.getLevel(true) - 1);
                instance.setLevel(instance.getLevel(true) - value);
                break;
            }
            case "set": {
                value = Mth.clamp((int)value, (int)1, (int)1000);
                adjustment = value - instance.getLevel(true);
                instance.setLevel(value);
            }
        }
        AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new Component[0]);
        AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "command.aoa.player.skill.adjust", AoACommand.CommandFeedbackType.SUCCESS, new Component[]{pl.getDisplayName(), skill.getName(), LocaleUtil.numToComponent(adjustment), LocaleUtil.numToComponent(instance.getLevel(true))});
        return 1;
    }

    private static int adjustXp(CommandContext<CommandSourceStack> context, String operation) throws CommandSyntaxException {
        float value = FloatArgumentType.getFloat(context, (String)"value");
        AoASkill skill = AoASkillArgument.getSkill(context, "skill");
        ServerPlayer pl = EntityArgument.getPlayer(context, (String)"player");
        AoASkill.Instance instance = PlayerUtil.getSkill((Player)pl, skill);
        float adjustment = value;
        switch (operation) {
            case "add": {
                value = Math.abs(value);
                instance.adjustXp(value, true, true);
                break;
            }
            case "subtract": {
                value = Math.abs(value);
                instance.adjustXp(-value, true, true);
                break;
            }
            case "set": {
                float maxXpForLevel = PlayerUtil.getXpRequiredForNextLevel(instance.getLevel(true));
                float curXp = instance.getXp();
                value = Mth.clamp((float)value, (float)0.0f, (float)maxXpForLevel);
                adjustment = value - curXp;
                if (adjustment > 0.0f) {
                    instance.adjustXp(adjustment, true, true);
                    break;
                }
                instance.adjustXp(-adjustment, true, true);
            }
        }
        AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new Component[0]);
        AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "command.aoa.player.xp.adjust", AoACommand.CommandFeedbackType.SUCCESS, new Component[]{pl.getDisplayName(), skill.getName(), LocaleUtil.numToComponent(Float.valueOf(adjustment)), LocaleUtil.numToComponent(Float.valueOf(instance.getXp()))});
        return 1;
    }

    private static int adjustCycle(CommandContext<CommandSourceStack> context, String operation) throws CommandSyntaxException {
        int value = IntegerArgumentType.getInteger(context, (String)"value");
        AoASkill skill = AoASkillArgument.getSkill(context, "skill");
        ServerPlayer pl = EntityArgument.getPlayer(context, (String)"player");
        AoASkill.Instance instance = PlayerUtil.getSkill((Player)pl, skill);
        float adjustment = value;
        switch (operation) {
            case "add": {
                value = Mth.clamp((int)value, (int)1, (int)(10 - instance.getCycles()));
                adjustment = Math.min(value, 10 - instance.getCycles());
                instance.setCycle(instance.getCycles() + value);
                break;
            }
            case "subtract": {
                value = Mth.clamp((int)value, (int)1, (int)instance.getCycles());
                adjustment = Math.min(value, instance.getCycles());
                instance.setCycle(instance.getCycles() - value);
                break;
            }
            case "set": {
                value = Mth.clamp((int)value, (int)0, (int)10);
                adjustment = value - instance.getCycles();
                instance.setCycle(value);
            }
        }
        AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new Component[0]);
        AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "command.aoa.player.cycle.adjust", AoACommand.CommandFeedbackType.SUCCESS, new Component[]{pl.getDisplayName(), skill.getName(), LocaleUtil.numToComponent(Float.valueOf(adjustment)), LocaleUtil.numToComponent(instance.getCycles())});
        return 1;
    }

    private static int adjustResources(CommandContext<CommandSourceStack> context, String operation) throws CommandSyntaxException {
        float value = FloatArgumentType.getFloat(context, (String)"value");
        AoAResource resource = AoAResourceArgument.getResource(context, "resource");
        ServerPlayer pl = EntityArgument.getPlayer(context, (String)"player");
        AoAResource.Instance instance = PlayerUtil.getResource((Player)pl, resource);
        float adjustment = 0.0f;
        switch (operation) {
            case "add": {
                adjustment = Math.min(value, instance.getMaxValue() - instance.getCurrentValue());
                instance.addValue(adjustment);
                break;
            }
            case "subtract": {
                adjustment = -Math.min(value, instance.getCurrentValue());
                instance.consume(adjustment, true);
                break;
            }
            case "set": {
                instance.setValue(value);
            }
        }
        AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new Component[0]);
        AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "command.aoa.player.resource.adjust", AoACommand.CommandFeedbackType.SUCCESS, new Component[]{pl.getDisplayName(), resource.getName(), LocaleUtil.numToComponent(Float.valueOf(adjustment)), LocaleUtil.numToComponent(Float.valueOf(instance.getCurrentValue()))});
        return 1;
    }

    private static int adjustHealth(CommandContext<CommandSourceStack> context, String operation) throws CommandSyntaxException {
        float value = FloatArgumentType.getFloat(context, (String)"amount");
        ServerPlayer pl = EntityArgument.getPlayer(context, (String)"player");
        float adjustment = 0.0f;
        switch (operation) {
            case "add": {
                adjustment = Math.min(value, pl.getMaxHealth() - pl.getHealth());
                pl.setHealth(pl.getHealth() + adjustment);
                break;
            }
            case "subtract": {
                adjustment = -Math.min(value, pl.getHealth());
                pl.setHealth(pl.getHealth() + adjustment);
                break;
            }
            case "set": {
                float newHealth = Mth.clamp((float)value, (float)0.0f, (float)pl.getMaxHealth());
                adjustment = newHealth - pl.getHealth();
                pl.setHealth(newHealth);
            }
        }
        AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new Component[0]);
        AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "command.aoa.player.health.adjust", AoACommand.CommandFeedbackType.SUCCESS, new Component[]{pl.getDisplayName(), Component.literal((String)NumberUtil.roundToNthDecimalPlace(adjustment, 2)), Component.literal((String)NumberUtil.roundToNthDecimalPlace(pl.getHealth(), 2)), Component.literal((String)NumberUtil.roundToNthDecimalPlace(pl.getMaxHealth(), 2))});
        return 1;
    }

    private static int adjustVanillaXp(CommandContext<CommandSourceStack> context, String operation) throws CommandSyntaxException {
        int value = IntegerArgumentType.getInteger(context, (String)"amount");
        ServerPlayer pl = EntityArgument.getPlayer(context, (String)"player");
        int adjustment = 0;
        switch (operation) {
            case "add": {
                adjustment = Math.min(value, Integer.MAX_VALUE - pl.totalExperience);
                pl.giveExperiencePoints(adjustment);
                break;
            }
            case "subtract": {
                adjustment = -Math.min(value, pl.totalExperience);
                pl.giveExperiencePoints(adjustment);
                break;
            }
            case "set": {
                adjustment = value - pl.totalExperience;
                pl.giveExperiencePoints(adjustment);
            }
        }
        AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new Component[0]);
        AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "command.aoa.player.exp.adjust", AoACommand.CommandFeedbackType.SUCCESS, new Component[]{pl.getDisplayName(), LocaleUtil.numToComponent(adjustment), LocaleUtil.numToComponent(pl.totalExperience), LocaleUtil.numToComponent(pl.experienceLevel)});
        return 1;
    }

    private static int adjustFoodStats(CommandContext<CommandSourceStack> context, String operation, String subsection) throws CommandSyntaxException {
        int value = IntegerArgumentType.getInteger(context, (String)"amount");
        ServerPlayer pl = EntityArgument.getPlayer(context, (String)"player");
        FoodData food = pl.getFoodData();
        if (operation.equals("hunger")) {
            int adjustment = 0;
            switch (subsection) {
                case "add": {
                    adjustment = Math.min(value, 20 - food.getFoodLevel());
                    food.eat(adjustment, 0.0f);
                    break;
                }
                case "subtract": {
                    adjustment = -Math.min(value, food.getFoodLevel());
                    food.setFoodLevel(food.getFoodLevel() + adjustment);
                    break;
                }
                case "set": {
                    int newHunger = Mth.clamp((int)value, (int)0, (int)20);
                    adjustment = newHunger - food.getFoodLevel();
                    food.setFoodLevel(newHunger);
                }
            }
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new Component[0]);
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "command.aoa.player.food.adjust", AoACommand.CommandFeedbackType.SUCCESS, new Component[]{pl.getDisplayName(), LocaleUtil.numToComponent(adjustment), LocaleUtil.numToComponent(food.getFoodLevel())});
        } else {
            float adjustment = 0.0f;
            switch (subsection) {
                case "add": {
                    adjustment = value;
                    food.eat(1, (float)value / 2.0f);
                    break;
                }
                case "subtract": {
                    adjustment = -Math.min((float)value, food.getSaturationLevel());
                    food.eat(1, adjustment / 2.0f);
                    break;
                }
                case "set": {
                    adjustment = (float)value - food.getSaturationLevel();
                    food.eat(1, adjustment / 2.0f);
                }
            }
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "--", AoACommand.CommandFeedbackType.INFO, new Component[0]);
            AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "command.aoa.player.saturation.adjust", AoACommand.CommandFeedbackType.SUCCESS, new Component[]{pl.getDisplayName(), LocaleUtil.numToComponent(Float.valueOf(adjustment)), LocaleUtil.numToComponent(Float.valueOf(food.getSaturationLevel()))});
        }
        return 1;
    }

    public int run(CommandContext<CommandSourceStack> context) {
        AoACommand.feedback((CommandSourceStack)context.getSource(), "Player", "command.aoa.player.desc", AoACommand.CommandFeedbackType.INFO, new Component[0]);
        return 1;
    }
}

