/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.shader;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.IOException;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.common.registration.item.AoAArmour;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import org.apache.logging.log4j.Level;

public final class AoAPostProcessing {
    private static final Map<ResourceLocation, PostChain> ACTIVE_EFFECTS = new Object2ObjectArrayMap();
    private static final ResourceLocation DUSTOPIA_DESATURATE = AdventOfAscension.id("shaders/post/dustopia_desaturate.json");
    private static final ResourceLocation CHROMA_GOGGLES = AdventOfAscension.id("shaders/post/chroma_goggles.json");

    public static void init() {
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.addListener(AoAPostProcessing::playerLogout);
        eventBus.addListener(AoAPostProcessing::playerLogin);
        eventBus.addListener(AoAPostProcessing::playerRespawn);
        eventBus.addListener(AoAPostProcessing::clientTick);
    }

    public static boolean activateEffect(ResourceLocation shader) {
        if (ACTIVE_EFFECTS.containsKey(shader)) {
            return false;
        }
        try {
            Minecraft mc = Minecraft.getInstance();
            PostChain effect = new PostChain(mc.getTextureManager(), (ResourceProvider)mc.getResourceManager(), mc.getMainRenderTarget(), shader);
            effect.resize(mc.getWindow().getWidth(), mc.getWindow().getHeight());
            ACTIVE_EFFECTS.put(shader, effect);
        }
        catch (IOException ex) {
            Logging.logMessage(Level.WARN, "Failed to load shader: " + String.valueOf(shader), ex);
        }
        catch (JsonSyntaxException ex) {
            Logging.logMessage(Level.WARN, "Failed to parse shader: " + String.valueOf(shader), (Exception)((Object)ex));
        }
        return true;
    }

    public static void deactivateEffect(ResourceLocation shader) {
        if (!ACTIVE_EFFECTS.containsKey(shader)) {
            return;
        }
        ACTIVE_EFFECTS.remove(shader).close();
    }

    public static void resizeShaders(int width, int height) {
        for (PostChain shader : ACTIVE_EFFECTS.values()) {
            shader.resize(width, height);
        }
    }

    public static void shutdownShaders() {
        for (PostChain shader : ACTIVE_EFFECTS.values()) {
            shader.close();
        }
        ACTIVE_EFFECTS.clear();
    }

    public static void doShaderProcessing(float partialTick) {
        if (ACTIVE_EFFECTS.isEmpty()) {
            return;
        }
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.resetTextureMatrix();
        for (PostChain shader : ACTIVE_EFFECTS.values()) {
            shader.process(partialTick);
        }
    }

    private static void clientTick(ClientTickEvent.Pre ev) {
        AoAPostProcessing.checkNightVisionGogglesShader(ClientOperations.getPlayer());
    }

    private static void playerLogin(ClientPlayerNetworkEvent.LoggingIn ev) {
        AoAPostProcessing.checkDustopiaShader(ClientOperations.getPlayer());
    }

    private static void playerLogout(ClientPlayerNetworkEvent.LoggingOut ev) {
        AoAPostProcessing.shutdownShaders();
    }

    private static void playerRespawn(ClientPlayerNetworkEvent.Clone ev) {
        AoAPostProcessing.checkDustopiaShader(ClientOperations.getPlayer());
    }

    private static void checkDustopiaShader(Player player) {
        if (player.level().dimension() == AoADimensions.DUSTOPIA) {
            AoAPostProcessing.activateEffect(DUSTOPIA_DESATURATE);
        } else {
            AoAPostProcessing.deactivateEffect(DUSTOPIA_DESATURATE);
        }
    }

    private static void checkNightVisionGogglesShader(Player player) {
        if (player != null && player.getItemBySlot(EquipmentSlot.HEAD).is(AoAArmour.CHROMA_GOGGLES)) {
            AoAPostProcessing.activateEffect(CHROMA_GOGGLES);
        } else {
            AoAPostProcessing.deactivateEffect(CHROMA_GOGGLES);
        }
    }
}

