/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.dimension;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.render.dimension.AoADimensionEffectsRenderer;
import net.tslat.aoa3.util.RenderUtil;
import org.joml.Matrix4f;

public class LBoreanRenderingEffects
extends AoADimensionEffectsRenderer {
    public static final ResourceLocation ID = AdventOfAscension.id("lborean");

    LBoreanRenderingEffects() {
        super(400.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
        this.noWeather();
    }

    @Override
    public boolean renderSky(ClientLevel level, int ticks, float partialTick, Matrix4f frustumMatrix, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        setupFog.run();
        if (!isFoggy) {
            Minecraft mc = Minecraft.getInstance();
            LevelRenderer levelRenderer = mc.levelRenderer;
            FogType fogtype = camera.getFluidInCamera();
            if (fogtype != FogType.POWDER_SNOW && fogtype != FogType.LAVA && !levelRenderer.doesMobEffectBlockSky(camera)) {
                float starBrightness;
                BufferBuilder bufferBuilder;
                PoseStack poseStack = new PoseStack();
                Vec3 skyColour = level.getSkyColor(mc.gameRenderer.getMainCamera().getPosition(), partialTick);
                float skyColourRed = (float)skyColour.x;
                float skyColourGreen = (float)skyColour.y;
                float skyColourBlue = (float)skyColour.z;
                Tesselator tesselator = Tesselator.getInstance();
                ShaderInstance shader = RenderSystem.getShader();
                poseStack.mulPose(projectionMatrix);
                FogRenderer.levelFogColor();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.setShaderColor((float)skyColourRed, (float)skyColourGreen, (float)skyColourBlue, (float)1.0f);
                levelRenderer.skyBuffer.bind();
                levelRenderer.skyBuffer.drawWithShader(frustumMatrix, projectionMatrix, shader);
                VertexBuffer.unbind();
                RenderSystem.enableBlend();
                float[] sunriseColour = level.effects().getSunriseColor(level.getTimeOfDay(partialTick), partialTick);
                if (sunriseColour != null) {
                    RenderSystem.setShader(GameRenderer::getPositionColorShader);
                    RenderUtil.resetShaderColour();
                    poseStack.pushPose();
                    poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    float sunAngle = Mth.sin((float)level.getSunAngle(partialTick)) < 0.0f ? 180.0f : 0.0f;
                    poseStack.mulPose(Axis.ZP.rotationDegrees(sunAngle));
                    poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                    float sunriseRed = sunriseColour[0];
                    float sunriseGreen = sunriseColour[1];
                    float sunriseBlue = sunriseColour[2];
                    Matrix4f pose = poseStack.last().pose();
                    bufferBuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
                    bufferBuilder.addVertex(pose, 0.0f, 100.0f, 0.0f).setColor(sunriseRed, sunriseGreen, sunriseBlue, sunriseColour[3]);
                    for (int section = 0; section <= 16; ++section) {
                        float sectionAngle = (float)section * ((float)Math.PI * 2) / 16.0f;
                        float angleX = Mth.sin((float)sectionAngle);
                        float angleZ = Mth.cos((float)sectionAngle);
                        bufferBuilder.addVertex(pose, angleX * 120.0f, angleZ * 120.0f, -angleZ * 40.0f * sunriseColour[3]).setColor(sunriseColour[0], sunriseColour[1], sunriseColour[2], 0.0f);
                    }
                    BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
                    poseStack.popPose();
                }
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                poseStack.pushPose();
                float rainAmount = 1.0f - level.getRainLevel(partialTick);
                float dayAngle = level.getTimeOfDay(partialTick) * 360.0f;
                float celestialQuadRadius = 30.0f;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)rainAmount);
                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                poseStack.mulPose(Axis.XP.rotationDegrees(dayAngle));
                Matrix4f pose = poseStack.last().pose();
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                if (dayAngle > 286.0f || dayAngle < 82.0f) {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)SUN_TEXTURE);
                    bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                    bufferBuilder.addVertex(pose, -celestialQuadRadius, 100.0f, -celestialQuadRadius).setUv(0.0f, 0.0f);
                    bufferBuilder.addVertex(pose, celestialQuadRadius, 100.0f, -celestialQuadRadius).setUv(1.0f, 0.0f);
                    bufferBuilder.addVertex(pose, celestialQuadRadius, 100.0f, celestialQuadRadius).setUv(1.0f, 1.0f);
                    bufferBuilder.addVertex(pose, -celestialQuadRadius, 100.0f, celestialQuadRadius).setUv(0.0f, 1.0f);
                    BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
                }
                if (dayAngle > 101.0f && dayAngle < 258.0f) {
                    celestialQuadRadius = 20.0f;
                    int moonPhaseIndex = level.getMoonPhase();
                    int phaseRow = moonPhaseIndex % 4;
                    int phaseColumn = moonPhaseIndex / 4 % 2;
                    float uMin = (float)phaseRow / 4.0f;
                    float vMin = (float)phaseColumn / 2.0f;
                    float uMax = (float)(phaseRow + 1) / 4.0f;
                    float vMax = (float)(phaseColumn + 1) / 2.0f;
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)MOON_TEXTURE);
                    bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                    bufferBuilder.addVertex(pose, -celestialQuadRadius, -100.0f, celestialQuadRadius).setUv(uMax, vMax);
                    bufferBuilder.addVertex(pose, celestialQuadRadius, -100.0f, celestialQuadRadius).setUv(uMin, vMax);
                    bufferBuilder.addVertex(pose, celestialQuadRadius, -100.0f, -celestialQuadRadius).setUv(uMin, vMin);
                    bufferBuilder.addVertex(pose, -celestialQuadRadius, -100.0f, -celestialQuadRadius).setUv(uMax, vMin);
                    BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
                }
                if ((starBrightness = level.getStarBrightness(partialTick) * rainAmount) > 0.0f) {
                    RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)starBrightness);
                    FogRenderer.setupNoFog();
                    levelRenderer.starBuffer.bind();
                    levelRenderer.starBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, GameRenderer.getPositionShader());
                    VertexBuffer.unbind();
                    setupFog.run();
                }
                RenderUtil.resetShaderColour();
                RenderSystem.disableBlend();
                RenderSystem.defaultBlendFunc();
                poseStack.popPose();
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                double darknessDepth = mc.player.getEyePosition((float)partialTick).y - level.getLevelData().getHorizonHeight((LevelHeightAccessor)level);
                if (darknessDepth < 0.0) {
                    poseStack.pushPose();
                    poseStack.translate(0.0f, 12.0f, 0.0f);
                    levelRenderer.darkBuffer.bind();
                    levelRenderer.darkBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, shader);
                    VertexBuffer.unbind();
                    poseStack.popPose();
                }
                RenderUtil.resetShaderColour();
                RenderSystem.depthMask((boolean)true);
            }
        }
        return true;
    }
}

