/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.dimension;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.client.render.dimension.AoADimensionEffectsRenderer;
import net.tslat.aoa3.common.particleoption.EntityTrackingParticleOptions;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.custom.AoAWorldEvents;
import net.tslat.aoa3.content.world.event.AoAWorldEvent;
import net.tslat.aoa3.content.world.event.AoAWorldEventManager;
import net.tslat.aoa3.content.world.event.BarathosSandstormEvent;
import net.tslat.aoa3.library.object.ExtendedBulkSectionAccess;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class BarathosRenderingEffects
extends AoADimensionEffectsRenderer {
    public static final ResourceLocation ID = AdventOfAscension.id("barathos");
    private float currentLight = 15.0f;
    private BarathosSandstormEvent sandstorm = null;

    BarathosRenderingEffects() {
        super(Float.NaN, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
    }

    @Override
    public void adjustFogRender(ClientLevel level, FogRenderer.FogMode fogMode, FogType fogType, Camera camera, FloatConsumer farPlaneDistance, FloatConsumer nearPlaneDistance) {
        float cameraHeight = (float)camera.getPosition().y;
        if (cameraHeight < 80.0f || cameraHeight > 125.0f && fogMode == FogRenderer.FogMode.FOG_SKY) {
            return;
        }
        float skyLight = level.getBrightness(LightLayer.SKY, camera.getBlockPosition());
        if (this.currentLight != skyLight) {
            float signum;
            skyLight = this.currentLight = Mth.clamp((float)(this.currentLight + signum * ((signum = Math.signum(skyLight - this.currentLight)) < 0.0f ? 0.005f : 0.01f)), (float)0.0f, (float)15.0f);
        }
        if (skyLight == 0.0f) {
            return;
        }
        float delta = Math.abs(cameraHeight - 105.0f);
        float fogCeiling = Math.max(0.0f, cameraHeight - 142.0f);
        float caveDelta = Math.max(0.0f, 1.0f - skyLight / 15.0f);
        farPlaneDistance.accept(Mth.clamp((float)(150.0f - delta * 4.0f), (float)50.0f, (float)150.0f) + fogCeiling);
        nearPlaneDistance.accept(Mth.clamp((float)(-150.0f + delta * 7.0f + caveDelta * 170.0f), (float)-150.0f, (float)20.0f) + fogCeiling);
    }

    @Override
    public void doFXTick(ClientLevel level, int playerX, int playerY, int playerZ) {
        BarathosSandstormEvent event;
        AoAWorldEvent aoAWorldEvent = AoAWorldEventManager.getEventById((Level)level, AoAWorldEvents.BARATHOS_SANDSTORM.getId());
        this.sandstorm = aoAWorldEvent instanceof BarathosSandstormEvent && (event = (BarathosSandstormEvent)aoAWorldEvent).isActive() ? event : null;
        super.doFXTick(level, playerX, playerY, playerZ);
    }

    @Override
    public boolean spawnAmbientParticle(ClientLevel level, ExtendedBulkSectionAccess sectionAccess, BlockPos pos, Biome biome) {
        if (pos.getY() <= 125) {
            if (pos.getY() >= 90) {
                if (this.sandstorm != null) {
                    if (level.getBrightness(LightLayer.SKY, pos) == 15) {
                        float intensity = this.sandstorm.getIntensity(level.getGameTime());
                        float rotProgress = (float)level.getGameTime() / 60.0f % 360.0f * ((float)Math.PI / 180);
                        Vec3 angle = new Vec3(Math.cos(rotProgress), 0.0, Math.sin(rotProgress)).scale((double)(Mth.sin((float)((float)level.getGameTime() / (level.getGameTime() % 1000L > 250L ? 20.0f : 1.0f) % 360.0f * ((float)Math.PI / 180))) * 0.4f * intensity + 0.9f));
                        ParticleBuilder.forPositions((ParticleOptions)EntityTrackingParticleOptions.ambient(AoAParticleTypes.SANDSTORM), (Vec3[])new Vec3[]{Vec3.atLowerCornerOf((Vec3i)pos).add(level.random.nextDouble(), level.random.nextDouble(), level.random.nextDouble())}).scaleMod(0.6f * intensity).lifespan(Mth.ceil((float)(5.0f / (level.random.nextFloat() * 0.8f + 0.2f)))).colourOverride(12894369).velocity(angle).spawnParticles((Level)level);
                    }
                } else if (0.009857199f > level.random.nextFloat()) {
                    float rotProgress = (float)level.getGameTime() / 60.0f % 360.0f * ((float)Math.PI / 180);
                    Vec3 angle = new Vec3(Math.cos(rotProgress), 0.0, Math.sin(rotProgress)).scale((double)(Mth.sin((float)((float)level.getGameTime() / (level.getGameTime() % 1000L > 250L ? 20.0f : 1.0f) % 360.0f * ((float)Math.PI / 180))) * 0.3f));
                    ParticleBuilder.forPositions((ParticleOptions)EntityTrackingParticleOptions.ambient(AoAParticleTypes.SANDSTORM), (Vec3[])new Vec3[]{Vec3.atLowerCornerOf((Vec3i)pos).add(level.random.nextDouble(), level.random.nextDouble(), level.random.nextDouble())}).scaleMod(0.3f).lifespan(Mth.ceil((float)(10.0f / (level.random.nextFloat() * 0.8f + 0.2f)))).colourOverride(12894369).velocity(angle).spawnParticles((Level)level);
                }
            } else if (0.098572f >= level.random.nextFloat()) {
                ParticleBuilder.forPositions((ParticleOptions)ParticleTypes.SMOKE, (Vec3[])new Vec3[]{Vec3.atLowerCornerOf((Vec3i)pos).add(level.random.nextDouble(), level.random.nextDouble(), level.random.nextDouble())}).lifespan(Mth.ceil((float)(5.0f / (level.random.nextFloat() * 0.8f + 0.2f)))).velocity(0.0, (double)0.05f, 0.0).spawnParticles((Level)level);
            }
        }
        return true;
    }

    @Override
    public boolean isFoggyAt(int posX, int posY) {
        return posY > 85 && posY < 105;
    }

    @Override
    @Nullable
    public float[] getSunriseColor(float timeOfDay, float partialTick) {
        return super.getSunriseColor(timeOfDay, partialTick);
    }

    @Override
    public Vec3 getBrightnessDependentFogColor(Vec3 fogColour, float brightness) {
        double delta = 1.0 - Mth.clamp((double)((70.0 - ClientOperations.getPlayer().getY()) / 10.0), (double)0.0, (double)1.0);
        return fogColour.multiply(Math.max(0.658823549747467, delta), Math.max(0.07450980693101883, delta), Math.max(0.0, delta));
    }

    @Override
    public boolean renderSky(ClientLevel level, int ticks, float partialTick, Matrix4f frustumMatrix, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        Minecraft mc = Minecraft.getInstance();
        LevelRenderer levelRenderer = mc.levelRenderer;
        setupFog.run();
        FogType screenFogType = camera.getFluidInCamera();
        if (screenFogType != FogType.POWDER_SNOW && screenFogType != FogType.LAVA && !levelRenderer.doesMobEffectBlockSky(camera)) {
            PoseStack poseStack = new PoseStack();
            poseStack.mulPose(frustumMatrix);
            if (mc.level.effects().skyType() == DimensionSpecialEffects.SkyType.END) {
                levelRenderer.renderEndSky(poseStack);
            } else if (mc.level.effects().skyType() == DimensionSpecialEffects.SkyType.NORMAL) {
                Matrix4f pose;
                Vec3 skyColour = level.getSkyColor(mc.gameRenderer.getMainCamera().getPosition(), partialTick);
                Tesselator tesselator = Tesselator.getInstance();
                ShaderInstance shaderInstance = RenderSystem.getShader();
                float rainStrength = 1.0f - level.getRainLevel(partialTick);
                float[] sunriseColour = level.effects().getSunriseColor(level.getTimeOfDay(partialTick), partialTick);
                FogRenderer.levelFogColor();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.setShaderColor((float)((float)skyColour.x), (float)((float)skyColour.y), (float)((float)skyColour.z), (float)1.0f);
                levelRenderer.skyBuffer.bind();
                levelRenderer.skyBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, shaderInstance);
                VertexBuffer.unbind();
                RenderSystem.enableBlend();
                if (sunriseColour != null) {
                    RenderSystem.setShader(GameRenderer::getPositionColorShader);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    poseStack.pushPose();
                    poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.sin((float)level.getSunAngle(partialTick)) < 0.0f ? 180.0f : 0.0f));
                    poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                    pose = poseStack.last().pose();
                    BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
                    buffer.addVertex(pose, 0.0f, 100.0f, 0.0f).setColor(sunriseColour[0], sunriseColour[1], sunriseColour[2], sunriseColour[3]);
                    for (int i = 0; i <= 16; ++i) {
                        float angle = (float)i * ((float)Math.PI * 2) / 16.0f;
                        float cosine = Mth.cos((float)angle);
                        buffer.addVertex(pose, Mth.sin((float)angle) * 120.0f, cosine * 120.0f, -cosine * 40.0f * sunriseColour[3]).setColor(sunriseColour[0], sunriseColour[1], sunriseColour[2], 0.0f);
                    }
                    BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
                    poseStack.popPose();
                }
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                poseStack.pushPose();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)rainStrength);
                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                poseStack.mulPose(Axis.XP.rotationDegrees(level.getTimeOfDay(partialTick) * 360.0f));
                pose = poseStack.last().pose();
                float celestialRadius = 65.0f;
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)LevelRenderer.SUN_LOCATION);
                BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                buffer.addVertex(pose, -celestialRadius, 100.0f, -celestialRadius).setUv(0.0f, 0.0f);
                buffer.addVertex(pose, celestialRadius, 100.0f, -celestialRadius).setUv(1.0f, 0.0f);
                buffer.addVertex(pose, celestialRadius, 100.0f, celestialRadius).setUv(1.0f, 1.0f);
                buffer.addVertex(pose, -celestialRadius, 100.0f, celestialRadius).setUv(0.0f, 1.0f);
                buffer.addVertex(pose, -celestialRadius + 40.0f, 155.0f, -celestialRadius + 40.0f).setUv(0.0f, 0.0f);
                buffer.addVertex(pose, celestialRadius + 40.0f, 155.0f, -celestialRadius + 40.0f).setUv(1.0f, 0.0f);
                buffer.addVertex(pose, celestialRadius + 40.0f, 155.0f, celestialRadius + 40.0f).setUv(1.0f, 1.0f);
                buffer.addVertex(pose, -celestialRadius + 40.0f, 155.0f, celestialRadius + 40.0f).setUv(0.0f, 1.0f);
                BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
                if (level.dimensionType().fixedTime().orElse(0L) != 2000L) {
                    float starBrightness = level.getStarBrightness(partialTick) * rainStrength;
                    int moonPhase = level.getMoonPhase();
                    int uColumn = moonPhase % 4;
                    int vRow = moonPhase / 4 % 2;
                    float uMin = (float)uColumn / 4.0f;
                    float vMin = (float)vRow / 2.0f;
                    float uMax = (float)(uColumn + 1) / 4.0f;
                    float vMax = (float)(vRow + 1) / 2.0f;
                    celestialRadius = 20.0f;
                    buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)LevelRenderer.MOON_LOCATION);
                    buffer.addVertex(pose, -celestialRadius, -100.0f, celestialRadius).setUv(uMax, vMax);
                    buffer.addVertex(pose, celestialRadius, -100.0f, celestialRadius).setUv(uMin, vMax);
                    buffer.addVertex(pose, celestialRadius, -100.0f, -celestialRadius).setUv(uMin, vMin);
                    buffer.addVertex(pose, -celestialRadius, -100.0f, -celestialRadius).setUv(uMax, vMin);
                    BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
                    if (starBrightness > 0.0f) {
                        RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)starBrightness);
                        FogRenderer.setupNoFog();
                        levelRenderer.starBuffer.bind();
                        levelRenderer.starBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, GameRenderer.getPositionShader());
                        VertexBuffer.unbind();
                        setupFog.run();
                    }
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                RenderSystem.defaultBlendFunc();
                poseStack.popPose();
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                if (mc.player.getEyePosition((float)partialTick).y - level.getLevelData().getHorizonHeight((LevelHeightAccessor)level) < 0.0) {
                    poseStack.pushPose();
                    poseStack.translate(0.0f, 12.0f, 0.0f);
                    levelRenderer.darkBuffer.bind();
                    levelRenderer.darkBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, shaderInstance);
                    VertexBuffer.unbind();
                    poseStack.popPose();
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.depthMask((boolean)true);
            }
        }
        return true;
    }
}

