/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.dimension;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.library.object.ExtendedBulkSectionAccess;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public abstract class AoADimensionEffectsRenderer
extends DimensionSpecialEffects {
    protected static final ResourceLocation MOON_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/environment/moon_phases.png");
    protected static final ResourceLocation SUN_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/environment/sun.png");
    protected final boolean noClouds;
    protected final boolean noSky;
    protected boolean noWeather = false;

    protected AoADimensionEffectsRenderer(float cloudHeight, boolean hasGround, DimensionSpecialEffects.SkyType skyType, boolean forceBrightLightmap, boolean constantAmbientLight) {
        super(cloudHeight, hasGround, skyType, forceBrightLightmap, constantAmbientLight);
        this.noClouds = Float.isNaN(cloudHeight);
        this.noSky = skyType == DimensionSpecialEffects.SkyType.NONE;
    }

    protected void noWeather() {
        this.noWeather = true;
    }

    @Nullable
    public float[] getSunriseColor(float timeOfDay, float partialTick) {
        return super.getSunriseColor(timeOfDay, partialTick);
    }

    public Vec3 getBrightnessDependentFogColor(Vec3 fogColour, float brightness) {
        return fogColour.multiply((double)(brightness * 0.94f + 0.06f), (double)(brightness * 0.94f + 0.06f), (double)(brightness * 0.91f + 0.09f));
    }

    public boolean isFoggyAt(int posX, int posY) {
        return false;
    }

    public boolean renderClouds(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, double camX, double camY, double camZ, Matrix4f frustumMatrix, Matrix4f projectionMatrix) {
        return this.noClouds;
    }

    public boolean renderSky(ClientLevel level, int ticks, float partialTick, Matrix4f frustumMatrix, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        return this.noSky;
    }

    public boolean renderSnowAndRain(ClientLevel level, int ticks, float partialTick, LightTexture lightTexture, double camX, double camY, double camZ) {
        return this.noWeather;
    }

    public boolean tickRain(ClientLevel level, int ticks, Camera camera) {
        return this.noWeather;
    }

    public void adjustLightmapColors(ClientLevel level, float partialTicks, float skyDarken, float blockLightRedFlicker, float skyLight, int pixelX, int pixelY, Vector3f colors) {
    }

    public void adjustFogRender(ClientLevel level, FogRenderer.FogMode fogMode, FogType fogType, Camera camera, FloatConsumer farPlaneDistance, FloatConsumer nearPlaneDistance) {
    }

    public void doFXTick(ClientLevel level, int playerX, int playerY, int playerZ) {
        RandomSource random = RandomSource.create();
        Block markerParticleTarget = level.getMarkerParticleTarget();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 667; ++i) {
            this.tryFX(level, null, playerX, playerY, playerZ, 16, random, markerParticleTarget, pos);
            this.tryFX(level, null, playerX, playerY, playerZ, 32, random, markerParticleTarget, pos);
        }
    }

    public void tryFX(ClientLevel level, ExtendedBulkSectionAccess sectionAccess, int playerX, int playerY, int playerZ, int radius, RandomSource random, Block markerParticleTarget, BlockPos.MutableBlockPos pos) {
        int x = playerX + level.random.nextInt(radius) - level.random.nextInt(radius);
        int y = playerY + level.random.nextInt(radius) - level.random.nextInt(radius);
        int z = playerZ + level.random.nextInt(radius) - level.random.nextInt(radius);
        pos.set(x, y, z);
        BlockState block = level.getBlockState((BlockPos)pos);
        FluidState fluid = level.getFluidState((BlockPos)pos);
        block.getBlock().animateTick(block, (Level)level, (BlockPos)pos, random);
        if (!fluid.isEmpty()) {
            this.doFluidFXTick(level, sectionAccess, fluid, block, playerX, playerY, playerZ, random, pos);
        }
        if (markerParticleTarget == block.getBlock()) {
            level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK_MARKER, block), (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 0.0, 0.0, 0.0);
        }
        if (!block.isCollisionShapeFullBlock((BlockGetter)level, (BlockPos)pos)) {
            this.doAmbientParticleFXTick(level, sectionAccess, playerX, playerY, playerZ, random, pos);
        }
    }

    protected void doFluidFXTick(ClientLevel level, ExtendedBulkSectionAccess sectionAccess, FluidState fluid, BlockState block, int playerX, int playerY, int playerZ, RandomSource random, BlockPos.MutableBlockPos pos) {
        ParticleOptions dripParticle = fluid.getDripParticle();
        fluid.animateTick((Level)level, (BlockPos)pos, random);
        if (dripParticle != null && level.random.nextInt(10) == 0) {
            BlockPos belowPos = pos.below();
            level.trySpawnDripParticles(belowPos, level.getBlockState(belowPos), dripParticle, block.isFaceSturdy((BlockGetter)level, (BlockPos)pos, Direction.DOWN));
        }
    }

    protected void doAmbientParticleFXTick(ClientLevel level, ExtendedBulkSectionAccess sectionAccess, int playerX, int playerY, int playerZ, RandomSource random, BlockPos.MutableBlockPos pos) {
        Biome biome = (Biome)level.getBiome((BlockPos)pos).value();
        if (!this.spawnAmbientParticle(level, sectionAccess, (BlockPos)pos, biome)) {
            biome.getAmbientParticle().ifPresent(settings -> {
                if (settings.canSpawn(level.random)) {
                    level.addParticle(settings.getOptions(), (double)pos.getX() + level.random.nextDouble(), (double)pos.getY() + level.random.nextDouble(), (double)pos.getZ() + level.random.nextDouble(), 0.0, 0.0, 0.0);
                }
            });
        }
    }

    public boolean spawnAmbientParticle(ClientLevel level, ExtendedBulkSectionAccess sectionAccess, BlockPos pos, Biome biome) {
        return false;
    }
}

