/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.library.object.RenderContext;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.RegistryUtil;
import net.tslat.aoa3.util.RenderUtil;

public interface AoASkillRenderer {
    public static final ResourceLocation SKILL_ICON_BASE = AdventOfAscension.id("textures/gui/aoaskill/skill_icon_base.png");
    public static final AoASkillRenderer DEFAULT = new AoASkillRenderer(){

        @Override
        public void renderInHud(RenderContext renderContext, AoASkill.Instance skill, float partialTicks, ProgressRenderType progressRenderType, boolean renderLevel) {
            PoseStack poseStack = renderContext.getGuiGraphics().pose();
            poseStack.pushPose();
            poseStack.scale(0.5f, 0.5f, 0.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            Font fontRenderer = Minecraft.getInstance().font;
            int renderWidth = this.hudRenderWidth(skill) * 2;
            int renderHeight = this.hudRenderHeight(skill) * 2;
            int level = skill.getLevel(true);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SKILL_ICON_BASE);
            RenderUtil.renderScaledCustomSizedTexture(poseStack, 0.0f, 0.0f, 0.0f, 0.0f, renderWidth, renderHeight, renderWidth, renderHeight, renderWidth * 4, renderHeight * 2);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)RegistryUtil.getId(skill.type()).getNamespace(), (String)("textures/gui/aoaskill/" + RegistryUtil.getId(skill.type()).getPath() + ".png")));
            RenderUtil.renderScaledCustomSizedTexture(poseStack, 0.0f, 0.0f, 0.0f, 0.0f, renderWidth, renderHeight, renderWidth, renderHeight, renderWidth, renderHeight);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SKILL_ICON_BASE);
            if (level == 1000) {
                RenderUtil.renderScaledCustomSizedTexture(poseStack, 0.0f, 0.0f, renderWidth * 3, 0.0f, renderWidth, renderHeight, renderWidth, renderHeight, renderWidth * 4, renderHeight * 2);
            } else {
                float percentComplete = (float)PlayerUtil.getLevelProgressPercentage(skill.getLevel(true), skill.getXp()) / 100.0f;
                RenderUtil.renderScaledCustomSizedTexture(poseStack, 0.0f, 0.0f, renderWidth, 0.0f, renderWidth, renderHeight, renderWidth, renderHeight, renderWidth * 4, renderHeight * 2);
                switch (progressRenderType.ordinal()) {
                    case 0: {
                        RenderUtil.renderScaledCustomSizedTexture(poseStack, 0.0f, (float)renderHeight - percentComplete * (float)renderHeight, renderWidth * 2, (float)renderHeight - percentComplete * (float)renderHeight, renderWidth, renderHeight, renderWidth, renderHeight, renderWidth * 4, renderHeight * 2);
                        break;
                    }
                    case 2: {
                        String percentMessage = NumberUtil.roundToNthDecimalPlace(percentComplete * 100.0f, 0) + "%";
                        MutableComponent mutableComponent = Component.literal((String)percentMessage);
                        float f = (int)((float)renderWidth - (float)fontRenderer.width(percentMessage) * 1.5f);
                        float f2 = renderHeight;
                        Objects.requireNonNull(fontRenderer);
                        RenderUtil.renderScaledText(poseStack, (Component)mutableComponent, f, (int)(f2 - 9.0f * 1.5f), 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
                        break;
                    }
                    case 1: {
                        RenderUtil.renderScaledCustomSizedTexture(poseStack, 0.0f, renderHeight - 10, 0.0f, 50.0f, 100.0f, 20.0f, renderWidth, 10.0f, renderWidth * 4, renderHeight * 2);
                        RenderUtil.renderScaledCustomSizedTexture(poseStack, 0.0f, renderHeight - 10, 0.0f, 70.0f, percentComplete * 100.0f, 20.0f, percentComplete * (float)renderWidth, 10.0f, renderWidth * 4, renderHeight * 2);
                        break;
                    }
                }
            }
            if (renderLevel) {
                RenderUtil.renderScaledText(poseStack, (Component)Component.literal((String)String.valueOf(level)), (int)((float)renderWidth - (float)fontRenderer.width(String.valueOf(level)) * 1.5f), 1.0f, 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
                if (skill.getCycles() > 0) {
                    RenderUtil.renderScaledText(poseStack, (Component)Component.literal((String)String.valueOf(skill.getCycles())), 0.0f, 1.0f, 1.5f, ColourUtil.RGB(252, 170, 0), RenderUtil.TextRenderType.OUTLINED);
                }
            }
            poseStack.popPose();
        }

        @Override
        public void renderInGui(RenderContext renderContext, AoASkill.Instance skill, float partialTicks, int mouseX, int mouseY, ProgressRenderType progressRenderType, boolean renderLevel) {
            this.renderInHud(renderContext, skill, partialTicks, progressRenderType, renderLevel);
        }
    };

    public void renderInHud(RenderContext var1, AoASkill.Instance var2, float var3, ProgressRenderType var4, boolean var5);

    public void renderInGui(RenderContext var1, AoASkill.Instance var2, float var3, int var4, int var5, ProgressRenderType var6, boolean var7);

    default public int hudRenderWidth(AoASkill.Instance skill) {
        return 25;
    }

    default public int hudRenderHeight(AoASkill.Instance skill) {
        return 25;
    }

    default public int guiRenderWidth(AoASkill.Instance skill) {
        return 25;
    }

    default public int guiRenderHeight(AoASkill.Instance skill) {
        return 25;
    }

    public static enum ProgressRenderType {
        Ring,
        Bar,
        Percent,
        None;

    }
}

