/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.util.RenderUtil;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.Nullable;

public interface AoAResourceRenderer {
    public static final AoAResourceRenderer DEFAULT = new AoAResourceRenderer(){};

    default public void renderInHud(PoseStack matrix, AoAResource.Instance resource, float partialTicks, @Nullable String valueOverride) {
        ResourceLocation resourceId = AoARegistries.AOA_RESOURCES.getKey(resource.type());
        matrix.pushPose();
        matrix.scale(0.5f, 0.5f, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)resourceId.getNamespace(), (String)("textures/gui/aoaresource/" + resourceId.getPath() + ".png")));
        int renderWidth = this.hudRenderWidth(resource) * 2;
        int renderHeight = this.hudRenderHeight(resource) * 2;
        float currentValue = resource.getCurrentValue();
        String value = String.valueOf((int)currentValue);
        if (valueOverride != null) {
            if (valueOverride.equals("-1")) {
                currentValue = resource.getMaxValue();
                value = "";
            } else if (NumberUtils.isParsable((String)valueOverride)) {
                currentValue = Float.parseFloat(valueOverride);
                value = String.valueOf((int)currentValue);
            } else {
                currentValue = resource.getMaxValue();
                value = valueOverride;
            }
        }
        float percentOfMax = (float)Math.floor(Math.min(currentValue, resource.getMaxValue()) / resource.getMaxValue() * (float)renderWidth);
        RenderUtil.renderScaledCustomSizedTexture(matrix, 0.0f, 0.0f, 0.0f, 0.0f, renderWidth, renderHeight, renderWidth, renderHeight, renderWidth, renderHeight * 3);
        RenderUtil.renderScaledCustomSizedTexture(matrix, 0.0f, 0.0f, 0.0f, percentOfMax == (float)renderWidth ? (float)(renderHeight * 2) : (float)renderHeight, percentOfMax, renderHeight, percentOfMax, renderHeight, renderWidth, renderHeight * 3);
        RenderUtil.renderCenteredScaledText(matrix, (Component)Component.literal((String)value), 26.0f, 29.0f, 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
        matrix.popPose();
    }

    default public void renderInGui(PoseStack matrix, AoAResource.Instance resource, float partialTicks, int mouseX, int mouseY) {
    }

    default public int hudRenderWidth(AoAResource.Instance resource) {
        return 25;
    }

    default public int hudRenderHeight(AoAResource.Instance resource) {
        return 25;
    }

    default public int guiRenderWidth(AoAResource.Instance resource) {
        return 25;
    }

    default public int guiRenderHeight(AoAResource.Instance resource) {
        return 25;
    }

    public static enum HudResourcesPosition {
        Top_Right,
        Top_Left;

    }
}

