/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.content.block.blockentity.ImbuingChamberBlockEntity;
import net.tslat.aoa3.content.item.misc.AspectFocusItem;
import net.tslat.aoa3.content.item.misc.PowerStone;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;

public class ImbuingChamberRenderer
implements BlockEntityRenderer<ImbuingChamberBlockEntity> {
    public ImbuingChamberRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(ImbuingChamberBlockEntity imbuingChamber, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        NonNullList<ItemStack> contents = imbuingChamber.getItems();
        Direction direction = ((Direction)imbuingChamber.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).getCounterClockWise();
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5625f, 0.5f);
        poseStack.mulPose(Axis.YN.rotationDegrees(direction.toYRot()));
        ImbuingChamberRenderer.renderContents(poseStack, contents, partialTick, packedLight, packedOverlay, buffer);
        int colour = ImbuingChamberRenderer.renderBeam(poseStack, contents, partialTick, packedLight, packedOverlay, buffer);
        if (colour != 0) {
            Vec3 pos = new Vec3((double)((float)imbuingChamber.getBlockPos().getX() + 0.5f), (double)((float)imbuingChamber.getBlockPos().getY() + 0.7f), (double)((float)imbuingChamber.getBlockPos().getZ() + 0.5f)).add((double)((float)direction.getStepX() * 0.375f), 0.0, (double)((float)direction.getStepZ() * 0.375f));
            if (!Minecraft.getInstance().isPaused()) {
                ParticleBuilder.forPositions((ParticleOptions)ParticleTypes.WARPED_SPORE, (Vec3[])new Vec3[]{pos}).colourOverride(ColourUtil.getRed(colour), ColourUtil.getGreen(colour), ColourUtil.getBlue(colour), 255).cutoffDistance(16.0).scaleMod(0.25f).isAmbient().lifespan(3).spawnParticles((Level)Minecraft.getInstance().level);
            }
        }
        poseStack.popPose();
    }

    private static int renderBeam(PoseStack poseStack, List<ItemStack> contents, float partialTick, int packedLight, int packedOverlay, MultiBufferSource buffer) {
        Item item = contents.get(0).getItem();
        if (item instanceof PowerStone) {
            PowerStone powerStone = (PowerStone)item;
            int colour = powerStone.getColour();
            int currentIndex = 1;
            int lastIndex = 0;
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            poseStack.translate(-0.5f, -0.375f, -0.5f);
            do {
                ItemStack slotStack;
                if ((slotStack = contents.get(currentIndex)).isEmpty() && currentIndex != 6) continue;
                int delta = currentIndex - lastIndex;
                poseStack.pushPose();
                poseStack.translate(0.0f, (float)lastIndex * 0.137f, 0.0f);
                poseStack.scale(1.0f, 0.137f * (float)delta, 1.0f);
                BeaconRenderer.renderBeaconBeam((PoseStack)poseStack, (MultiBufferSource)buffer, (ResourceLocation)BeaconRenderer.BEAM_LOCATION, (float)partialTick, (float)0.125f, (long)(Minecraft.getInstance().level.getGameTime() * 12L), (int)0, (int)1, (int)colour, (float)0.1f, (float)0.12f);
                poseStack.popPose();
                Item item2 = slotStack.getItem();
                if (item2 instanceof AspectFocusItem) {
                    AspectFocusItem focus = (AspectFocusItem)item2;
                    colour = ColourUtil.lerpColour(colour, focus.getFocus().colour(), 0.75f);
                }
                lastIndex = currentIndex;
            } while (++currentIndex < contents.size());
            return colour;
        }
        return 0;
    }

    private static void renderContents(PoseStack poseStack, List<ItemStack> contents, float partialTick, int packedLight, int packedOverlay, MultiBufferSource buffer) {
        ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
        for (int i = 0; i < contents.size(); ++i) {
            ItemStack focus = contents.get(i);
            if (focus == ItemStack.EMPTY) continue;
            poseStack.pushPose();
            poseStack.translate(0.0, 0.0, -0.34375 + 0.125 * (double)i);
            if (i == 0 || i == 6) {
                poseStack.scale(0.5f, 0.5f, 0.5f);
                if (i == 0) {
                    poseStack.translate(0.0f, 0.0f, 0.0313f);
                } else {
                    poseStack.translate(0.0f, 0.0f, -0.03125f);
                }
            }
            renderer.renderStatic(focus, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, (Level)Minecraft.getInstance().level, 0);
            poseStack.popPose();
        }
    }
}

