/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.AoAKeybinds;
import net.tslat.aoa3.client.player.ClientPlayerDataManager;
import net.tslat.aoa3.client.render.custom.AoAResourceRenderer;
import net.tslat.aoa3.client.render.custom.AoASkillRenderer;
import net.tslat.aoa3.client.render.custom.EnergyResourceRenderer;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.library.object.RenderContext;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RenderUtil;

public final class AoAGuiElementRenderers {
    private static final HashMap<AoASkill, AoASkillRenderer> SKILL_RENDERERS = new HashMap();
    private static final HashMap<AoAResource, AoAResourceRenderer> RESOURCE_RENDERERS = new HashMap();
    public static int resourcesRenderHeightOffset = 0;

    public static void init() {
        AdventOfAscension.getModEventBus().addListener(EventPriority.NORMAL, false, RegisterGuiLayersEvent.class, ev -> {
            ev.registerAbove(VanillaGuiLayers.EFFECTS, AdventOfAscension.id("aoa_resources"), AoAGuiElementRenderers::renderResources);
            ev.registerAbove(VanillaGuiLayers.EFFECTS, AdventOfAscension.id("aoa_skills"), AoAGuiElementRenderers::renderSkills);
        });
    }

    public static void lateInit() {
        AoAGuiElementRenderers.registerResourceRenderer((AoAResource)AoAResources.ENERGY.get(), new EnergyResourceRenderer());
    }

    public static AoAResourceRenderer getResourceRenderer(AoAResource resource) {
        return RESOURCE_RENDERERS.getOrDefault(resource, AoAResourceRenderer.DEFAULT);
    }

    public static AoASkillRenderer getSkillRenderer(AoASkill skill) {
        return SKILL_RENDERERS.getOrDefault(skill, AoASkillRenderer.DEFAULT);
    }

    public static void registerResourceRenderer(AoAResource resource, AoAResourceRenderer renderer) {
        RESOURCE_RENDERERS.put(resource, renderer);
    }

    public static void registerSkillRenderer(AoASkill skill, AoASkillRenderer renderer) {
        SKILL_RENDERERS.put(skill, renderer);
    }

    private static void renderResources(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.player.isSpectator() || mc.options.hideGui) {
            return;
        }
        float partialTick = deltaTracker.getGameTimeDeltaPartialTick(false);
        Window window = mc.getWindow();
        int horizontalAdjuster = (Boolean)AoAConfigs.CLIENT.hudResourcesHorizontal.get() != false ? 1 : 0;
        int verticalAdjuster = horizontalAdjuster == 1 ? 0 : 1;
        int potionRenderOffset = 0;
        int x = 0;
        int y = 0;
        PoseStack poseStack = guiGraphics.pose();
        if (AoAConfigs.CLIENT.hudResourcesPosition.get() == AoAResourceRenderer.HudResourcesPosition.Top_Right) {
            x = window.getGuiScaledWidth();
            y = potionRenderOffset = RenderUtil.getPotionGuiRenderOffset();
            if ((horizontalAdjuster *= -1) == 0) {
                x -= 25;
            }
        }
        poseStack.pushPose();
        poseStack.translate((float)x, (float)y, 0.0f);
        x = 0;
        y = 0;
        if (AoAKeybinds.statusResourceGui) {
            int lastHeight = 0;
            for (AoAResource.Instance resource : ClientPlayerDataManager.get().getResources()) {
                AoAResourceRenderer renderer = AoAGuiElementRenderers.getResourceRenderer(resource.type());
                lastHeight = (y += renderer.hudRenderHeight(resource) * verticalAdjuster) + renderer.hudRenderHeight(resource);
                poseStack.pushPose();
                poseStack.translate((float)(x += renderer.hudRenderWidth(resource) * horizontalAdjuster), (float)y, 0.0f);
                renderer.renderInHud(poseStack, resource, partialTick, null);
                poseStack.popPose();
            }
            y = lastHeight;
        } else if (AoAKeybinds.statusResourceGuiMessage & AoAKeybinds.RESOURCE_GUI.getKey().getValue() != -1) {
            poseStack.scale(0.5f, 0.5f, 0.0f);
            MutableComponent locale = LocaleUtil.getLocaleMessage("gui.aoa3.resources.showtip", AoAKeybinds.RESOURCE_GUI.getTranslatedKeyMessage());
            RenderUtil.renderCenteredScaledText(poseStack, (Component)locale, -((int)((float)mc.font.width((FormattedText)locale) * 0.75f)), (int)((float)(y + 4) / 2.0f), 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
            Objects.requireNonNull(mc.font);
            y = y + 4 + 9 / 2;
        }
        poseStack.popPose();
        resourcesRenderHeightOffset = (AoAConfigs.CLIENT.hudResourcesPosition.get() == AoAResourceRenderer.HudResourcesPosition.Top_Right ? y : 0) + potionRenderOffset;
    }

    private static void renderSkills(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.player.isSpectator() || mc.options.hideGui) {
            return;
        }
        float partialTick = deltaTracker.getGameTimeDeltaPartialTick(false);
        Window window = mc.getWindow();
        int x = 0;
        int y = 0;
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)window.getGuiScaledWidth(), (float)resourcesRenderHeightOffset, 0.0f);
        RenderSystem.disableDepthTest();
        if (AoAKeybinds.statusSkillGui) {
            int maxHeight = 0;
            int cumulativeXOffset = 0;
            for (AoASkill.Instance skill : ClientPlayerDataManager.get().getSkills()) {
                AoASkillRenderer renderer = AoAGuiElementRenderers.getSkillRenderer(skill.type());
                int xOffset = renderer.hudRenderWidth(skill);
                x -= xOffset;
                maxHeight = Math.max(maxHeight, renderer.hudRenderHeight(skill));
                if ((cumulativeXOffset += xOffset) >= xOffset * 6) {
                    y += maxHeight;
                    x += cumulativeXOffset - xOffset;
                    maxHeight = 0;
                    cumulativeXOffset = 0;
                }
                poseStack.pushPose();
                poseStack.translate((float)x, (float)y, 0.0f);
                renderer.renderInHud(RenderContext.of(guiGraphics), skill, partialTick, (AoASkillRenderer.ProgressRenderType)((Object)AoAConfigs.CLIENT.hudSkillProgressRenderType.get()), true);
                poseStack.popPose();
            }
        } else if (AoAKeybinds.statusSkillGuiMessage & AoAKeybinds.SKILL_GUI.getKey().getValue() != -1) {
            poseStack.scale(0.5f, 0.5f, 1.0f);
            MutableComponent locale = LocaleUtil.getLocaleMessage("gui.aoa3.skills.showtip", AoAKeybinds.SKILL_GUI.getTranslatedKeyMessage());
            RenderUtil.renderCenteredScaledText(poseStack, (Component)locale, -((int)((float)mc.font.width((FormattedText)locale) * 0.75f)), (int)((float)y / 2.0f) + 1, 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
        }
        RenderSystem.enableDepthTest();
        poseStack.popPose();
    }
}

