/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.player;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.tslat.aoa3.advent.AoAResourceCaching;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.client.gui.adventgui.AdventGuiTabLore;
import net.tslat.aoa3.client.player.AoAPlayerKeybindListener;
import net.tslat.aoa3.common.networking.AoANetworking;
import net.tslat.aoa3.common.networking.packets.adventplayer.PlayerAbilityKeybindTriggerPacket;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.PlayerDataManager;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

public final class ClientPlayerDataManager
implements PlayerDataManager {
    public static final ClientPlayerDataManager INSTANCE = (ClientPlayerDataManager)Util.make((Object)new ClientPlayerDataManager(), manager -> AoAResourceCaching.onClientLogout(manager::reset));
    private Player player;
    private final ConcurrentSkipListMap<AoASkill, AoASkill.Instance> skills = new ConcurrentSkipListMap(Comparator.comparing(AoARegistries.AOA_SKILLS::getKey));
    private final ConcurrentSkipListMap<AoAResource, AoAResource.Instance> resources = new ConcurrentSkipListMap(Comparator.comparing(AoARegistries.AOA_RESOURCES::getKey));
    private final ObjectArrayList<AoAPlayerEventListener> eventListeners = new ObjectArrayList();
    private final ConcurrentHashMap<Integer, List<AoAPlayerKeybindListener>> keyListeners = new ConcurrentHashMap(1);
    private boolean isLegitimate = true;
    private int totalLevel = 0;

    public static ClientPlayerDataManager get() {
        return INSTANCE;
    }

    public void updatePlayerInstance(Player pl) {
        this.player = pl;
    }

    public void reset() {
        this.player = null;
        this.isLegitimate = true;
        this.totalLevel = 0;
        this.skills.clear();
        this.resources.clear();
        this.keyListeners.clear();
        for (AoAPlayerEventListener listener : this.eventListeners) {
            listener.disable(AoAPlayerEventListener.ListenerState.REMOVED, false);
        }
        this.eventListeners.clear();
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public boolean isLegitimate() {
        return this.isLegitimate;
    }

    @Override
    public int getTotalLevel() {
        return this.totalLevel;
    }

    @Override
    public Collection<AoASkill.Instance> getSkills() {
        return this.skills.values();
    }

    @Override
    @NotNull
    public AoASkill.Instance getSkill(AoASkill skill) {
        return this.skills.getOrDefault(skill, AoASkills.DEFAULT);
    }

    @Override
    public AoAAbility.Instance getAbility(String abilityId) {
        for (AoASkill.Instance skill : this.getSkills()) {
            if (!skill.getAbilityMap().containsKey(abilityId)) continue;
            return skill.getAbilityMap().get(abilityId);
        }
        return null;
    }

    @Override
    public Collection<AoAResource.Instance> getResources() {
        return this.resources.values();
    }

    @Override
    @NotNull
    public AoAResource.Instance getResource(AoAResource resource) {
        return this.resources.getOrDefault(resource, AoAResources.DEFAULT);
    }

    public void handleKeyInput(int keycode) {
        if (ClientOperations.getPlayer() == null || this.keyListeners.isEmpty() || !this.keyListeners.containsKey(keycode)) {
            return;
        }
        List<AoAPlayerKeybindListener> listeners = this.keyListeners.get(keycode);
        ObjectArrayList abilities = new ObjectArrayList(listeners.size());
        for (AoAPlayerKeybindListener listener : listeners) {
            AoAPlayerEventListener aoAPlayerEventListener;
            if (!listener.isListenerActive() || !listener.shouldSendKeyPress() || !((aoAPlayerEventListener = listener.getEventListener()) instanceof AoAAbility.Instance)) continue;
            AoAAbility.Instance abilityInstance = (AoAAbility.Instance)aoAPlayerEventListener;
            abilities.add(abilityInstance.getUniqueIdentifier());
        }
        if (!abilities.isEmpty()) {
            AoANetworking.sendToServer(new PlayerAbilityKeybindTriggerPacket((List<String>)abilities));
        }
    }

    private void updateTotalLevel() {
        this.totalLevel = 0;
        for (AoASkill.Instance skill : this.skills.values()) {
            this.totalLevel += 100 * skill.getCycles();
            this.totalLevel += skill.getLevel(true);
        }
    }

    public void loadFromNbt(CompoundTag baseTag) {
        AoAPlayerEventListener instance;
        this.isLegitimate = baseTag.getBoolean("legitimate");
        int hash = baseTag.getInt("hash");
        if (hash == 0) {
            this.isLegitimate = false;
        }
        this.skills.clear();
        this.resources.clear();
        if (baseTag.contains("skills")) {
            CompoundTag skillsNbt = baseTag.getCompound("skills");
            for (String id : skillsNbt.getAllKeys()) {
                AoASkill skill = AoASkills.getSkill((ResourceLocation)ResourceLocation.read((String)id).getOrThrow());
                instance = skill.buildClientInstance(skillsNbt.getCompound(id));
                this.skills.put(skill, (AoASkill.Instance)instance);
                this.addEventListener(instance);
                for (AoAAbility.Instance ability : ((AoASkill.Instance)instance).getAbilityMap().values()) {
                    this.addEventListener(ability);
                }
            }
            this.updateTotalLevel();
        }
        if (baseTag.contains("resources")) {
            CompoundTag resourcesNbt = baseTag.getCompound("resources");
            for (String id : resourcesNbt.getAllKeys()) {
                AoAResource resource = AoAResources.getResource((ResourceLocation)ResourceLocation.read((String)id).getOrThrow());
                instance = resource.buildClientInstance(resourcesNbt.getCompound(id));
                this.resources.put(resource, (AoAResource.Instance)instance);
                this.addEventListener(instance);
            }
        }
        if (baseTag.contains("PatchouliBooks")) {
            ArrayList<ResourceLocation> books = new ArrayList<ResourceLocation>();
            ListTag booksNbt = baseTag.getList("PatchouliBooks", 8);
            for (Tag book : booksNbt) {
                books.add((ResourceLocation)ResourceLocation.read((String)book.getAsString()).getOrThrow());
            }
            AdventGuiTabLore.syncBooks(books);
        }
    }

    public void updateData(CompoundTag syncTag) {
        if (syncTag.contains("skills")) {
            CompoundTag skillsData = syncTag.getCompound("skills");
            for (String key : skillsData.getAllKeys()) {
                this.getSkill(AoASkills.getSkill((ResourceLocation)ResourceLocation.read((String)key).getOrThrow())).receiveSyncData(skillsData.getCompound(key));
            }
            this.updateTotalLevel();
        }
        if (syncTag.contains("resources")) {
            CompoundTag resourcesData = syncTag.getCompound("resources");
            for (String key : resourcesData.getAllKeys()) {
                this.getResource(AoAResources.getResource((ResourceLocation)ResourceLocation.read((String)key).getOrThrow())).receiveSyncData(resourcesData.getCompound(key));
            }
        }
        if (syncTag.contains("PatchouliBooks")) {
            ArrayList<ResourceLocation> books = new ArrayList<ResourceLocation>();
            ListTag booksNbt = syncTag.getList("PatchouliBooks", 8);
            for (Tag book : booksNbt) {
                books.add((ResourceLocation)ResourceLocation.read((String)book.getAsString()).getOrThrow());
            }
            AdventGuiTabLore.syncBooks(books);
        }
        if (syncTag.contains("legitimate")) {
            this.isLegitimate = syncTag.getBoolean("legitimate");
        }
    }

    @Override
    public void addEventListener(AoAPlayerEventListener listener) {
        if (this.player != ClientOperations.getPlayer()) {
            return;
        }
        listener.createKeybindListener(keyListener -> this.keyListeners.computeIfAbsent(keyListener.getKeycode(), keyCode -> new ObjectArrayList(1)).add(keyListener));
        this.eventListeners.add((Object)listener);
        if (!ClientOperations.isLocalServer()) {
            listener.registerEventSubscribers();
        }
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider registryLookup) {
        return new CompoundTag();
    }

    public void deserializeNBT(HolderLookup.Provider registryLookup, CompoundTag nbt) {
    }
}

