/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.particle.entityaffecting;

import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.particleoption.EntityTrackingParticleOptions;
import net.tslat.aoa3.library.builder.EntityPredicate;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import org.jetbrains.annotations.Nullable;

public abstract class EntityAffectingParticle
extends TextureSheetParticle {
    protected EntityAffectingParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void move(double x, double y, double z) {
        if (!this.stoppedByCollision) {
            double xVelBefore = x;
            double yVelBefore = y;
            double zVelBefore = z;
            Entity collidedEntity = this.getCollidedEntity(x, y, z);
            if (collidedEntity != null && this.handleEntityCollision(collidedEntity)) {
                return;
            }
            if (this.hasPhysics && (x != 0.0 || y != 0.0 || z != 0.0) && x * x + y * y + z * z < MAXIMUM_COLLISION_VELOCITY_SQUARED) {
                Vec3 collidedVelocity = Entity.collideBoundingBox(null, (Vec3)new Vec3(x, y, z), (AABB)this.getBoundingBox(), (Level)this.level, List.of());
                x = collidedVelocity.x;
                y = collidedVelocity.y;
                z = collidedVelocity.z;
            }
            if (x != 0.0 || y != 0.0 || z != 0.0) {
                this.setBoundingBox(this.getBoundingBox().move(x, y, z));
                this.setLocationFromBoundingbox();
            }
            if (Math.abs(yVelBefore) >= 1.0E-5 && Math.abs(y) < 1.0E-5) {
                this.stoppedByCollision = true;
            }
            boolean bl = this.onGround = yVelBefore != y && yVelBefore < 0.0;
            if (xVelBefore != x) {
                this.xd = 0.0;
            }
            if (zVelBefore != z) {
                this.zd = 0.0;
            }
        }
    }

    protected boolean handleEntityCollision(Entity collidedEntity) {
        this.age = this.lifetime;
        return true;
    }

    @Nullable
    protected Entity getCollidedEntity(double xVelocity, double yVelocity, double zVelocity) {
        return EntityRetrievalUtil.getNearestEntity((Level)this.level, (AABB)this.getBoundingBox().expandTowards(xVelocity, yVelocity, zVelocity), (Vec3)new Vec3(this.x, this.y, this.z), EntityPredicate.TARGETABLE_ENTITIES);
    }

    public static class SingleSpriteProvider<T extends EntityAffectingParticle>
    implements ParticleProvider.Sprite<EntityTrackingParticleOptions> {
        private final Factory<T> factory;

        public SingleSpriteProvider(Factory<T> factory) {
            this.factory = factory;
        }

        public TextureSheetParticle createParticle(EntityTrackingParticleOptions data, ClientLevel level, double x, double y, double z, double xVelocity, double yVelocity, double zVelocity) {
            return this.factory.create(level, x, y, z, xVelocity, yVelocity, zVelocity, null, data.entitySourceId());
        }
    }

    public static class Provider<T extends EntityAffectingParticle>
    implements ParticleProvider<EntityTrackingParticleOptions> {
        private final SpriteSet sprites;
        private final Factory<T> factory;

        public Provider(SpriteSet sprites, Factory<T> factory) {
            this.sprites = sprites;
            this.factory = factory;
        }

        @Nullable
        public Particle createParticle(EntityTrackingParticleOptions data, ClientLevel level, double x, double y, double z, double xVelocity, double yVelocity, double zVelocity) {
            return this.factory.create(level, x, y, z, xVelocity, yVelocity, zVelocity, this.sprites, data.entitySourceId());
        }
    }

    @FunctionalInterface
    public static interface Factory<T extends EntityAffectingParticle> {
        public T create(ClientLevel var1, double var2, double var4, double var6, double var8, double var10, double var12, @Nullable SpriteSet var14, int var15);
    }
}

