/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class OrbParticle
extends TextureSheetParticle {
    public static final ParticleRenderType GLOWING_TRANSLUCENT_TEXTURE = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_PARTICLES);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR);
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }

        public String toString() {
            return "GLOWING_TRANSLUCENT_TEXTURE";
        }
    };
    private float scale = 1.0f;
    private int inGroundTime = 0;

    public OrbParticle(ClientLevel level, double x, double y, double z, double xVelocity, double yVelocity, double zVelocity) {
        super(level, x, y, z, xVelocity, yVelocity, zVelocity);
        this.xd = xVelocity;
        this.yd = yVelocity;
        this.zd = zVelocity;
        this.lifetime = Mth.ceil((double)(1.0 + Mth.clamp((double)this.random.nextGaussian(), (double)-0.5, (double)0.5)));
        this.gravity = 0.1f;
        this.friction = 0.9f;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= (double)this.friction;
        this.yd *= (double)this.friction;
        this.zd *= (double)this.friction;
        this.yd -= (double)this.gravity;
        if (this.onGround) {
            this.xd *= (double)0.7f;
            this.zd *= (double)0.7f;
            ++this.inGroundTime;
            if (this.yd <= (double)this.gravity && this.yd < (double)-0.23f) {
                this.yd *= (double)Math.max(-0.95f, -0.4f + this.scale / 10.0f);
            }
        } else {
            this.inGroundTime = 0;
        }
        if ((float)this.inGroundTime > this.scale * 10.0f) {
            this.scale(0.7f);
        }
        if (this.age++ >= this.lifetime || (float)this.inGroundTime > this.scale * 100.0f) {
            this.remove();
        }
    }

    public void render(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        this.roll = 0.25f;
        super.render(pBuffer, pRenderInfo, pPartialTicks);
    }

    public ParticleRenderType getRenderType() {
        return GLOWING_TRANSLUCENT_TEXTURE;
    }

    public Particle scale(float scale) {
        this.scale = scale;
        this.quadSize = 0.25f * scale;
        this.setSize(0.2f * scale, 0.2f * scale);
        return this;
    }

    protected int getLightColor(float partialTick) {
        return 0xF000F0 - (int)(partialTick * 34.0f);
    }

    public static class Provider
    implements ParticleProvider.Sprite<SimpleParticleType> {
        public TextureSheetParticle createParticle(SimpleParticleType data, ClientLevel level, double x, double y, double z, double xVelocity, double yVelocity, double zVelocity) {
            return new OrbParticle(level, x, y, z, xVelocity, yVelocity, zVelocity);
        }
    }
}

