/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.model.entity.mob;

import it.unimi.dsi.fastutil.floats.FloatFloatPair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.tslat.aoa3.advent.Logging;
import org.apache.logging.log4j.Level;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationProcessor;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class MultiStageHeadModel<T extends GeoAnimatable>
extends DefaultedEntityGeoModel<T> {
    protected Stage[] stages = new Stage[0];

    public MultiStageHeadModel(ResourceLocation assetSubpath) {
        super(assetSubpath, true);
    }

    public MultiStageHeadModel<T> withStages(Stage ... stages) {
        this.stages = stages;
        return this;
    }

    public void setCustomAnimations(T animatable, long instanceId, AnimationState<T> animationState) {
        AnimationProcessor processor = this.getAnimationProcessor();
        EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        float yaw = entityData.netHeadYaw();
        for (Stage stage : this.stages) {
            GeoBone bone = processor.getBone(stage.boneName);
            if (bone == null) {
                Logging.logMessage(Level.ERROR, "Invalid bone name " + stage.boneName + " for multi-stage head model");
                return;
            }
            float boneYaw = Mth.clamp((float)yaw, (float)stage.yawBounds.leftFloat(), (float)stage.yawBounds.rightFloat());
            yaw -= boneYaw * Math.signum(boneYaw);
            bone.setRotY(boneYaw * ((float)Math.PI / 180));
        }
    }

    public record Stage(String boneName, FloatFloatPair pitchBounds, FloatFloatPair yawBounds) {
    }
}

