/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.model;

import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.tslat.aoa3.common.registration.item.AoADataComponents;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.item.AoATools;
import net.tslat.aoa3.common.registration.item.AoAWeapons;
import net.tslat.aoa3.content.item.weapon.bow.BaseBow;
import net.tslat.aoa3.content.item.weapon.crossbow.BaseCrossbow;

public final class ModelProperties {
    public static void init() {
        ModelProperties.registerBows((BaseBow)AoAWeapons.ALACRITY_BOW.get(), (BaseBow)AoAWeapons.ANCIENT_BOW.get(), (BaseBow)AoAWeapons.ATLANTIC_BOW.get(), (BaseBow)AoAWeapons.BARON_BOW.get(), (BaseBow)AoAWeapons.BOREIC_BOW.get(), (BaseBow)AoAWeapons.DAYBREAKER_BOW.get(), (BaseBow)AoAWeapons.DEEP_BOW.get(), (BaseBow)AoAWeapons.EXPLOSIVE_BOW.get(), (BaseBow)AoAWeapons.HAUNTED_BOW.get(), (BaseBow)AoAWeapons.ICE_BOW.get(), (BaseBow)AoAWeapons.INFERNAL_BOW.get(), (BaseBow)AoAWeapons.JUSTICE_BOW.get(), (BaseBow)AoAWeapons.LUNAR_BOW.get(), (BaseBow)AoAWeapons.MECHA_BOW.get(), (BaseBow)AoAWeapons.NIGHTMARE_BOW.get(), (BaseBow)AoAWeapons.POISON_BOW.get(), (BaseBow)AoAWeapons.PREDATIOUS_BOW.get(), (BaseBow)AoAWeapons.PRIMORDIAL_BOW.get(), (BaseBow)AoAWeapons.ROSIDIAN_BOW.get(), (BaseBow)AoAWeapons.RUNIC_BOW.get(), (BaseBow)AoAWeapons.SCREAMER_BOW.get(), (BaseBow)AoAWeapons.SHYREGEM_BOW.get(), (BaseBow)AoAWeapons.SKELETAL_BOW.get(), (BaseBow)AoAWeapons.SKYDRIVER_BOW.get(), (BaseBow)AoAWeapons.SLINGSHOT.get(), (BaseBow)AoAWeapons.SOULFIRE_BOW.get(), (BaseBow)AoAWeapons.SPECTRAL_BOW.get(), (BaseBow)AoAWeapons.SPEED_BOW.get(), (BaseBow)AoAWeapons.SUNSHINE_BOW.get(), (BaseBow)AoAWeapons.TOXIN_BOW.get(), (BaseBow)AoAWeapons.VOID_BOW.get(), (BaseBow)AoAWeapons.WEAKEN_BOW.get(), (BaseBow)AoAWeapons.WITHER_BOW.get());
        ModelProperties.registerCrossbows((BaseCrossbow)AoAWeapons.CORAL_CROSSBOW.get(), (BaseCrossbow)AoAWeapons.LUNAR_CROSSBOW.get(), (BaseCrossbow)AoAWeapons.MECHA_CROSSBOW.get(), (BaseCrossbow)AoAWeapons.PYRO_CROSSBOW.get(), (BaseCrossbow)AoAWeapons.ROSIDIAN_CROSSBOW.get(), (BaseCrossbow)AoAWeapons.SKELETAL_CROSSBOW.get(), (BaseCrossbow)AoAWeapons.SPECTRAL_CROSSBOW.get(), (BaseCrossbow)AoAWeapons.TROLLS_CROSSBOW.get(), (BaseCrossbow)AoAWeapons.VIRAL_CROSSBOW.get());
        ModelProperties.registerExpFlask();
        ModelProperties.registerParalyzer();
        ModelProperties.registerKnightsGuard();
        ModelProperties.registerGuardiansSword();
        ModelProperties.registerRods();
        ModelProperties.registerHorns();
    }

    private static void registerBows(BaseBow ... bows) {
        for (BaseBow bow : bows) {
            ModelProperties.registerItemProperty((Item)bow, "pull", (stack, world, entity, seed) -> {
                if (entity == null || entity.getUseItem() != stack) {
                    return 0.0f;
                }
                return ((BaseBow)stack.getItem()).getDrawSpeedMultiplier(stack) * (float)(stack.getUseDuration(entity) - entity.getUseItemRemainingTicks()) / 20.0f;
            });
            ModelProperties.registerItemProperty((Item)bow, "pulling", (stack, world, entity, seed) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
        }
    }

    private static void registerCrossbows(BaseCrossbow ... crossbows) {
        for (BaseCrossbow crossbow : crossbows) {
            ModelProperties.registerItemProperty((Item)crossbow, "pull", (stack, world, entity, seed) -> {
                if (entity == null || CrossbowItem.isCharged((ItemStack)stack)) {
                    return 0.0f;
                }
                return (float)(stack.getUseDuration(entity) - entity.getUseItemRemainingTicks()) / (float)CrossbowItem.getChargeDuration((ItemStack)stack, (LivingEntity)entity);
            });
            ModelProperties.registerItemProperty((Item)crossbow, "pulling", (stack, world, entity, seed) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack && !CrossbowItem.isCharged((ItemStack)stack) ? 1.0f : 0.0f);
            ModelProperties.registerItemProperty((Item)crossbow, "charged", (stack, world, entity, seed) -> entity != null && CrossbowItem.isCharged((ItemStack)stack) ? 1.0f : 0.0f);
            ModelProperties.registerItemProperty((Item)crossbow, "firework", (stack, world, entity, seed) -> {
                ChargedProjectiles loadedProjectiles = (ChargedProjectiles)stack.get(DataComponents.CHARGED_PROJECTILES);
                return loadedProjectiles != null && loadedProjectiles.contains(Items.FIREWORK_ROCKET) ? 1.0f : 0.0f;
            });
        }
    }

    private static void registerItemProperty(Item item, String propertyName, ItemPropertyFunction propertyProvider) {
        ItemProperties.register((Item)item, (ResourceLocation)((ResourceLocation)ResourceLocation.read((String)propertyName).getOrThrow()), (ItemPropertyFunction)propertyProvider);
    }

    private static void registerExpFlask() {
        ModelProperties.registerItemProperty((Item)AoATools.EXP_FLASK.get(), "filled", (stack, world, entity, seed) -> ((Float)stack.getOrDefault(AoADataComponents.CHARGE, (Object)Float.valueOf(0.0f))).floatValue() <= 0.0f ? 0.0f : 1.0f);
    }

    private static void registerParalyzer() {
        ModelProperties.registerItemProperty((Item)AoAWeapons.PARALYZER.get(), "firing", (stack, world, entity, seed) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
        ModelProperties.registerItemProperty((Item)AoAWeapons.PARALYZER.get(), "firing_tick_modulo", (stack, world, entity, seed) -> {
            if (entity == null || stack != entity.getUseItem()) {
                return 0.0f;
            }
            return entity.getUseItemRemainingTicks() % 3;
        });
    }

    private static void registerKnightsGuard() {
        ModelProperties.registerItemProperty((Item)AoAWeapons.KNIGHTS_GUARD.get(), "blocking", (stack, world, entity, seed) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
    }

    private static void registerGuardiansSword() {
        ModelProperties.registerItemProperty((Item)AoAWeapons.GUARDIANS_SWORD.get(), "charged", (stack, world, entity, seed) -> ((Float)stack.getOrDefault(AoADataComponents.CHARGE, (Object)Float.valueOf(0.0f))).floatValue() <= 0.0f ? 0.0f : 1.0f);
    }

    private static void registerRods() {
        ItemPropertyFunction predicateHandler = (stack, world, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            return (entity.getMainHandItem() == stack || entity.getOffhandItem() == stack && !(entity.getMainHandItem().getItem() instanceof FishingRodItem)) && entity instanceof Player && ((Player)entity).fishing != null ? 1.0f : 0.0f;
        };
        ModelProperties.registerItemProperty((Item)AoATools.HAULING_ROD.get(), "cast", predicateHandler);
        ModelProperties.registerItemProperty((Item)AoATools.GOLDEN_ROD.get(), "cast", predicateHandler);
        ModelProperties.registerItemProperty((Item)AoATools.LIGHT_ROD.get(), "cast", predicateHandler);
        ModelProperties.registerItemProperty((Item)AoATools.THERMALLY_INSULATED_ROD.get(), "cast", predicateHandler);
    }

    private static void registerHorns() {
        ItemPropertyFunction predicateHandler = (stack, world, entity, seed) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f;
        ModelProperties.registerItemProperty((Item)AoAItems.BONE_HORN.get(), "tooting", predicateHandler);
        ModelProperties.registerItemProperty((Item)AoAItems.WARPED_HORN.get(), "tooting", predicateHandler);
    }
}

