/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.common.registration.entity.AoAMobEffects;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RenderUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class HealthStatusRenderer {
    private static final ResourceLocation HEALTH_BAR = AdventOfAscension.id("textures/gui/overlay/misc/health_bar.png");
    private static float deltaHealth = 0.0f;
    private static int lastHealthTime = 0;
    private static float lastTickHealth = 0.0f;

    public static void init() {
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, false, RenderGuiLayerEvent.Pre.class, HealthStatusRenderer::onHealthRender);
    }

    private static void onHealthRender(RenderGuiLayerEvent.Pre ev) {
        if (ev.isCanceled() || !ev.getName().equals((Object)VanillaGuiLayers.PLAYER_HEALTH)) {
            return;
        }
        HealthRenderType renderType = (HealthRenderType)((Object)AoAConfigs.CLIENT.healthRenderType.get());
        if (renderType == HealthRenderType.HEARTS) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui || !mc.gameMode.canHurtPlayer()) {
            return;
        }
        LocalPlayer player = mc.player;
        PoseStack matrix = ev.getGuiGraphics().pose();
        int left = mc.getWindow().getGuiScaledWidth() / 2 - 91;
        int top = mc.getWindow().getGuiScaledHeight() - mc.gui.leftHeight;
        mc.gui.leftHeight += 10;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        ev.setCanceled(true);
        mc.getProfiler().push("health");
        RenderSystem.enableBlend();
        float currentHealth = player.getHealth();
        float maxHealth = player.getMaxHealth();
        boolean poisoned = mc.player.hasEffect(MobEffects.POISON);
        boolean withered = mc.player.hasEffect(MobEffects.WITHER);
        boolean frozen = mc.player.isFullyFrozen();
        float absorption = mc.player.getAbsorptionAmount();
        boolean bleeding = mc.player.hasEffect(AoAMobEffects.BLEEDING);
        if (renderType == HealthRenderType.NUMERIC) {
            HealthStatusRenderer.renderNumeric(matrix, mc, left, top, currentHealth, maxHealth, poisoned, withered, frozen, absorption);
        } else {
            HealthStatusRenderer.renderBar(matrix, mc, left, top, currentHealth, maxHealth, poisoned, withered, frozen, absorption, bleeding);
            if (renderType == HealthRenderType.BAR_NUMERIC) {
                HealthStatusRenderer.renderNumeric(matrix, mc, left, top, currentHealth, maxHealth, poisoned, withered, frozen, absorption);
            }
        }
        RenderSystem.disableBlend();
        mc.getProfiler().pop();
    }

    private static void renderBar(PoseStack matrix, Minecraft mc, int left, int top, float currentHealth, float maxHealth, boolean poisoned, boolean withered, boolean frozen, float absorption, boolean bleeding) {
        int uvY = 0;
        if (absorption > 0.0f) {
            uvY = 48;
        } else if (frozen) {
            uvY = 96;
        } else if (withered) {
            uvY = 84;
        } else if (poisoned) {
            uvY = 72;
        } else if (bleeding) {
            uvY = 120;
        } else if (mc.player.hasEffect(MobEffects.HEALTH_BOOST)) {
            uvY = 60;
        } else if (mc.level.getLevelData().isHardcore()) {
            uvY = 108;
        }
        if (!NumberUtil.roundToNthDecimalPlace(lastTickHealth, 1).equals(NumberUtil.roundToNthDecimalPlace(currentHealth, 1))) {
            if (lastTickHealth < currentHealth) {
                if (lastHealthTime == 0) {
                    lastTickHealth = currentHealth;
                    lastHealthTime = mc.player.tickCount;
                    return;
                }
                if (deltaHealth < 0.0f) {
                    deltaHealth = 0.0f;
                }
                deltaHealth += currentHealth - lastTickHealth;
            } else {
                if (deltaHealth > 0.0f) {
                    deltaHealth = 0.0f;
                }
                deltaHealth -= lastTickHealth - currentHealth;
            }
            lastHealthTime = mc.player.tickCount + 12;
        }
        if (deltaHealth != 0.0f && lastHealthTime + 20 < mc.player.tickCount) {
            deltaHealth = 0.0f;
        }
        lastTickHealth = currentHealth;
        matrix.pushPose();
        matrix.translate((double)left, (double)top - 1.9, 0.0);
        RenderUtil.prepRenderTexture(HEALTH_BAR);
        float healthWidth = 81.0f * (currentHealth / maxHealth);
        if (currentHealth < maxHealth) {
            RenderUtil.renderCustomSizedTexture(matrix, 0.0f, 0.0f, 0.0f, 12.0f, 81.0f, 12.0f, 81.0f, 132.0f);
        }
        if (!mc.player.isAlive()) {
            matrix.popPose();
            return;
        }
        RenderUtil.renderCustomSizedTexture(matrix, 0.0f, 0.0f, 0.0f, uvY, healthWidth, 12.0f, 81.0f, 132.0f);
        if (deltaHealth != 0.0f) {
            float x;
            int deltaUvY = deltaHealth < 0.0f ? 24 : 36;
            float deltaWidth = mc.player.tickCount - lastHealthTime < 8 ? 1.0f : (float)(12 - (mc.player.tickCount - 8 - lastHealthTime)) / 12.0f;
            float width = Math.min(Math.abs(deltaHealth), maxHealth) / maxHealth * 81.0f * deltaWidth;
            float f = x = deltaHealth < 0.0f ? healthWidth : healthWidth - width;
            if (deltaHealth < 0.0f && x + width > 81.0f) {
                width = 81.0f - x;
            }
            RenderUtil.renderScaledCustomSizedTexture(matrix, x, 0.0f, x, deltaUvY, width, 12.0f, width, 12.0f, 81.0f, 132.0f);
        }
        RenderUtil.drawRectangle(matrix, 0.0f, 0.0f, 81.0f, 11.0f, 0x44000000);
        matrix.popPose();
    }

    private static void renderNumeric(PoseStack matrix, Minecraft mc, int left, int top, float currentHealth, float maxHealth, boolean poisoned, boolean withered, boolean frozen, float absorption) {
        int healthColour = poisoned ? ColourUtil.RGB(117, 113, 0) : (withered ? ColourUtil.RGB(28, 28, 28) : ColourUtil.RGB(252, 20, 0));
        matrix.pushPose();
        if (AoAConfigs.CLIENT.healthRenderType.get() == HealthRenderType.NUMERIC) {
            if (absorption > 0.0f) {
                left -= 15;
            }
            matrix.translate((double)(left + 15), (double)top + 0.9, 0.0);
            matrix.scale(0.9f, 0.9f, 1.0f);
            if (currentHealth > 0.0f) {
                HealthStatusRenderer.renderHeart(matrix, mc, currentHealth, maxHealth, HealthStatusRenderer.handleHealthState(mc.player, mc.gui, (int)Math.ceil(currentHealth)), poisoned, withered, frozen, absorption);
                RenderUtil.renderCenteredScaledText(matrix, (Component)Component.literal((String)(NumberUtil.roundToNthDecimalPlace(currentHealth, 1) + "/" + NumberUtil.roundToNthDecimalPlace(maxHealth, 1))), 34.0f, 0.0f, 1.0f, healthColour, RenderUtil.TextRenderType.OUTLINED);
                if (absorption > 0.0f) {
                    RenderUtil.renderCenteredScaledText(matrix, (Component)Component.literal((String)"+"), 67.0f, 0.0f, 1.0f, ColourUtil.RGB(255, 204, 0), RenderUtil.TextRenderType.OUTLINED);
                    RenderUtil.renderCenteredScaledText(matrix, (Component)Component.literal((String)NumberUtil.roundToNthDecimalPlace(absorption, 1)), 83.0f, 0.0f, 1.0f, ColourUtil.RGB(255, 204, 0), RenderUtil.TextRenderType.OUTLINED);
                }
            } else {
                RenderUtil.renderCenteredScaledText(matrix, (Component)LocaleUtil.getLocaleMessage("deathScreen.title"), AoAConfigs.CLIENT.healthRenderType.get() == HealthRenderType.BAR_NUMERIC ? 28.5f : 24.0f, 0.0f, 1.0f, ColourUtil.RGB(150, 0, 0), RenderUtil.TextRenderType.OUTLINED);
            }
        } else {
            mc.gui.leftHeight += 2;
            if (absorption > 0.0f) {
                left -= 8;
            }
            matrix.translate((double)(left + 17), (double)top + 1.2, 0.0);
            matrix.scale(0.8f, 0.8f, 1.0f);
            if (currentHealth > 0.0f) {
                HealthStatusRenderer.renderHeart(matrix, mc, currentHealth, maxHealth, HealthStatusRenderer.handleHealthState(mc.player, mc.gui, (int)Math.ceil(currentHealth)), poisoned, withered, frozen, absorption);
                RenderUtil.renderCenteredScaledText(matrix, (Component)Component.literal((String)(NumberUtil.roundToNthDecimalPlace(currentHealth, 1) + "/" + NumberUtil.roundToNthDecimalPlace(maxHealth, 1))), 34.0f, 0.0f, 1.0f, healthColour, RenderUtil.TextRenderType.OUTLINED);
                if (absorption > 0.0f) {
                    RenderUtil.renderCenteredScaledText(matrix, (Component)Component.literal((String)"+"), 62.0f, 0.0f, 1.0f, ColourUtil.RGB(255, 204, 0), RenderUtil.TextRenderType.OUTLINED);
                    RenderUtil.renderCenteredScaledText(matrix, (Component)Component.literal((String)NumberUtil.roundToNthDecimalPlace(absorption, 1)), 70.0f, 0.0f, 1.0f, ColourUtil.RGB(255, 204, 0), RenderUtil.TextRenderType.OUTLINED);
                }
            } else {
                RenderUtil.renderCenteredScaledText(matrix, (Component)LocaleUtil.getLocaleMessage("deathScreen.title"), AoAConfigs.CLIENT.healthRenderType.get() == HealthRenderType.BAR_NUMERIC ? 28.5f : 24.0f, 0.0f, 1.0f, ColourUtil.RGB(150, 0, 0), RenderUtil.TextRenderType.OUTLINED);
            }
        }
        matrix.popPose();
    }

    private static void renderHeart(PoseStack poseStack, Minecraft mc, float currentHealth, float maxHealth, boolean flashing, boolean poisoned, boolean withered, boolean frozen, float absorb) {
        boolean hardcore = mc.level.getLevelData().isHardcore();
        int y = -1;
        if (currentHealth <= maxHealth * 0.2f && RandomUtil.fiftyFifty()) {
            ++y;
        }
        if (mc.gui.tickCount % 25 == 0 && mc.player.hasEffect(MobEffects.REGENERATION)) {
            y -= 2;
        }
        RenderUtil.renderSprite(poseStack, Gui.HeartType.CONTAINER.getSprite(hardcore, false, flashing), 0, y, 9.0f, 9.0f);
        RenderUtil.renderSprite(poseStack, Gui.HeartType.forPlayer((Player)mc.player).getSprite(hardcore, currentHealth < maxHealth, flashing), 0, y, 9.0f, 9.0f);
    }

    private static boolean handleHealthState(LocalPlayer player, Gui gui, float currentHealth) {
        boolean shouldFlash;
        boolean bl = shouldFlash = gui.healthBlinkTime > (long)gui.tickCount && (gui.healthBlinkTime - (long)gui.tickCount) / 3L % 2L == 1L;
        if (currentHealth < (float)gui.lastHealth && player.invulnerableTime > 0) {
            gui.lastHealthTime = Util.getMillis();
            gui.healthBlinkTime = gui.tickCount + 20;
        } else if (currentHealth > (float)gui.lastHealth && player.invulnerableTime > 0) {
            gui.lastHealthTime = Util.getMillis();
            gui.healthBlinkTime = gui.tickCount + 10;
        }
        if (Util.getMillis() - gui.lastHealthTime > 1000L) {
            gui.lastHealth = (int)currentHealth;
            gui.displayHealth = (int)currentHealth;
            gui.lastHealthTime = Util.getMillis();
        }
        gui.lastHealth = (int)currentHealth;
        return shouldFlash;
    }

    public static enum HealthRenderType {
        HEARTS,
        BAR,
        NUMERIC,
        BAR_NUMERIC;

    }
}

