/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.hud;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.tslat.aoa3.client.gui.overlay.ScopeOverlayRenderer;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.smartbrainlib.util.RandomUtil;

public final class AoACameraModifications {
    private static final RecoilContainer RECOIL = new RecoilContainer();
    private static final List<ShakeContainer> SHAKE = new CopyOnWriteArrayList<ShakeContainer>();

    public static void init() {
        NeoForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, RenderFrameEvent.Post.class, AoACameraModifications::onRender);
    }

    public static void addScreenRecoil(float vertical, float lateral) {
        float adjustedVertical = AoACameraModifications.getCamera(Minecraft.getInstance()).filter(camera -> camera.getXRot() < -40.0f).map(camera -> Float.valueOf(vertical / (1.5f * (camera.getXRot() / -20.0f)))).orElse(Float.valueOf(vertical)).floatValue();
        RECOIL.addRecoil(adjustedVertical, lateral);
    }

    public static void addScreenShake(double frequency, float strength, float dampening) {
        if (!AoAConfigs.CLIENT.screenShake.getAsBoolean()) {
            return;
        }
        SHAKE.add(new ShakeContainer(frequency * (double)(RandomUtil.fiftyFifty() ? 1 : -1), strength, Math.min(dampening, 0.995f)));
    }

    private static Optional<Entity> getCamera(Minecraft mc) {
        return Optional.ofNullable(mc.getCameraEntity() != null ? mc.getCameraEntity() : mc.player);
    }

    private static void onRender(RenderFrameEvent.Post ev) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.isPaused()) {
            return;
        }
        AoACameraModifications.getCamera(mc).ifPresent(camera -> {
            AoACameraModifications.addRecoil(camera);
            AoACameraModifications.addShake(camera);
        });
    }

    private static void addShake(Entity camera) {
        if (SHAKE.isEmpty()) {
            return;
        }
        for (ShakeContainer shake2 : SHAKE) {
            float angle = (long)((double)System.currentTimeMillis() * shake2.frequency / 2.75) % 360L;
            camera.setYRot(camera.getYRot() + Mth.sin((float)(angle * ((float)Math.PI / 180))) * shake2.force);
            camera.setXRot(camera.getXRot() + Mth.sin((float)(angle * ((float)Math.PI / 180))) * shake2.force * 0.1f * (float)camera.getRandom().nextGaussian());
            shake2.dampen();
        }
        SHAKE.removeIf(shake -> shake.force < 0.04f);
    }

    private static void addRecoil(Entity camera) {
        float adjustAmount;
        if (AoACameraModifications.RECOIL.lastVerticalAmount > 0.01f) {
            adjustAmount = AoACameraModifications.RECOIL.lastVerticalAmount / 7.0f;
            AoACameraModifications.RECOIL.lastVerticalAmount -= adjustAmount;
            camera.setXRot(camera.getXRot() - adjustAmount);
        }
        if (camera.getXRot() - AoACameraModifications.RECOIL.lastVerticalAmount * 0.25f >= 0.0f && !ScopeOverlayRenderer.isScoped || AoACameraModifications.RECOIL.totalVerticalAmount <= 0.01f) {
            AoACameraModifications.RECOIL.totalVerticalAmount = 0.0f;
        } else {
            adjustAmount = Math.min(0.25f, AoACameraModifications.RECOIL.totalVerticalAmount * 0.01f);
            if (AoACameraModifications.RECOIL.lastVerticalAmount <= 0.01f) {
                adjustAmount *= 2.0f;
            }
            AoACameraModifications.RECOIL.totalVerticalAmount -= adjustAmount;
            camera.setXRot(camera.getXRot() + adjustAmount);
        }
        if (AoACameraModifications.RECOIL.lateralAmount != 0.0f) {
            camera.setYRot(camera.getYRot() + AoACameraModifications.RECOIL.lateralAmount * 0.25f);
            AoACameraModifications.RECOIL.lateralAmount *= 0.75f;
        }
    }

    private static class RecoilContainer {
        float totalVerticalAmount = 0.0f;
        float lastVerticalAmount = 0.0f;
        float lateralAmount = 0.0f;

        private RecoilContainer() {
        }

        void addRecoil(float vertical, float lateral) {
            this.totalVerticalAmount += vertical;
            this.lastVerticalAmount += vertical;
            this.lateralAmount += lateral;
            if (this.totalVerticalAmount > 75.0f) {
                this.totalVerticalAmount = 75.0f;
            }
        }
    }

    private static class ShakeContainer {
        final double frequency;
        final float dampening;
        float force;

        ShakeContainer(double frequency, float force, float dampening) {
            this.frequency = frequency;
            this.dampening = dampening;
            this.force = force;
        }

        void dampen() {
            this.force *= this.dampening;
        }
    }
}

