/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.container;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.menu.FrameBenchMenu;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.util.RenderUtil;

public class FrameBenchScreen
extends AbstractContainerScreen<FrameBenchMenu> {
    private static final ResourceLocation TEXTURES = AdventOfAscension.id("textures/gui/containers/frame_bench.png");

    public FrameBenchScreen(FrameBenchMenu container, Inventory inv, Component guiTitle) {
        super((AbstractContainerMenu)container, inv, guiTitle);
        this.titleLabelY -= 2;
    }

    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new FrameSelectButton(this, 0, this.leftPos + 55, this.topPos + 13, (Supplier<Item>)AoAItems.CROSSBOW_FRAME));
        this.addRenderableWidget((GuiEventListener)new FrameSelectButton(this, 1, this.leftPos + 75, this.topPos + 13, (Supplier<Item>)AoAItems.BLASTER_FRAME));
        this.addRenderableWidget((GuiEventListener)new FrameSelectButton(this, 2, this.leftPos + 95, this.topPos + 13, (Supplier<Item>)AoAItems.CANNON_FRAME));
        this.addRenderableWidget((GuiEventListener)new FrameSelectButton(this, 3, this.leftPos + 45, this.topPos + 33, (Supplier<Item>)AoAItems.HELMET_FRAME));
        this.addRenderableWidget((GuiEventListener)new FrameSelectButton(this, 4, this.leftPos + 65, this.topPos + 33, (Supplier<Item>)AoAItems.CHESTPLATE_FRAME));
        this.addRenderableWidget((GuiEventListener)new FrameSelectButton(this, 5, this.leftPos + 85, this.topPos + 33, (Supplier<Item>)AoAItems.LEGGINGS_FRAME));
        this.addRenderableWidget((GuiEventListener)new FrameSelectButton(this, 6, this.leftPos + 105, this.topPos + 33, (Supplier<Item>)AoAItems.BOOTS_FRAME));
        this.addRenderableWidget((GuiEventListener)new FrameSelectButton(this, 7, this.leftPos + 55, this.topPos + 53, (Supplier<Item>)AoAItems.GUN_FRAME));
        this.addRenderableWidget((GuiEventListener)new FrameSelectButton(this, 8, this.leftPos + 75, this.topPos + 53, (Supplier<Item>)AoAItems.SHOTGUN_FRAME));
        this.addRenderableWidget((GuiEventListener)new FrameSelectButton(this, 9, this.leftPos + 95, this.topPos + 53, (Supplier<Item>)AoAItems.SNIPER_FRAME));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderUtil.resetShaderColour();
        RenderUtil.prepRenderTexture(TEXTURES);
        RenderUtil.renderCustomSizedTexture(guiGraphics.pose(), this.leftPos, this.topPos, 0.0f, 0.0f, 175.0f, 165.0f, 256.0f, 256.0f);
    }

    private static class FrameSelectButton
    extends Button {
        private static final int buttonWidth = 18;
        private static final int buttonHeight = 18;
        private final FrameBenchScreen screen;
        private final Item frame;
        private final int selectionId;

        private FrameSelectButton(FrameBenchScreen screen, int selectionId, int x, int y, Supplier<Item> frame) {
            super(x, y, 18, 18, (Component)Component.translatable((String)frame.get().getDescriptionId()), button -> {}, DEFAULT_NARRATION);
            this.screen = screen;
            this.frame = frame.get();
            this.selectionId = selectionId;
            this.setTooltip(Tooltip.create((Component)this.frame.getDefaultInstance().getHoverName()));
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            RenderUtil.prepRenderTexture(TEXTURES);
            RenderUtil.resetShaderColour();
            this.isHovered = this.isMouseInRegion(mouseX, mouseY, this.getX(), this.getY());
            int textureX = 176;
            int textureY = 21 + 18 * (this.selectionId == ((FrameBenchMenu)this.screen.menu).getCurrentSelection() ? 0 : RenderUtil.selectVForWidgetState((AbstractWidget)this, 1, 1, 2));
            RenderUtil.renderCustomSizedTexture(poseStack, this.getX(), this.getY(), textureX, textureY, 18.0f, 18.0f, 256.0f, 256.0f);
            poseStack.translate(0.0f, 0.0f, 32.0f);
            guiGraphics.renderItem(new ItemStack((ItemLike)this.frame), this.getX() + 1, this.getY() + 1);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.popPose();
        }

        private boolean isMouseInRegion(int mouseX, int mouseY, int buttonX, int buttonY) {
            return mouseX >= buttonX && mouseX <= buttonX + 18 && mouseY >= buttonY && mouseY <= buttonY + 18;
        }

        protected boolean clicked(double mouseX, double mouseY) {
            return this.active && this.isHovered && this.selectionId != ((FrameBenchMenu)this.screen.menu).getCurrentSelection();
        }

        public void onClick(double mouseX, double mouseY) {
            if (((FrameBenchMenu)this.screen.menu).clickMenuButton((Player)Minecraft.getInstance().player, this.selectionId)) {
                Minecraft.getInstance().gameMode.handleInventoryButtonClick(((FrameBenchMenu)((FrameBenchScreen)this.screen).menu).containerId, this.selectionId);
            }
        }
    }
}

