/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.container;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.menu.BankerMenu;
import net.tslat.aoa3.library.object.RenderContext;
import net.tslat.aoa3.util.RenderUtil;

public class BankerScreen
extends AbstractContainerScreen<BankerMenu> {
    private static final ResourceLocation GUI_TEXTURE = AdventOfAscension.id("textures/gui/containers/banker.png");
    private final Minecraft mc;

    public BankerScreen(BankerMenu container, Inventory inv, Component guiTitle) {
        super((AbstractContainerMenu)container, inv, guiTitle);
        this.imageHeight = 187;
        this.mc = Minecraft.getInstance();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int centerX = (this.width - this.imageWidth) / 2;
        int centerY = (this.height - this.imageHeight) / 2;
        RenderContext renderContext = RenderContext.of(guiGraphics);
        renderContext.resetShaderColour();
        renderContext.setTextureForRendering(GUI_TEXTURE);
        renderContext.renderCustomSizedTexture(centerX, centerY, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256.0f, 256.0f);
        if (this.mc.player != null) {
            this.renderCoinPlaceholders(renderContext, centerX, centerY);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int titleWidth = 4 + this.mc.font.width((FormattedText)this.title);
        RenderContext renderContext = RenderContext.of(guiGraphics);
        renderContext.setTextureForRendering(GUI_TEXTURE);
        renderContext.resetShaderColour();
        renderContext.renderCustomSizedTexture(28, 4, 176.0f, 15.0f, 1.0f, 12.0f, 256.0f, 256.0f);
        for (int i = 0; i < titleWidth - 2; ++i) {
            renderContext.renderCustomSizedTexture(29 + i, 4, 177.0f, 15.0f, 1.0f, 12.0f, 256.0f, 256.0f);
        }
        renderContext.renderCustomSizedTexture(28 + titleWidth - 2, 4, 178.0f, 15.0f, 1.0f, 12.0f, 256.0f, 256.0f);
        renderContext.resetShaderColour();
        renderContext.renderText(this.title, 30.0f, 60.0f, 0xFFFFFF, RenderUtil.TextRenderType.NORMAL);
    }

    private void renderCoinPlaceholders(RenderContext renderContext, int centerX, int centerY) {
        for (int i = 0; i < 12; ++i) {
            Slot slot = ((BankerMenu)this.menu).getSlot(i);
            ItemStack stack = slot.getItem();
            if (!stack.isEmpty()) continue;
            ItemStack coinStack = new ItemStack((ItemLike)BankerMenu.getCoinForSlot(i), i < 3 || i > 8 ? 20 : 1);
            renderContext.renderDummyItemAndDetails(coinStack, slot.x + centerX, slot.y + centerY);
        }
    }
}

