/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.adventgui;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.gui.adventgui.AdventMainGui;
import net.tslat.aoa3.client.gui.lib.ScrollablePane;
import net.tslat.aoa3.client.player.ClientPlayerDataManager;
import net.tslat.aoa3.client.render.AoAGuiElementRenderers;
import net.tslat.aoa3.client.render.custom.AoASkillRenderer;
import net.tslat.aoa3.common.networking.AoANetworking;
import net.tslat.aoa3.common.networking.packets.AddSkillCyclePacket;
import net.tslat.aoa3.common.networking.packets.adventplayer.ToggleAoAAbilityPacket;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.common.registration.entity.AoAMonsters;
import net.tslat.aoa3.library.object.RenderContext;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.RenderUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.joml.Vector3f;

public class AdventGuiTabPlayer
extends Screen {
    private static final ResourceLocation TOTAL_LEVEL_ICON = AdventOfAscension.id("textures/gui/aoaskill/total_level.png");
    private LivingEntity entityToRender = null;
    private float skillRenderScale = 1.0f;
    private AbilityPane abilityPane = null;
    private float adjustedMouseX;
    private float adjustedMouseY;
    private boolean hoveringSkillClose = false;
    private boolean hoveringAddCycle = false;
    private long addCycleLastClicked = -1L;

    protected AdventGuiTabPlayer() {
        super((Component)Component.translatable((String)"gui.aoa3.adventGui.stats"));
    }

    protected void init() {
        boolean scaled;
        this.setRenderEntity();
        block0: do {
            int totalWidth = 40;
            int totalHeight = 0;
            scaled = true;
            this.clearWidgets();
            for (AoASkill.Instance skill : ClientPlayerDataManager.get().getSkills()) {
                AoASkillRenderer renderer = AoAGuiElementRenderers.getSkillRenderer(skill.type());
                float renderWidth = (float)(renderer.hudRenderWidth(skill) + 15) * this.skillRenderScale;
                float renderHeight = (float)(renderer.hudRenderHeight(skill) + 20) * this.skillRenderScale;
                if ((float)totalWidth + renderWidth >= 244.0f / this.skillRenderScale || (float)totalHeight + renderHeight >= 100.0f / this.skillRenderScale) {
                    totalWidth = 40;
                    if ((totalHeight = (int)((float)totalHeight + renderHeight)) >= 100) {
                        this.skillRenderScale *= 0.95f;
                        scaled = false;
                        continue block0;
                    }
                }
                this.addRenderableWidget((GuiEventListener)new SkillEntry(this, totalWidth + 7, totalHeight + 10, renderer, skill, this.skillRenderScale));
                totalWidth = (int)((float)totalWidth + renderWidth);
            }
        } while (!scaled);
        AoASkill.Instance skill = this.abilityPane == null ? null : this.abilityPane.skill;
        this.abilityPane = new AbilityPane(this.minecraft, AdventMainGui.scaledTabRootY + 50, AdventMainGui.scaledTabRootX + 250, 280, 500, AdventMainGui.SCALE);
        this.abilityPane.setSkill(skill);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderContext renderContext = RenderContext.of(guiGraphics);
        PoseStack poseStack = guiGraphics.pose();
        this.adjustedMouseX = (float)mouseX * (1.0f / AdventMainGui.SCALE);
        this.adjustedMouseY = (float)mouseY * (1.0f / AdventMainGui.SCALE);
        poseStack.pushPose();
        poseStack.translate((float)AdventMainGui.scaledTabRootX, (float)AdventMainGui.scaledTabRootY, 0.0f);
        if (this.abilityPane == null || this.abilityPane.skill == null) {
            this.hoveringAddCycle = false;
            this.hoveringSkillClose = false;
            poseStack.scale(1.6f, 1.6f, 1.0f);
            poseStack.pushPose();
            poseStack.scale(this.skillRenderScale, this.skillRenderScale, 1.0f);
            for (Renderable renderable : this.renderables) {
                renderable.render(guiGraphics, (int)this.adjustedMouseX, (int)this.adjustedMouseY, partialTick);
            }
        } else {
            AoASkillRenderer skillRenderer = AoAGuiElementRenderers.getSkillRenderer(this.abilityPane.skill.type());
            Font font = Minecraft.getInstance().font;
            float skillRenderWidth = (float)(skillRenderer.guiRenderWidth(this.abilityPane.skill) * 3) / 2.0f;
            this.hoveringSkillClose = this.adjustedMouseX > (float)(AdventMainGui.scaledTabRootX + 736) && this.adjustedMouseX < (float)(AdventMainGui.scaledTabRootX + 755) && this.adjustedMouseY > (float)(AdventMainGui.scaledTabRootY + 7) && this.adjustedMouseY < (float)(AdventMainGui.scaledTabRootY + 27);
            poseStack.pushPose();
            RenderUtil.renderScaledText(poseStack, (Component)Component.literal((String)"x"), 740.0f, 5.0f, 3.0f, this.hoveringSkillClose ? ColourUtil.RGB(75, 10, 10) : 0, RenderUtil.TextRenderType.OUTLINED);
            poseStack.translate(150.0f - skillRenderWidth / 2.0f, 20.0f, 0.0f);
            RenderUtil.renderCenteredScaledText(poseStack, (Component)this.abilityPane.skill.getName(), 0.0f, 0.0f, 2.0f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
            poseStack.translate(0.0f, 20.0f, 0.0f);
            poseStack.pushPose();
            poseStack.translate(-skillRenderWidth, 0.0f, 0.0f);
            poseStack.scale(3.0f, 3.0f, 1.0f);
            skillRenderer.renderInGui(renderContext, this.abilityPane.skill, partialTick, (int)this.adjustedMouseX, (int)this.adjustedMouseY, AoASkillRenderer.ProgressRenderType.None, false);
            poseStack.popPose();
            RenderUtil.renderCenteredScaledText(poseStack, (Component)Component.translatable((String)"gui.aoa3.adventGui.player.skillLevel", (Object[])new Object[]{""}), 0.0f, 80.0f, 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
            RenderUtil.renderCenteredScaledText(poseStack, (Component)Component.literal((String)String.valueOf(this.abilityPane.skill.getLevel(true))), 0.0f, 95.0f, 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
            RenderUtil.renderCenteredScaledText(poseStack, (Component)Component.translatable((String)"gui.aoa3.adventGui.player.skillXp", (Object[])new Object[]{""}), 0.0f, 120.0f, 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
            RenderUtil.renderCenteredScaledText(poseStack, (Component)Component.literal((String)NumberUtil.roundToNthDecimalPlace(this.abilityPane.skill.getXp(), 2)), 0.0f, 135.0f, 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
            RenderUtil.renderCenteredScaledText(poseStack, (Component)Component.translatable((String)"gui.aoa3.adventGui.player.skillXpRemaining", (Object[])new Object[]{""}), 0.0f, 160.0f, 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
            RenderUtil.renderCenteredScaledText(poseStack, (Component)Component.literal((String)NumberUtil.roundToNthDecimalPlace(PlayerUtil.getXpRequiredForNextLevel(this.abilityPane.skill.getLevel(true)), 2)), 0.0f, 175.0f, 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
            RenderUtil.renderCenteredScaledText(poseStack, (Component)Component.translatable((String)"gui.aoa3.adventGui.player.skillProgress", (Object[])new Object[]{""}), 0.0f, 200.0f, 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
            RenderUtil.renderCenteredScaledText(poseStack, (Component)Component.literal((String)(PlayerUtil.getLevelProgressPercentage(this.abilityPane.skill.getLevel(true), this.abilityPane.skill.getXp()) + "%")), 0.0f, 215.0f, 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
            RenderUtil.renderCenteredScaledText(poseStack, (Component)Component.translatable((String)"gui.aoa3.adventGui.player.skillCycles", (Object[])new Object[]{""}), 0.0f, 240.0f, 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
            RenderUtil.renderCenteredScaledText(poseStack, (Component)Component.literal((String)String.valueOf(this.abilityPane.skill.getCycles())), 0.0f, 255.0f, 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
            if (this.abilityPane.skill.getLevel(true) >= 100 && this.abilityPane.skill.getCycles() < 10) {
                MutableComponent text = this.addCycleLastClicked > 0L ? Component.translatable((String)"gui.aoa3.adventGui.player.addCycle.confirm") : Component.translatable((String)"gui.aoa3.adventGui.player.addCycle");
                int buttonWidth = font.width((FormattedText)text);
                boolean bl = this.hoveringAddCycle = this.adjustedMouseX > (float)AdventMainGui.scaledTabRootX + (150.0f - skillRenderWidth / 2.0f) - (float)buttonWidth / 2.0f * 1.5f && this.adjustedMouseX < (float)AdventMainGui.scaledTabRootX + (150.0f - skillRenderWidth / 2.0f) + (float)buttonWidth / 2.0f * 1.5f && this.adjustedMouseY > (float)(AdventMainGui.scaledTabRootY + 315) && this.adjustedMouseY < (float)(AdventMainGui.scaledTabRootY + 327);
                if (System.currentTimeMillis() - this.addCycleLastClicked > 3000L) {
                    this.addCycleLastClicked = -1L;
                }
                RenderUtil.renderCenteredScaledText(poseStack, (Component)text, 0.0f, 275.0f, 1.5f, this.hoveringAddCycle ? ColourUtil.RGB(255, 100, 100) : ColourUtil.RGB(255, 50, 50), RenderUtil.TextRenderType.DROP_SHADOW);
            } else {
                this.hoveringAddCycle = false;
            }
            poseStack.popPose();
            RenderUtil.renderCenteredScaledText(poseStack, (Component)Component.translatable((String)"gui.aoa3.adventGui.player.abilities"), 500.0f, 20.0f, 2.0f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
            poseStack.popPose();
            if (this.abilityPane != null) {
                this.abilityPane.render(guiGraphics, this.adjustedMouseX, this.adjustedMouseY, partialTick);
            }
            return;
        }
        poseStack.popPose();
        this.drawPlayerBox(poseStack, this.adjustedMouseX, this.adjustedMouseY, 67, partialTick);
        this.drawTotalLevel(poseStack, this.adjustedMouseX, this.adjustedMouseY, partialTick);
        poseStack.popPose();
    }

    public void renderTransparentBackground(GuiGraphics pGuiGraphics) {
    }

    private void drawTotalLevel(PoseStack matrix, float mouseX, float mouseY, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        int totalLevel = ClientPlayerDataManager.get().getTotalLevel();
        if (totalLevel == 0) {
            RenderUtil.renderCenteredScaledText(matrix, (Component)Component.translatable((String)"gui.aoa3.adventGui.player.noSkills"), 280.0f, 80.0f, 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
            return;
        }
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TOTAL_LEVEL_ICON);
        RenderUtil.renderScaledCustomSizedTexture(matrix, 10.0f, 14.0f, 0.0f, 0.0f, 48.0f, 48.0f, 60.0f, 60.0f, 48.0f, 48.0f);
        RenderUtil.renderCenteredScaledText(matrix, (Component)Component.translatable((String)"gui.aoa3.adventGui.player.totalLevel"), 40.0f, 10.0f, 1.0f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
        RenderUtil.renderCenteredScaledText(matrix, (Component)Component.literal((String)String.valueOf(ClientPlayerDataManager.get().getTotalLevel())), 40.0f, 40.0f, 1.0f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
    }

    private void drawPlayerBox(PoseStack poseStack, float mouseX, float mouseY, int scale, float partialTicks) {
        poseStack.pushPose();
        if (this.entityToRender == null) {
            this.setRenderEntity();
        }
        Minecraft mc = Minecraft.getInstance();
        Component name = mc.player.getDisplayName();
        float mouseAngleX = (float)Math.atan(((float)(AdventMainGui.scaledRootX + 264) - mouseX) / 40.0f);
        float mouseAngleY = (float)Math.atan(((float)(AdventMainGui.scaledRootY + 465 - 111) - mouseY) / 40.0f);
        poseStack.translate(40.0f, 206.0f, 1050.0f);
        RenderUtil.renderCenteredScaledText(poseStack, name, 0.0f, -104.0f, 1.0f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
        poseStack.scale(1.0f, 1.0f, -1.0f);
        poseStack.translate(0.0, 0.0, 1000.0);
        poseStack.scale((float)scale * 0.625f, (float)scale * 0.625f, (float)scale * 0.625f);
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        float yawOffset = this.entityToRender.yBodyRot;
        float prevYawOffset = this.entityToRender.yBodyRotO;
        float rotYaw = this.entityToRender.getYRot();
        float rotPitch = this.entityToRender.getXRot();
        float prevYawHead = this.entityToRender.yHeadRotO;
        float rotYawHead = this.entityToRender.yHeadRot;
        this.entityToRender.yBodyRot = 0.0f;
        this.entityToRender.yBodyRotO = 0.0f;
        this.entityToRender.setYRot(mouseAngleX * 40.0f);
        this.entityToRender.setXRot(-mouseAngleY * 20.0f);
        this.entityToRender.yHeadRot = this.entityToRender.getYRot();
        this.entityToRender.yHeadRotO = this.entityToRender.getYRot();
        EntityRenderDispatcher renderManager = Minecraft.getInstance().getEntityRenderDispatcher();
        MultiBufferSource.BufferSource renderBuffer = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderSystem.setShaderLights((Vector3f)new Vector3f(0.2f, 0.5f, 1.0f).normalize(), (Vector3f)new Vector3f(-0.2f, -1.0f, -0.3f));
        renderManager.setRenderShadow(false);
        RenderSystem.runAsFancy(() -> renderManager.render((Entity)this.entityToRender, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)renderBuffer, 0xF000F0));
        renderManager.setRenderShadow(true);
        renderBuffer.endBatch();
        Lighting.setupFor3DItems();
        this.entityToRender.yBodyRot = yawOffset;
        this.entityToRender.yBodyRotO = prevYawOffset;
        this.entityToRender.setYRot(rotYaw);
        this.entityToRender.setXRot(rotPitch);
        this.entityToRender.yHeadRotO = prevYawHead;
        this.entityToRender.yHeadRot = rotYawHead;
        poseStack.popPose();
    }

    public void removed() {
        super.removed();
        if (this.entityToRender != null && !(this.entityToRender instanceof Player)) {
            this.entityToRender.discard();
        }
        this.entityToRender = null;
    }

    private void setRenderEntity() {
        if (this.entityToRender == null) {
            Minecraft mc = Minecraft.getInstance();
            this.entityToRender = !ClientPlayerDataManager.get().isLegitimate() ? (LivingEntity)((EntityType)((DeferredHolder)RandomUtil.getRandomSelection((Object[])new DeferredHolder[]{AoAMonsters.CHARGER, AoAMonsters.CYCLOPS, AoAMonsters.ANCIENT_GOLEM})).get()).create((Level)mc.level) : mc.player;
        }
    }

    public void resize(Minecraft mc, int pWidth, int pHeight) {
        super.resize(mc, pWidth, pHeight);
        if (this.abilityPane != null) {
            this.abilityPane.onResize(mc, AdventMainGui.scaledTabRootX + 250, AdventMainGui.scaledTabRootY + 50, 500, 280);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.abilityPane != null && this.abilityPane.skill != null) {
            if (this.hoveringSkillClose) {
                this.abilityPane.setSkill(null);
                return true;
            }
            if (this.hoveringAddCycle) {
                if (this.addCycleLastClicked < 0L) {
                    this.addCycleLastClicked = System.currentTimeMillis();
                    return true;
                }
                if (this.abilityPane.skill.type() != null) {
                    AoANetworking.sendToServer(new AddSkillCyclePacket(this.abilityPane.skill.type()));
                }
                return true;
            }
            if (this.abilityPane.handleMouseClick(this.adjustedMouseX, this.adjustedMouseY, button)) {
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.abilityPane != null && this.abilityPane.skill != null && this.abilityPane.handleMouseReleased(this.adjustedMouseX, this.adjustedMouseY, button)) {
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double lateralScroll, double verticalScroll) {
        if (this.abilityPane != null && this.abilityPane.skill != null && this.abilityPane.handleMouseScroll(this.adjustedMouseX, this.adjustedMouseY, verticalScroll)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, lateralScroll, verticalScroll);
    }

    private static class AbilityPane
    extends ScrollablePane {
        private AoASkill.Instance skill;
        private List<AoAAbility.Instance> sortedAbilities = null;
        private int hoveredAbility = -1;
        private float clickStartScroll = -1.0f;

        public AbilityPane(Minecraft mc, int top, int left, int viewHeight, int viewWidth, float renderingScale) {
            super(mc, top, left, viewHeight, viewWidth, renderingScale);
        }

        private void setSkill(AoASkill.Instance skill) {
            this.skill = skill;
            this.sortedAbilities = skill == null ? null : skill.getAbilityMap().values().stream().sorted(Comparator.comparingInt(AoAAbility.Instance::getLevelReq)).collect(Collectors.toList());
        }

        @Override
        public int getFullPaneHeight() {
            return this.skill != null ? this.viewHeight + this.skill.getAbilityMap().size() * 25 - 140 : 0;
        }

        @Override
        public boolean handleMouseClick(double mouseX, double mouseY, int button) {
            if (!this.isMouseHovering()) {
                return false;
            }
            this.clickStartScroll = this.distanceScrolled;
            return super.handleMouseClick(mouseX, mouseY, button);
        }

        @Override
        public boolean handleMouseReleased(double mouseX, double mouseY, int button) {
            AoAAbility.Instance instance;
            boolean wasDragging = this.isDragging;
            this.isDragging = false;
            if (!this.isMouseHovering()) {
                return false;
            }
            if (wasDragging && this.clickStartScroll == this.distanceScrolled && this.hoveredAbility != -1 && (instance = this.sortedAbilities.get(this.hoveredAbility)).onGuiClick((int)this.mouseX - this.left, (int)this.mouseY - this.top - this.hoveredAbility * 50 + (int)this.distanceScrolled * 2) && this.skill.type() != null) {
                AoANetworking.sendToServer(new ToggleAoAAbilityPacket(this.skill.type(), instance));
            }
            return super.handleMouseReleased(mouseX, mouseY, button);
        }

        @Override
        public void drawPaneContents(GuiGraphics guiGraphics, int top, int left, int right, int bottom, float scrollDistance, float partialTicks) {
            Minecraft mc = Minecraft.getInstance();
            float center = (float)(right - left) / 2.0f;
            PoseStack poseStack = guiGraphics.pose();
            this.hoveredAbility = this.isMouseHovering() && this.mouseX < (float)(right - 8) ? Math.min((int)(-(((float)top - this.mouseY - scrollDistance) / 50.0f)), this.sortedAbilities.size() - 1) : -1;
            poseStack.pushPose();
            poseStack.translate((float)left, (float)top, 0.0f);
            poseStack.translate(0.0f, -scrollDistance, 0.0f);
            for (int i = 0; i < this.sortedAbilities.size(); ++i) {
                boolean abilityHoverEffects;
                AoAAbility.Instance ability = this.sortedAbilities.get(i);
                int colour = ColourUtil.RGB(100, 100, 100);
                boolean bl = abilityHoverEffects = this.hoveredAbility == i && this.sortedAbilities.get(this.hoveredAbility).onGuiHover((int)this.mouseX - left, (int)this.mouseY - top - (i * 50 - (int)scrollDistance));
                if (ability.getListenerState() == AoAPlayerEventListener.ListenerState.ACTIVE) {
                    colour = abilityHoverEffects ? ColourUtil.RGB(255, 255, 180) : 0xFFFFFF;
                } else if (ability.getListenerState() == AoAPlayerEventListener.ListenerState.MANUALLY_DISABLED && abilityHoverEffects) {
                    colour = ColourUtil.RGB(150, 150, 100);
                }
                RenderUtil.renderScaledText(poseStack, (Component)Component.literal((String)String.valueOf(ability.getLevelReq())), 5.0f, 2.0f, 1.5f, colour, RenderUtil.TextRenderType.OUTLINED);
                RenderUtil.renderCenteredScaledText(poseStack, (Component)ability.getName(), center, 2.0f, 1.5f, colour, RenderUtil.TextRenderType.OUTLINED);
                poseStack.translate(0.0f, 20.0f, 0.0f);
                RenderUtil.renderWrappedText(poseStack, (Component)ability.getDescription(), 5.0f, 2.0f, right - left - 10, colour, RenderUtil.TextRenderType.NORMAL);
                poseStack.translate(0.0f, 30.0f, 0.0f);
            }
            poseStack.popPose();
        }

        @Override
        public void drawBackground(GuiGraphics guiGraphics) {
        }
    }

    private static class SkillEntry
    extends Button {
        private final AdventGuiTabPlayer tab;
        private final AoASkillRenderer renderer;
        private final AoASkill.Instance skill;
        private final float scale;

        private SkillEntry(AdventGuiTabPlayer tab, float posX, float posY, AoASkillRenderer renderer, AoASkill.Instance instance, float scale) {
            super((int)posX, (int)posY, renderer.guiRenderHeight(instance), renderer.guiRenderWidth(instance), (Component)instance.getName(), button -> {}, DEFAULT_NARRATION);
            this.tab = tab;
            this.renderer = renderer;
            this.skill = instance;
            this.scale = 3.2f * scale;
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (this.visible) {
                this.isHovered = this.isMouseOver(mouseX - AdventMainGui.scaledTabRootX, mouseY - AdventMainGui.scaledTabRootY);
                PoseStack poseStack = guiGraphics.pose();
                poseStack.pushPose();
                poseStack.scale(2.0f, 2.0f, 1.0f);
                poseStack.translate((float)this.getX(), (float)this.getY(), 0.0f);
                this.renderer.renderInGui(RenderContext.of(guiGraphics), this.skill, partialTicks, mouseX, mouseY, (AoASkillRenderer.ProgressRenderType)((Object)AoAConfigs.CLIENT.hudSkillProgressRenderType.get()), true);
                poseStack.translate(0.0f, -5.0f, 0.0f);
                poseStack.scale(0.5f, 0.5f, 1.0f);
                RenderUtil.renderCenteredScaledText(poseStack, this.getMessage(), this.width, 0.0f, 1.0f, this.isHovered ? ColourUtil.RGB(255, 255, 100) : 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
                poseStack.popPose();
            }
        }

        protected boolean clicked(double pMouseX, double pMouseY) {
            return this.isHovered;
        }

        public void onClick(double pMouseX, double pMouseY) {
            this.tab.abilityPane.setSkill(this.skill);
            this.isHovered = false;
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            if (!this.active || !this.visible) {
                return false;
            }
            if (mouseX <= (double)((float)this.getX() * this.scale)) {
                return false;
            }
            if (mouseX >= (double)((float)this.getX() * this.scale + (float)this.width * this.scale)) {
                return false;
            }
            if (mouseY <= (double)((float)(this.getY() * 2) * 1.6f)) {
                return false;
            }
            return mouseY < (double)((float)this.getY() * this.scale + (float)this.height * this.scale);
        }
    }
}

