/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.adventgui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.gui.adventgui.AdventMainGui;
import net.tslat.aoa3.common.networking.AoANetworking;
import net.tslat.aoa3.common.networking.packets.patchouli.AccountPatchouliBookPacket;
import net.tslat.aoa3.common.networking.packets.patchouli.GivePatchouliBookPacket;
import net.tslat.aoa3.integration.IntegrationManager;
import net.tslat.aoa3.integration.patchouli.PatchouliIntegration;
import net.tslat.aoa3.library.object.RenderContext;
import net.tslat.aoa3.util.RenderUtil;

public class AdventGuiTabLore
extends Screen {
    private int adjustedMouseX;
    private int adjustedMouseY;
    private static final ConcurrentHashMap<ResourceLocation, ItemStack> loreBooks = new ConcurrentHashMap();

    protected AdventGuiTabLore() {
        super((Component)Component.translatable((String)"gui.aoa3.adventGui.lore"));
    }

    protected void init() {
        int index = 0;
        int accumWidth = 0;
        int height = AdventMainGui.scaledTabRootY + 20;
        if (loreBooks.isEmpty()) {
            loreBooks.put(AdventOfAscension.id("aoa_essentia"), PatchouliIntegration.getBook(AdventOfAscension.id("aoa_essentia")));
        }
        for (Map.Entry<ResourceLocation, ItemStack> bookEntry : loreBooks.entrySet()) {
            int width = (int)((float)this.font.width((FormattedText)bookEntry.getValue().getHoverName()) * 1.5f);
            if (accumWidth + width + 25 + 25 * index >= 764) {
                height += 80;
                accumWidth = 0;
                index = 0;
            }
            this.addRenderableWidget((GuiEventListener)new PatchouliBook(bookEntry.getKey(), bookEntry.getValue(), AdventMainGui.scaledTabRootX + accumWidth + 25 + 25 * index, height));
            accumWidth += width;
            ++index;
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.adjustedMouseX = (int)((float)mouseX * (1.0f / AdventMainGui.SCALE));
        this.adjustedMouseY = (int)((float)mouseY * (1.0f / AdventMainGui.SCALE));
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public void renderTransparentBackground(GuiGraphics pGuiGraphics) {
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.setDragging(false);
        for (GuiEventListener listener : this.children()) {
            if (!listener.mouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public static void syncBooks(Collection<ResourceLocation> bookIds) {
        loreBooks.clear();
        if (!IntegrationManager.isPatchouliActive()) {
            return;
        }
        for (ResourceLocation id : bookIds) {
            if (!PatchouliIntegration.isBookLoaded(id)) continue;
            loreBooks.put(id, PatchouliIntegration.getBook(id));
        }
    }

    public static void bookOpened(ResourceLocation id) {
        if (!loreBooks.containsKey(id)) {
            AoANetworking.sendToServer(new AccountPatchouliBookPacket(id));
        }
    }

    private static class PatchouliBook
    extends AbstractWidget {
        private final ResourceLocation id;
        private final ItemStack book;
        private final int titleWidth;
        private boolean mouseHolding = false;

        private PatchouliBook(ResourceLocation id, ItemStack book, int x, int y) {
            super(x, y, 100, 100, book.getDisplayName());
            this.id = id;
            this.book = book;
            this.titleWidth = Minecraft.getInstance().font.width((FormattedText)book.getDisplayName());
        }

        protected boolean clicked(double mouseX, double mouseY) {
            return this.isMouseOver(mouseX, mouseY);
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            if (this.isValidClickButton(button)) {
                if (!this.mouseHolding) {
                    if (this.isHovered) {
                        PatchouliIntegration.openBook(this.id);
                        return true;
                    }
                } else {
                    this.mouseHolding = false;
                    if (mouseX / (double)AdventMainGui.SCALE < (double)AdventMainGui.scaledRootX || mouseY / (double)AdventMainGui.SCALE < (double)AdventMainGui.scaledRootY || mouseX / (double)AdventMainGui.SCALE > (double)(AdventMainGui.scaledRootX + 976) || mouseY / (double)AdventMainGui.SCALE > (double)(AdventMainGui.scaledRootY + 480)) {
                        LocalPlayer pl = Minecraft.getInstance().player;
                        for (ItemStack stack : pl.getInventory().items) {
                            if (!PatchouliIntegration.isValidBook(stack)) continue;
                            return true;
                        }
                        AoANetworking.sendToServer(new GivePatchouliBookPacket(this.id));
                        return true;
                    }
                }
            }
            return false;
        }

        protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
            if (this.isHovered) {
                this.mouseHolding = true;
            }
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            if (!this.active || !this.visible) {
                return false;
            }
            if (mouseX < (double)(((float)this.getX() + (float)this.titleWidth / 2.0f - 4.0f) * AdventMainGui.SCALE)) {
                return false;
            }
            if (mouseY < (double)((float)(this.getY() + 22 - 5) * AdventMainGui.SCALE)) {
                return false;
            }
            if (mouseX > (double)(((float)this.getX() + (float)this.titleWidth / 2.0f + 32.0f + 4.0f) * AdventMainGui.SCALE)) {
                return false;
            }
            return mouseY < (double)((float)(this.getY() + 22 + 32 + 5) * AdventMainGui.SCALE);
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            this.isHovered = this.isMouseOver(mouseX, mouseY);
            int itemX = this.mouseHolding ? (int)((float)(mouseX - 24) / AdventMainGui.SCALE) : (int)((float)this.getX() + (float)this.titleWidth / 2.0f);
            int itemY = this.mouseHolding ? (int)((float)(mouseY - 24) / AdventMainGui.SCALE) : (int)((float)this.getY() + 12.0f + 10.0f);
            RenderContext renderContext = RenderContext.of(guiGraphics);
            PoseStack poseStack = guiGraphics.pose();
            renderContext.renderScaledText(this.book.getHoverName(), this.getX(), this.getY(), 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.DROP_SHADOW);
            poseStack.pushPose();
            poseStack.scale(2.0f, 2.0f, 1.0f);
            renderContext.renderDummyItem(this.book, (int)((float)itemX / 2.0f), (int)((float)itemY / 2.0f));
            poseStack.popPose();
            if (this.isHovered && !this.mouseHolding) {
                poseStack.pushPose();
                poseStack.scale(1.5f, 1.5f, 1.5f);
                guiGraphics.renderTooltip(Minecraft.getInstance().font, Collections.singletonList(Component.translatable((String)"gui.aoa3.adventGui.lore.clickBook")), Optional.empty(), this.book, (int)((float)mouseX / AdventMainGui.SCALE / 1.5f), (int)((float)mouseY / AdventMainGui.SCALE / 1.5f));
                poseStack.popPose();
            }
        }

        protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
        }
    }
}

