/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.adventgui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.net.URI;
import java.net.URISyntaxException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.tslat.aoa3.client.gui.adventgui.AdventMainGui;
import net.tslat.aoa3.integration.IntegrationManager;
import net.tslat.aoa3.library.object.Text;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RenderUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;

public class AdventGuiTabHelp
extends Screen {
    private int tipNumber = RandomUtil.randomNumberUpTo((int)(IntegrationManager.isPatchouliActive() ? 12 : 13));

    protected AdventGuiTabHelp() {
        super((Component)Component.translatable((String)"gui.aoa3.adventGui.help"));
    }

    protected void init() {
        this.addRenderableWidget((GuiEventListener)new ThemeButton(640, 35, 30, 40));
        this.addRenderableWidget((GuiEventListener)new WebLinkButton(this.getMinecraft(), 640, 130, 76, 18, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.help.linkDiscord"), this.stringToURI("https://discord.gg/DNYqNNq")));
        this.addRenderableWidget((GuiEventListener)new WebLinkButton(this.getMinecraft(), 640, 170, 108, 18, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.help.linkWiki"), this.stringToURI("https://adventofascension.gamepedia.com/Advent_of_Ascension_Wiki")));
        this.addRenderableWidget((GuiEventListener)new WebLinkButton(this.getMinecraft(), 640, 210, 60, 18, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.help.linkGithub"), this.stringToURI("https://github.com/Tslat/Advent-Of-Ascension")));
        this.addRenderableWidget((GuiEventListener)new WebLinkButton(this.getMinecraft(), 640, 250, 80, 18, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.help.linkPatreon"), this.stringToURI("https://www.patreon.com/Tslat")));
        this.addRenderableWidget((GuiEventListener)new WebLinkButton(this.getMinecraft(), 640, 290, 68, 18, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.help.linkUpdate"), this.stringToURI("https://adventofascension.gamepedia.com/Download")));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        PoseStack poseStack = guiGraphics.pose();
        RenderUtil.renderVerticalGradient(poseStack, AdventMainGui.scaledTabRootX + 35, AdventMainGui.scaledTabRootY + 55, 570.0f, 225.0f, -1072689136, -804253680);
        RenderUtil.renderCenteredScaledText(poseStack, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.help.theme"), AdventMainGui.scaledTabRootX + 672, AdventMainGui.scaledTabRootY + 10, 2.0f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
        RenderUtil.renderCenteredScaledText(poseStack, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.help.links"), AdventMainGui.scaledTabRootX + 672, AdventMainGui.scaledTabRootY + 100, 2.0f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
        RenderUtil.renderScaledText(poseStack, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.help.title"), AdventMainGui.scaledTabRootX + 80, AdventMainGui.scaledTabRootY + 25, 2.5f, ColourUtil.RGB(239, 137, 119), RenderUtil.TextRenderType.OUTLINED);
        poseStack.pushPose();
        poseStack.scale(1.5625f, 1.5625f, 1.5625f);
        RenderUtil.renderWrappedText(poseStack, (Component)Component.literal((String)LocaleUtil.getLocaleString("gui.aoa3.adventGui.help.description").replace("<br>", "\n")), (int)((float)(AdventMainGui.scaledTabRootX + 40) / 1.5625f), (int)((float)(AdventMainGui.scaledTabRootY + 60) / 1.5625f), 360, 0xFFFFFF, RenderUtil.TextRenderType.NORMAL);
        poseStack.popPose();
        RenderUtil.renderScaledText(poseStack, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.help.tip", new Component[]{LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.help.tip." + this.tipNumber)}), AdventMainGui.scaledTabRootX + 30, AdventMainGui.scaledTabRootY + 310, 1.8f, 0xFFFFFF, RenderUtil.TextRenderType.DROP_SHADOW);
    }

    public void renderTransparentBackground(GuiGraphics pGuiGraphics) {
    }

    private static void openURL(URI url) {
        Util.getPlatform().openUri(url);
    }

    @Nullable
    private URI stringToURI(String url) {
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private static class ThemeButton
    extends Button {
        public ThemeButton(int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Text.of(AdventMainGui.theme.nameLocale()), button -> {}, DEFAULT_NARRATION);
        }

        public void onClick(double mouseX, double mouseY) {
            AdventMainGui.changeTheme();
            this.setMessage((Component)Text.of(AdventMainGui.theme.nameLocale()));
            this.setFocused(false);
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (this.visible) {
                this.isHovered = this.isMouseInRegion(mouseX, mouseY, this.getX(), this.getY());
                this.width = (int)(10.0f + (float)Minecraft.getInstance().font.width((FormattedText)this.getMessage()) * 1.5f);
                RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)AdventMainGui.theme.menuButtonTexture());
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderUtil.renderScaledCustomSizedTexture(guiGraphics.pose(), AdventMainGui.scaledTabRootX + this.getX(), AdventMainGui.scaledTabRootY + this.getY(), 0.0f, this.isHovered ? 60.0f : 0.0f, 180.0f, 60.0f, this.width, this.height, 180.0f, 180.0f);
                int stringColour = 0xE0E0E0;
                if (this.getFGColor() >= 0) {
                    stringColour = this.getFGColor();
                }
                if (this.isHovered) {
                    stringColour = 0xFFFFA0;
                }
                RenderUtil.renderCenteredScaledText(guiGraphics.pose(), this.getMessage(), (int)((float)(AdventMainGui.scaledTabRootX + this.getX()) + (float)this.width / 2.0f), (int)((double)(AdventMainGui.scaledTabRootY + this.getY()) + (double)this.height / 2.5), 1.5f, stringColour, RenderUtil.TextRenderType.DROP_SHADOW);
            }
        }

        protected boolean clicked(double p_clicked_1_, double p_clicked_3_) {
            return this.active && this.isHovered;
        }

        private boolean isMouseInRegion(int mouseX, int mouseY, int buttonX, int buttonY) {
            return mouseX >= (int)((float)(AdventMainGui.scaledTabRootX + buttonX) * AdventMainGui.SCALE) && mouseX <= (int)((float)(AdventMainGui.scaledTabRootX + buttonX + this.width) * AdventMainGui.SCALE) && mouseY >= (int)((float)(AdventMainGui.scaledTabRootY + buttonY) * AdventMainGui.SCALE) && mouseY <= (int)((float)(AdventMainGui.scaledTabRootY + buttonY + this.height) * AdventMainGui.SCALE);
        }
    }

    private static class WebLinkButton
    extends Button {
        private final URI url;

        public WebLinkButton(Minecraft mc, int x, int y, int width, int height, Component name, URI link) {
            super(x, y, width, height, name, button -> {}, DEFAULT_NARRATION);
            this.url = link;
            if (this.url == null) {
                this.active = false;
                this.visible = false;
            } else {
                this.width = (int)((float)mc.font.width((FormattedText)this.getMessage()) * 2.0f);
            }
        }

        public void onClick(double mouseX, double mouseY) {
            AdventGuiTabHelp.openURL(this.url);
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (this.visible) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.isHovered = this.isMouseInRegion(mouseX, mouseY, this.getX(), this.getY());
                int stringColour = ColourUtil.RGB(239, 137, 119);
                if (this.isHovered) {
                    stringColour = ColourUtil.RGB(247, 239, 0);
                }
                RenderUtil.renderCenteredScaledText(guiGraphics.pose(), this.getMessage(), (int)((float)(AdventMainGui.scaledTabRootX + this.getX()) + (float)this.width / 2.0f), AdventMainGui.scaledTabRootY + this.getY(), 2.0f, stringColour, RenderUtil.TextRenderType.OUTLINED);
            }
        }

        protected boolean clicked(double p_clicked_1_, double p_clicked_3_) {
            return this.active && this.isHovered;
        }

        private boolean isMouseInRegion(int mouseX, int mouseY, int buttonX, int buttonY) {
            return mouseX >= (int)((float)(AdventMainGui.scaledTabRootX + buttonX) * AdventMainGui.SCALE) && mouseX <= (int)((float)(AdventMainGui.scaledTabRootX + buttonX + this.width) * AdventMainGui.SCALE) && mouseY >= (int)((float)(AdventMainGui.scaledTabRootY + buttonY) * AdventMainGui.SCALE) && mouseY <= (int)((float)(AdventMainGui.scaledTabRootY + buttonY + this.height) * AdventMainGui.SCALE);
        }
    }
}

