/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.adventgui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.stats.StatsCounter;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.client.gui.adventgui.AdventMainGui;
import net.tslat.aoa3.client.gui.lib.ScrollablePane;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.content.entity.base.AoAFlyingRangedMob;
import net.tslat.aoa3.content.entity.base.AoARangedAttacker;
import net.tslat.aoa3.content.entity.base.AoARangedMob;
import net.tslat.aoa3.content.entity.base.AoAWaterMeleeMobOld;
import net.tslat.aoa3.content.entity.base.AoAWaterRangedMob;
import net.tslat.aoa3.data.client.BestiaryReloadListener;
import net.tslat.aoa3.library.object.RenderContext;
import net.tslat.aoa3.util.AttributeUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RenderUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class AdventGuiTabBestiary
extends Screen {
    private static final String[] LOADING_SYMBOLS = new String[]{"oooooo", "Oooooo", "oOoooo", "ooOooo", "oooOoo", "ooooOo", "oooooO"};
    private static final ResourceLocation iconsTextures = AdventOfAscension.id("textures/gui/adventgui/icons.png");
    private static final HashMap<String, Function<Entity, Tuple>> registeredEntryHandlers = new HashMap(1);
    private final HashMap<String, Entity> instancesMap = new HashMap();
    private StatsCounter stats;
    private Object2IntMap<Stat<?>> statsMap;
    private BestiaryMenu scrollMenu;
    private ArrayList<EntityStats> statList;
    private ArrayList<EntityStats> filteredMobList;
    private boolean receivedStats = false;
    private EntityStats lastOpenedEntry = null;
    private int openEntryIndex = -1;
    private int openEntryHeight = 0;
    private float lastDistanceScrolled = 0.0f;
    private Entity openEntryInstance = null;
    private List<FormattedCharSequence> openEntryInfoLines = null;
    private List<String> openEntryStatsLines = null;
    private int adjustedMouseX;
    private int adjustedMouseY;
    protected EditBox searchField;

    protected AdventGuiTabBestiary() {
        super((Component)Component.translatable((String)"gui.aoa3.adventGui.bestiary"));
    }

    protected void init() {
        this.receivedStats = false;
        this.openEntryIndex = -1;
        this.stats = this.getMinecraft().player.getStats();
        if (this.statsMap == null) {
            this.statsMap = this.stats.stats;
        }
        if (this.scrollMenu == null) {
            this.scrollMenu = new BestiaryMenu(this.minecraft, AdventMainGui.scaledTabRootY, AdventMainGui.scaledTabRootX, 340, 764, AdventMainGui.SCALE);
        }
        this.searchField = new EditBox(this.font, AdventMainGui.scaledTabRootX + 20, AdventMainGui.scaledTabRootY, (int)((double)(this.width - 40) / 2.0), 15, (Component)Component.literal((String)""));
        this.searchField.setVisible(false);
        this.getMinecraft().getConnection().send((Packet)new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.REQUEST_STATS));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.adjustedMouseX = (int)((float)mouseX * (1.0f / AdventMainGui.SCALE));
        this.adjustedMouseY = (int)((float)mouseY * (1.0f / AdventMainGui.SCALE));
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, this.adjustedMouseX, this.adjustedMouseY, partialTick);
        }
        this.scrollMenu.render(guiGraphics, this.adjustedMouseX, this.adjustedMouseY, partialTick);
    }

    public void renderTransparentBackground(GuiGraphics pGuiGraphics) {
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double lateralScroll, double verticalScroll) {
        if (this.scrollMenu != null) {
            return this.scrollMenu.handleMouseScroll(-1.0, -1.0, verticalScroll);
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return this.scrollMenu != null && this.scrollMenu.handleMouseClick(this.adjustedMouseX, this.adjustedMouseY, mouseButton);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.scrollMenu != null) {
            return this.scrollMenu.handleMouseReleased(mouseX, mouseY, button);
        }
        return false;
    }

    public void resize(Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        if (this.scrollMenu != null) {
            this.scrollMenu.onResize(this.minecraft, AdventMainGui.scaledTabRootX, AdventMainGui.scaledTabRootY, 764, 340);
        }
    }

    public void onStatsUpdated() {
        HashMap<String, EntityStats> statsMap = new HashMap<String, EntityStats>();
        this.statList = new ArrayList();
        for (Object stat2 : this.statsMap.keySet()) {
            EntityType entityType;
            ResourceLocation registryName;
            Object object = stat2.getValue();
            if (!(object instanceof EntityType) || (registryName = AoARegistries.ENTITIES.getKey(entityType = (EntityType)object)) == null || !((Boolean)AoAConfigs.CLIENT.thirdPartyBestiary.get()).booleanValue() && !AdventOfAscension.isAoA(registryName)) continue;
            String registryNameString = registryName.toString();
            if (!statsMap.containsKey(registryNameString)) {
                statsMap.put(registryNameString, new EntityStats((Stat<EntityType<?>>)stat2, stat2.getType() == Stats.ENTITY_KILLED));
                continue;
            }
            ((EntityStats)statsMap.get(registryNameString)).matchAndComplete((Stat<EntityType<?>>)stat2);
        }
        for (Object stat2 : statsMap.values()) {
            if (!((EntityStats)stat2).hasKills()) continue;
            this.statList.add((EntityStats)stat2);
        }
        this.statList.sort(Comparator.comparing(stat -> stat.registryName.getPath()));
        this.filteredMobList = (ArrayList)this.statList.clone();
        this.receivedStats = true;
    }

    public void removed() {
        if (this.searchField != null && this.searchField.isFocused()) {
            this.searchField.setFocused(false);
        }
    }

    @Nullable
    private Entity getEntityFromStat(EntityStats stat) {
        String registryName = stat.registryName.toString();
        if (this.instancesMap.containsKey(registryName)) {
            return this.instancesMap.get(registryName);
        }
        try {
            Entity entity = AoARegistries.ENTITIES.getEntry(stat.registryName).create((Level)this.minecraft.player.clientLevel);
            this.instancesMap.put(registryName, entity);
            return entity;
        }
        catch (Exception e) {
            Logging.logMessage(org.apache.logging.log4j.Level.DEBUG, "Unable to retrieve entity from entity type: " + registryName);
            return null;
        }
    }

    public boolean charTyped(char character, int arg) {
        if (this.searchField.isFocused()) {
            int searchTextLength = this.searchField.getValue().length();
            if (this.searchField.charTyped(character, arg)) {
                if (this.searchField.getValue().isEmpty()) {
                    this.filteredMobList = (ArrayList)this.statList.clone();
                    this.searchField.setTextColor(0xFFFFFF);
                } else if (this.searchField.getValue().length() != searchTextLength) {
                    this.searchFilterBestiaryEntries(searchTextLength < this.searchField.getValue().length());
                }
            }
            return true;
        }
        return super.charTyped(character, arg);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean success = super.keyPressed(keyCode, scanCode, modifiers);
        if (this.openEntryIndex < 0 && keyCode == 70 && AdventGuiTabBestiary.hasControlDown() && !AdventGuiTabBestiary.hasShiftDown() && !AdventGuiTabBestiary.hasAltDown()) {
            if (!this.searchField.isVisible()) {
                this.searchField.setVisible(true);
            }
            this.searchField.setFocused(true);
            return true;
        }
        if (this.searchField.isFocused()) {
            int searchTextLength = this.searchField.getValue().length();
            if (this.searchField.keyPressed(keyCode, scanCode, modifiers)) {
                if (this.searchField.getValue().isEmpty()) {
                    this.filteredMobList = (ArrayList)this.statList.clone();
                    this.searchField.setTextColor(0xFFFFFF);
                } else if (this.searchField.getValue().length() != searchTextLength) {
                    this.searchFilterBestiaryEntries(searchTextLength < this.searchField.getValue().length());
                }
            }
            return true;
        }
        return success;
    }

    private void searchFilterBestiaryEntries(boolean additiveEdit) {
        String searchFilter;
        this.searchField.setTextColor(0xFFFFFF);
        if (this.searchField.getValue().isEmpty()) {
            this.filteredMobList = (ArrayList)this.statList.clone();
            return;
        }
        if (!additiveEdit || this.filteredMobList == null) {
            this.filteredMobList = (ArrayList)this.statList.clone();
        }
        if ((searchFilter = this.searchField.getValue().toLowerCase()).startsWith("@")) {
            String modIdFilter = searchFilter.split("@", 2)[1].split(" ")[0];
            this.filteredMobList.removeIf(stat -> !stat.registryName.getNamespace().startsWith(modIdFilter));
            searchFilter = searchFilter.replace("@" + modIdFilter, "");
            if (searchFilter.startsWith(" ")) {
                searchFilter = searchFilter.substring(1);
            }
            if (searchFilter.isEmpty()) {
                if (this.filteredMobList.isEmpty()) {
                    this.searchField.setTextColor(0xFF0000);
                }
                return;
            }
        }
        String searchedEntityName = searchFilter;
        this.filteredMobList.removeIf(stat -> {
            ResourceLocation registryName = stat.registryName;
            String entityName = LocaleUtil.getLocaleString("entity." + registryName.getNamespace() + "." + registryName.getPath()).replace("." + registryName.getNamespace(), "");
            return !entityName.toLowerCase().contains(searchedEntityName);
        });
        if (this.filteredMobList.isEmpty()) {
            this.searchField.setTextColor(0xFF0000);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void gatherEntityStats(EntityStats stat) {
        block21: {
            block22: {
                block23: {
                    registryName = stat.registryName;
                    entityModId = registryName.getNamespace();
                    this.openEntryInstance = this.getEntityFromStat(stat);
                    this.openEntryStatsLines = new ArrayList<String>();
                    this.openEntryInfoLines = new ArrayList<FormattedCharSequence>(0);
                    v0 = livingInstance = this.openEntryInstance instanceof LivingEntity != false ? (LivingEntity)this.openEntryInstance : null;
                    if (this.openEntryInstance == null) break block22;
                    if (!AdventGuiTabBestiary.registeredEntryHandlers.containsKey(entityModId)) break block23;
                    try {
                        entityData = AdventGuiTabBestiary.registeredEntryHandlers.get(entityModId).apply(this.openEntryInstance);
                        this.openEntryStatsLines = (List)entityData.getA();
                        if (entityData.getB() != null && !((String)entityData.getB()).isEmpty()) {
                            this.openEntryInfoLines = this.font.split((FormattedText)Component.literal((String)((String)entityData.getB())), 489);
                        }
                        break block21;
                    }
                    catch (ClassCastException ex) {
                        Logging.logMessage(org.apache.logging.log4j.Level.WARN, "Mod '" + entityModId + "' provided invalid bestiary entry handler. Removing support. Report this to the mod author.");
                        AdventGuiTabBestiary.registeredEntryHandlers.remove(entityModId);
                        this.openEntryIndex = -1;
                        this.openEntryHeight = 0;
                    }
                    break block21;
                }
                type = LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.other");
                attribute = "";
                var8_9 = this.openEntryInstance;
                if (!(var8_9 instanceof LivingEntity)) ** GOTO lbl-1000
                livingEntity = (LivingEntity)var8_9;
                if (this.openEntryInstance instanceof Enemy) {
                    type = this.openEntryInstance instanceof FlyingMob ? (livingEntity.getAttribute(Attributes.ATTACK_DAMAGE) != null ? LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.flyingMelee") : LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.flyingRanged")) : (this.openEntryInstance instanceof AoAWaterRangedMob ? LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.swimmingRanged") : (this.openEntryInstance instanceof AoAWaterMeleeMobOld || livingEntity.getType().is(EntityTypeTags.AQUATIC) ? LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.swimmingMelee") : (livingEntity.getAttribute(Attributes.ATTACK_DAMAGE) != null ? (this.openEntryInstance instanceof RangedAttackMob ? LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.hybrid") : LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.melee")) : LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.ranged"))));
                } else if (this.openEntryInstance instanceof Merchant) {
                    type = LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.trader");
                } else if (this.openEntryInstance instanceof Animal) {
                    type = LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.animal");
                } else if (this.openEntryInstance instanceof AmbientCreature || this.openEntryInstance instanceof WaterAnimal) {
                    type = LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type.ambient");
                }
                if (livingInstance != null) {
                    entityType = livingInstance.getType();
                    attribute = entityType.is(EntityTypeTags.ARTHROPOD) != false ? LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.attribute.arthropod") : (entityType.is(EntityTypeTags.ILLAGER) != false ? LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.attribute.illager") : (entityType.is(EntityTypeTags.UNDEAD) != false ? LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.attribute.undead") : LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.attribute.none")));
                }
                this.openEntryStatsLines.add(String.valueOf(ChatFormatting.BOLD) + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.type") + String.valueOf(ChatFormatting.RESET) + " " + type);
                this.openEntryStatsLines.add(String.valueOf(ChatFormatting.BOLD) + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.attribute") + String.valueOf(ChatFormatting.RESET) + " " + attribute);
                this.openEntryStatsLines.add(String.valueOf(ChatFormatting.BOLD) + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.size") + String.valueOf(ChatFormatting.RESET) + " " + (float)((int)(this.openEntryInstance.getBbWidth() * 1000.0f)) / 1000.0f + "x" + (float)((int)(this.openEntryInstance.getBbHeight() * 1000.0f)) / 1000.0f);
                this.openEntryStatsLines.add("");
                if (livingInstance != null) {
                    this.openEntryStatsLines.add(String.valueOf(ChatFormatting.BOLD) + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.health") + String.valueOf(ChatFormatting.RESET) + " " + livingInstance.getMaxHealth());
                    if (AttributeUtil.getAttributeValue(livingInstance, (Holder<Attribute>)Attributes.ARMOR) > 0.0) {
                        this.openEntryStatsLines.add(String.valueOf(ChatFormatting.BOLD) + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.armour") + String.valueOf(ChatFormatting.RESET) + " " + AttributeUtil.getAttributeValue(livingInstance, (Holder<Attribute>)Attributes.ARMOR));
                    }
                    if (AttributeUtil.getAttributeValue(livingInstance, (Holder<Attribute>)Attributes.ARMOR_TOUGHNESS) > 0.0) {
                        this.openEntryStatsLines.add(String.valueOf(ChatFormatting.BOLD) + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.toughness") + String.valueOf(ChatFormatting.RESET) + " " + AttributeUtil.getAttributeValue(livingInstance, (Holder<Attribute>)Attributes.ARMOR_TOUGHNESS));
                    }
                    if (AttributeUtil.getAttributeValue(livingInstance, (Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE) > 0.0) {
                        this.openEntryStatsLines.add(String.valueOf(ChatFormatting.BOLD) + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.knockback") + String.valueOf(ChatFormatting.RESET) + " " + NumberUtil.roundToNthDecimalPlace((float)AttributeUtil.getAttributeValue(livingInstance, (Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE) * 100.0f, 2) + "%");
                    }
                    if ((attackAttribute = livingInstance.getAttribute(Attributes.ATTACK_DAMAGE)) != null && attackAttribute.getValue() > 0.0) {
                        this.openEntryStatsLines.add(String.valueOf(ChatFormatting.BOLD) + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.strength") + String.valueOf(ChatFormatting.RESET) + " " + attackAttribute.getValue());
                    }
                    if (this.openEntryInstance instanceof AoARangedAttacker) {
                        if (this.openEntryInstance instanceof AoARangedMob) {
                            this.openEntryStatsLines.add(String.valueOf(ChatFormatting.BOLD) + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.projectileStrength") + String.valueOf(ChatFormatting.RESET) + " " + ((AoARangedMob)this.openEntryInstance).getAttributeValue((Holder)AoAAttributes.RANGED_ATTACK_DAMAGE));
                        } else if (this.openEntryInstance instanceof AoAFlyingRangedMob) {
                            this.openEntryStatsLines.add(String.valueOf(ChatFormatting.BOLD) + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.projectileStrength") + String.valueOf(ChatFormatting.RESET) + " " + ((AoAFlyingRangedMob)this.openEntryInstance).getAttributeValue((Holder)AoAAttributes.RANGED_ATTACK_DAMAGE));
                        }
                    }
                    this.openEntryStatsLines.add(String.valueOf(ChatFormatting.BOLD) + LocaleUtil.getLocaleString("gui.aoa3.adventGui.bestiary.speed") + String.valueOf(ChatFormatting.RESET) + " " + (float)((int)(livingInstance.getAttribute(Attributes.MOVEMENT_SPEED).getValue() * 1000.0)) / 1000.0f);
                }
                if ((bestiaryInfo = BestiaryReloadListener.BESTIARY.get(registryName)) != null) {
                    this.openEntryInfoLines = this.font.split((FormattedText)Component.literal((String)bestiaryInfo), 489);
                }
                break block21;
            }
            this.openEntryIndex = -1;
            this.openEntryHeight = 0;
        }
    }

    public static void registerThirdPartyBestiaryHandler(String modId, Function<Entity, Tuple> entityHandlerFunction) {
        if (!modId.equalsIgnoreCase("aoa3")) {
            registeredEntryHandlers.put(modId, entityHandlerFunction);
        }
    }

    private static class EntityStats {
        @NotNull
        private final ResourceLocation registryName;
        private Stat<EntityType<?>> killStat = null;
        private Stat<EntityType<?>> deathStat = null;

        private EntityStats(Stat<EntityType<?>> stat, boolean killStat) {
            this.registryName = AoARegistries.ENTITIES.getKey((EntityType)stat.getValue());
            if (killStat) {
                this.killStat = stat;
            } else {
                this.deathStat = stat;
            }
        }

        private void matchAndComplete(Stat<EntityType<?>> stat) {
            if (this.killStat == null) {
                this.killStat = stat;
            } else {
                this.deathStat = stat;
            }
        }

        private boolean hasKills() {
            return this.killStat != null;
        }

        private int getKills(StatsCounter statsManager) {
            return Math.max(0, statsManager.getValue(this.killStat));
        }

        private int getDeaths(StatsCounter statsManager) {
            return this.deathStat != null ? Math.max(0, statsManager.getValue(this.deathStat)) : 0;
        }
    }

    private class BestiaryMenu
    extends ScrollablePane {
        public BestiaryMenu(Minecraft mc, int top, int left, int viewHeight, int viewWidth, float renderingScale) {
            super(AdventGuiTabBestiary.this.minecraft, top, left, viewHeight, viewWidth, renderingScale);
        }

        @Override
        public int getFullPaneHeight() {
            return AdventGuiTabBestiary.this.receivedStats ? (AdventGuiTabBestiary.this.openEntryIndex < 0 ? (AdventGuiTabBestiary.this.filteredMobList.size() + AdventGuiTabBestiary.this.filteredMobList.size() % 2) * 100 + 20 : AdventGuiTabBestiary.this.openEntryHeight) : 0;
        }

        @Override
        public void drawPaneContents(GuiGraphics guiGraphics, int top, int left, int right, int bottom, float scrollDistance, float partialTicks) {
            RenderContext renderContext = RenderContext.of(guiGraphics);
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            if (!AdventGuiTabBestiary.this.receivedStats) {
                RenderUtil.renderCenteredScaledText(poseStack, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.bestiary.downloading"), left + (int)((float)this.viewWidth / 2.0f), top + (int)((float)this.viewHeight / 2.0f) - 20, 2.0f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
                RenderUtil.renderCenteredScaledText(poseStack, (Component)Component.literal((String)LOADING_SYMBOLS[(int)(Util.getMillis() / 150L % (long)LOADING_SYMBOLS.length)]), left + (int)((float)this.viewWidth / 2.0f), top + (int)((float)this.viewHeight / 2.0f), 2.0f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
            } else if (AdventGuiTabBestiary.this.filteredMobList.isEmpty()) {
                if (!AdventGuiTabBestiary.this.statList.isEmpty()) {
                    RenderUtil.drawRectangle(poseStack, left, AdventMainGui.scaledTabRootY, 20.0f, 20.0f, -14671840);
                    RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)iconsTextures);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderUtil.renderScaledCustomSizedTexture(poseStack, left + 2, AdventMainGui.scaledTabRootY + 2, 0.0f, 32.0f, 16.0f, 16.0f, 16.0f, 16.0f, 16.0f, 48.0f);
                    if (AdventGuiTabBestiary.this.searchField.isVisible()) {
                        AdventGuiTabBestiary.this.searchField.setX((int)((double)(left + 20) / 2.0));
                        AdventGuiTabBestiary.this.searchField.setY((int)((double)AdventMainGui.scaledTabRootY / 2.0));
                        AdventGuiTabBestiary.this.searchField.setWidth((int)((double)(right - left - 40) / 2.0));
                        poseStack.scale(2.0f, 2.0f, 2.0f);
                        AdventGuiTabBestiary.this.searchField.render(guiGraphics, AdventGuiTabBestiary.this.adjustedMouseX, AdventGuiTabBestiary.this.adjustedMouseX, partialTicks);
                        poseStack.scale(0.5f, 0.5f, 0.5f);
                    }
                    RenderUtil.renderCenteredScaledText(poseStack, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.bestiary.emptySearch"), left + (int)((float)this.viewWidth / 2.0f), top + (int)((float)this.viewHeight / 2.0f) - 20, 2.0f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
                } else {
                    RenderUtil.renderCenteredScaledText(poseStack, (Component)LocaleUtil.getLocaleMessage("gui.aoa3.adventGui.bestiary.empty"), left + (int)((float)this.viewWidth / 2.0f), top + (int)((float)this.viewHeight / 2.0f) - 20, 2.0f, 0xFFFFFF, RenderUtil.TextRenderType.OUTLINED);
                }
            } else if (AdventGuiTabBestiary.this.openEntryIndex < 0) {
                for (int i = Math.max(0, (int)(scrollDistance / 200.0f) * 2); i * 100 <= bottom - top && i < AdventGuiTabBestiary.this.filteredMobList.size(); i += 2) {
                    EntityStats entityStat = AdventGuiTabBestiary.this.filteredMobList.get(i);
                    ResourceLocation registryName = entityStat.registryName;
                    int rowTop = top + 20 + i * 100;
                    Entity entity = AdventGuiTabBestiary.this.getEntityFromStat(entityStat);
                    Component entityName = entity != null ? ((EntityType)entityStat.killStat.getValue()).getDescription() : LocaleUtil.getLocaleMessage("entity." + registryName.getNamespace().replace(".minecraft", "") + "." + registryName.getPath());
                    RenderUtil.drawRectangle(poseStack, left + 40, rowTop + 30, 320.0f, 150.0f, -14671840);
                    if (entity != null) {
                        this.drawEntity(guiGraphics, entity, left + 200, rowTop + 170, 50.0f);
                    }
                    poseStack.pushPose();
                    poseStack.translate(0.0f, 0.0f, 100.0f);
                    RenderUtil.drawRectangle(poseStack, left + 40, rowTop, 320.0f, 30.0f, -16711423);
                    RenderUtil.renderCenteredScaledText(poseStack, entityName, left + 200, rowTop + 8, 2.0f, 0xFFFFFF, RenderUtil.TextRenderType.NORMAL);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)iconsTextures);
                    RenderUtil.renderScaledCustomSizedTexture(poseStack, left + 300, rowTop + 160, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, 16.0f, 48.0f);
                    RenderUtil.renderScaledCustomSizedTexture(poseStack, left + 43, rowTop + 160, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, 16.0f, 16.0f, 48.0f);
                    RenderUtil.renderScaledText(poseStack, (Component)Component.literal((String)NumberUtil.floorAndAppendSuffix(AdventGuiTabBestiary.this.stats.getValue(entityStat.killStat), true)), left + 60, rowTop + 163, 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.NORMAL);
                    RenderUtil.renderScaledText(poseStack, (Component)Component.literal((String)NumberUtil.floorAndAppendSuffix(AdventGuiTabBestiary.this.stats.getValue(entityStat.deathStat), true)), left + 320, rowTop + 163, 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.NORMAL);
                    poseStack.popPose();
                    if (i + 1 >= AdventGuiTabBestiary.this.filteredMobList.size()) continue;
                    entityStat = AdventGuiTabBestiary.this.filteredMobList.get(i + 1);
                    entity = AdventGuiTabBestiary.this.getEntityFromStat(entityStat);
                    entityName = entity != null ? entity.getDisplayName() : LocaleUtil.getLocaleMessage("entity." + entityStat.registryName.getNamespace().replace(".minecraft", "") + "." + entityStat.registryName.getPath());
                    RenderUtil.drawRectangle(poseStack, right - 360, rowTop + 30, 320.0f, 150.0f, -14671840);
                    if (entity != null) {
                        this.drawEntity(guiGraphics, entity, right - 200, rowTop + 170, 50.0f);
                    }
                    poseStack.pushPose();
                    poseStack.translate(0.0f, 0.0f, 100.0f);
                    RenderUtil.drawRectangle(poseStack, right - 360, rowTop, 320.0f, 30.0f, -16711423);
                    RenderUtil.renderCenteredScaledText(poseStack, entityName, right - 200, rowTop + 8, 2.0f, 0xFFFFFF, RenderUtil.TextRenderType.NORMAL);
                    RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)iconsTextures);
                    RenderUtil.renderScaledCustomSizedTexture(poseStack, right - 100, rowTop + 160, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, 16.0f, 48.0f);
                    RenderUtil.renderScaledCustomSizedTexture(poseStack, right - 357, rowTop + 160, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, 16.0f, 16.0f, 48.0f);
                    RenderUtil.renderScaledText(poseStack, (Component)Component.literal((String)NumberUtil.floorAndAppendSuffix(AdventGuiTabBestiary.this.stats.getValue(entityStat.killStat), true)), right - 340, rowTop + 163, 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.NORMAL);
                    RenderUtil.renderScaledText(poseStack, (Component)Component.literal((String)NumberUtil.floorAndAppendSuffix(AdventGuiTabBestiary.this.stats.getValue(entityStat.deathStat), true)), right - 80, rowTop + 163, 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.NORMAL);
                    poseStack.popPose();
                }
                RenderSystem.disableDepthTest();
                RenderUtil.drawRectangle(poseStack, left, AdventMainGui.scaledTabRootY, 20.0f, 20.0f, -14671840);
                RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)iconsTextures);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderUtil.renderScaledCustomSizedTexture(poseStack, left + 2, AdventMainGui.scaledTabRootY + 2, 0.0f, 32.0f, 16.0f, 16.0f, 16.0f, 16.0f, 16.0f, 48.0f);
                if (AdventGuiTabBestiary.this.searchField.isVisible()) {
                    AdventGuiTabBestiary.this.searchField.setX((int)((double)(left + 20) / 2.0));
                    AdventGuiTabBestiary.this.searchField.setY((int)((double)AdventMainGui.scaledTabRootY / 2.0));
                    AdventGuiTabBestiary.this.searchField.setWidth((int)((double)(right - left - 40) / 2.0));
                    poseStack.scale(2.0f, 2.0f, 2.0f);
                    poseStack.translate(0.0f, 0.0f, 1000.0f);
                    AdventGuiTabBestiary.this.searchField.render(guiGraphics, AdventGuiTabBestiary.this.adjustedMouseX, AdventGuiTabBestiary.this.adjustedMouseX, partialTicks);
                    poseStack.scale(0.5f, 0.5f, 0.5f);
                }
                RenderSystem.enableDepthTest();
            } else {
                int i;
                EntityStats entityStat = AdventGuiTabBestiary.this.filteredMobList.get(AdventGuiTabBestiary.this.openEntryIndex);
                ResourceLocation registryName = entityStat.registryName;
                int n = AdventGuiTabBestiary.this.openEntryInfoLines.size();
                Objects.requireNonNull(AdventGuiTabBestiary.this.font);
                AdventGuiTabBestiary.this.openEntryHeight = Math.max(this.viewHeight - 30, 320 + (int)((float)(n * 9) * 1.5f));
                RenderUtil.drawRectangle(poseStack, left, top + 30, right - left, bottom - top, -14671840);
                RenderUtil.drawRectangle(poseStack, left, top, right - left, 30.0f, -16711423);
                Component entityName = AdventGuiTabBestiary.this.openEntryInstance != null ? AdventGuiTabBestiary.this.openEntryInstance.getName() : LocaleUtil.getLocaleMessage("entity." + registryName.getNamespace().replace(".minecraft", "") + "." + registryName.getPath());
                RenderUtil.renderCenteredScaledText(poseStack, entityName, left + (int)((float)this.viewWidth / 2.0f), top + 8, 2.0f, 0xFFFFFF, RenderUtil.TextRenderType.NORMAL);
                if (AdventGuiTabBestiary.this.openEntryInstance != null) {
                    this.drawEntity(guiGraphics, AdventGuiTabBestiary.this.openEntryInstance, left + 200, top + 240, 75.0f);
                }
                RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)iconsTextures);
                RenderUtil.renderScaledCustomSizedTexture(poseStack, left + 425, top + 45, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, 16.0f, 16.0f, 48.0f);
                RenderUtil.renderScaledCustomSizedTexture(poseStack, left + 425, top + 65, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, 16.0f, 48.0f);
                RenderUtil.renderScaledText(poseStack, (Component)Component.literal((String)"X"), right - 20, top + 5, 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.NORMAL);
                RenderUtil.renderScaledText(poseStack, (Component)Component.literal((String)NumberUtil.floorAndAppendSuffix(AdventGuiTabBestiary.this.stats.getValue(entityStat.killStat), true)), left + 445, top + 48, 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.NORMAL);
                RenderUtil.renderScaledText(poseStack, (Component)Component.literal((String)NumberUtil.floorAndAppendSuffix(AdventGuiTabBestiary.this.stats.getValue(entityStat.deathStat), true)), left + 445, top + 68, 1.5f, 0xFFFFFF, RenderUtil.TextRenderType.NORMAL);
                poseStack.scale(1.5f, 1.5f, 1.5f);
                Matrix4f pose = poseStack.last().pose();
                for (i = 0; i < AdventGuiTabBestiary.this.openEntryStatsLines.size(); ++i) {
                    renderContext.renderText((Component)Component.literal((String)AdventGuiTabBestiary.this.openEntryStatsLines.get(i)), (int)((float)(left + 425) / 1.5f), (int)((float)(top + 100 + 14 * i) / 1.5f), 0xFFFFFF, RenderUtil.TextRenderType.DROP_SHADOW);
                }
                for (i = 0; i < AdventGuiTabBestiary.this.openEntryInfoLines.size(); ++i) {
                    renderContext.renderText(AdventGuiTabBestiary.this.openEntryInfoLines.get(i), (float)((int)((float)(left + 20) / 1.5f)), (float)((int)((float)(top + 300 + i * 14) / 1.5f)), 0xFFFFFF, 0, RenderUtil.TextRenderType.NORMAL, 0xF000F0);
                }
            }
            poseStack.popPose();
        }

        @Override
        public void drawBackground(GuiGraphics guiGraphics) {
        }

        private void drawEntity(GuiGraphics guiGraphics, Entity entity, int posX, int posY, float scale) {
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.translate((float)posX, (float)posY, 1050.0f);
            poseStack.scale(1.0f, 1.0f, -1.0f);
            Minecraft mc = Minecraft.getInstance();
            float sizeFactor = Math.max(entity.getBbWidth(), entity.getBbHeight());
            if ((double)sizeFactor > 2.5) {
                scale = (float)((double)scale / ((double)sizeFactor / 2.5));
            }
            poseStack.translate(0.0, 0.0, 1000.0);
            poseStack.scale(scale, scale, scale);
            poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
            entity.tickCount = mc.player.tickCount;
            entity.setYRot(0.0f);
            entity.setXRot(0.0f);
            EntityRenderDispatcher renderManager = mc.getEntityRenderDispatcher();
            renderManager.setRenderShadow(false);
            MultiBufferSource.BufferSource renderBuffer = mc.renderBuffers().bufferSource();
            renderManager.render(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)renderBuffer, 0xF000F0);
            renderBuffer.endBatch();
            renderManager.setRenderShadow(true);
            poseStack.popPose();
        }

        @Override
        public boolean handleMouseClick(double mouseX, double mouseY, int button) {
            super.handleMouseClick(mouseX, mouseY, button);
            if (!AdventGuiTabBestiary.this.receivedStats) {
                return false;
            }
            int relativeMouseX = (int)mouseX - this.left + 2;
            if (relativeMouseX < 0) {
                return false;
            }
            if (AdventGuiTabBestiary.this.openEntryIndex < 0) {
                if (relativeMouseX <= 20 && mouseY - (double)this.top + 2.0 < 20.0) {
                    AdventGuiTabBestiary.this.searchField.setVisible(!AdventGuiTabBestiary.this.searchField.isVisible());
                    if (AdventGuiTabBestiary.this.searchField.isVisible()) {
                        AdventGuiTabBestiary.this.searchField.setFocused(true);
                    } else {
                        AdventGuiTabBestiary.this.searchField.setValue("");
                        AdventGuiTabBestiary.this.searchFilterBestiaryEntries(false);
                    }
                } else if (AdventGuiTabBestiary.this.searchField.isVisible() && AdventGuiTabBestiary.this.searchField.mouseClicked((double)((int)((double)(relativeMouseX + this.left) / 2.0)), (double)((int)((mouseY - 2.0) / 2.0)), 0)) {
                    return true;
                }
                if (relativeMouseX < 40 || relativeMouseX > this.right - this.left - 40) {
                    return false;
                }
            }
            int newTop = this.top - Math.max(0, (int)this.distanceScrolled);
            int relativeMouseY = (int)mouseY - newTop + 2;
            if (mouseY - (double)this.top < 0.0 || mouseY > (double)(this.top + this.viewHeight)) {
                return false;
            }
            if (AdventGuiTabBestiary.this.openEntryIndex < 0) {
                float preIndexY;
                int selectedIndex = -1;
                if (relativeMouseX < 360) {
                    preIndexY = (float)relativeMouseY / 200.0f;
                    if ((double)(preIndexY - (float)((int)preIndexY)) > 0.11) {
                        selectedIndex = 2 * (int)preIndexY;
                    }
                } else if (relativeMouseX > this.right - this.left - 360 && (double)((preIndexY = (float)relativeMouseY / 200.0f) - (float)((int)preIndexY)) > 0.11) {
                    selectedIndex = 1 + (int)preIndexY * 2;
                }
                if (selectedIndex >= 0 && AdventGuiTabBestiary.this.filteredMobList.size() > selectedIndex) {
                    AdventGuiTabBestiary.this.openEntryIndex = selectedIndex;
                    AdventGuiTabBestiary.this.openEntryHeight = 600;
                    AdventGuiTabBestiary.this.lastDistanceScrolled = this.distanceScrolled;
                    this.distanceScrolled = 0.0f;
                    EntityStats entry = AdventGuiTabBestiary.this.filteredMobList.get(selectedIndex);
                    if (AdventGuiTabBestiary.this.lastOpenedEntry != entry) {
                        if (AdventGuiTabBestiary.this.openEntryInstance != null) {
                            AdventGuiTabBestiary.this.openEntryInstance.discard();
                        }
                        AdventGuiTabBestiary.this.gatherEntityStats(entry);
                    }
                    AdventGuiTabBestiary.this.lastOpenedEntry = entry;
                    AdventGuiTabBestiary.this.searchField.setVisible(false);
                }
            } else if (relativeMouseY <= 30) {
                AdventGuiTabBestiary.this.lastOpenedEntry = AdventGuiTabBestiary.this.openEntryIndex < AdventGuiTabBestiary.this.filteredMobList.size() ? AdventGuiTabBestiary.this.filteredMobList.get(AdventGuiTabBestiary.this.openEntryIndex) : null;
                AdventGuiTabBestiary.this.openEntryIndex = -1;
                AdventGuiTabBestiary.this.openEntryHeight = 0;
                this.distanceScrolled = AdventGuiTabBestiary.this.lastDistanceScrolled;
            }
            return true;
        }
    }
}

