/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.event;

import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.tslat.aoa3.advent.AoAResourceCaching;
import net.tslat.aoa3.client.AoAKeybinds;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.client.gui.overlay.ScreenEffectRenderer;
import net.tslat.aoa3.client.player.ClientPlayerDataManager;
import net.tslat.aoa3.client.render.dimension.AoADimensionEffectsRenderer;
import net.tslat.aoa3.common.networking.AoANetworking;
import net.tslat.aoa3.common.networking.packets.HaloSelectPacket;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.data.server.AoASkillReqReloadListener;
import net.tslat.aoa3.event.GlobalEvents;
import net.tslat.aoa3.player.halo.HaloTypes;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RegistryUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.smartbrainlib.util.RandomUtil;

public final class ClientEventHandler {
    public static void init() {
        IEventBus forgeBus = NeoForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, false, ClientTickEvent.Post.class, ClientEventHandler::onClientTick);
        forgeBus.addListener(EventPriority.NORMAL, false, ClientPlayerNetworkEvent.LoggingIn.class, ClientEventHandler::onPlayerJoin);
        forgeBus.addListener(EventPriority.NORMAL, false, ClientPlayerNetworkEvent.LoggingOut.class, ClientEventHandler::onPlayerLogout);
        forgeBus.addListener(EventPriority.NORMAL, false, LivingDeathEvent.class, ClientEventHandler::onPlayerDeath);
        forgeBus.addListener(EventPriority.NORMAL, false, ItemTooltipEvent.class, ClientEventHandler::onTooltip);
        forgeBus.addListener(EventPriority.NORMAL, false, ViewportEvent.RenderFog.class, ClientEventHandler::onFogRender);
        forgeBus.addListener(EventPriority.NORMAL, false, EntityTickEvent.Post.class, ClientEventHandler::onEntityTick);
    }

    private static void onClientTick(ClientTickEvent.Post ev) {
        if (!Minecraft.getInstance().hasSingleplayerServer()) {
            AoAScheduler.handleSyncScheduledTasks(++GlobalEvents.tick);
        }
    }

    private static void onPlayerJoin(ClientPlayerNetworkEvent.LoggingIn ev) {
        if (((Boolean)AoAConfigs.CLIENT.showWelcomeMessage.get()).booleanValue()) {
            if (AoAKeybinds.ADVENT_GUI.getKey().getValue() == -1) {
                ev.getPlayer().sendSystemMessage((Component)LocaleUtil.getLocaleMessage(LocaleUtil.createGenericLocaleKey("message", "login.welcome.alt"), ChatFormatting.GRAY, new Component[0]));
            } else {
                ev.getPlayer().sendSystemMessage((Component)LocaleUtil.getLocaleMessage(LocaleUtil.createGenericLocaleKey("message", "login.welcome"), ChatFormatting.GRAY, AoAKeybinds.ADVENT_GUI.getTranslatedKeyMessage()));
            }
        }
        AoANetworking.sendToServer(new HaloSelectPacket((HaloTypes.Selectable)((Object)AoAConfigs.CLIENT.personalHaloPreference.get())));
        ClientPlayerDataManager.get().updatePlayerInstance((Player)ev.getPlayer());
    }

    private static void onPlayerLogout(ClientPlayerNetworkEvent.LoggingOut ev) {
        if (ev.getConnection() != null) {
            AoAResourceCaching.clientLogout();
        }
    }

    private static void onPlayerDeath(LivingDeathEvent ev) {
        if (ev.getEntity() == Minecraft.getInstance().player) {
            ScreenEffectRenderer.clearOverlays();
        }
    }

    private static void onTooltip(ItemTooltipEvent ev) {
        Map<String, List<ObjectIntPair<ResourceLocation>>> restrictions = AoASkillReqReloadListener.getParsedReqDataFor(RegistryUtil.getId(ev.getItemStack().getItem()));
        if (!restrictions.isEmpty()) {
            List lines = ev.getToolTip();
            if (ev.getFlags().isAdvanced()) {
                lines.add(1, LocaleUtil.getLocaleMessage(LocaleUtil.createGenericLocaleKey("gui", "tooltip.skillReq"), ChatFormatting.DARK_RED, new Component[0]));
                int index = 2;
                for (Map.Entry<String, List<ObjectIntPair<ResourceLocation>>> reqEntry : restrictions.entrySet()) {
                    lines.add(index++, Component.literal((String)"  ").withStyle(ChatFormatting.RED).append((Component)LocaleUtil.getLocaleMessage(Util.makeDescriptionId((String)"ability", (ResourceLocation)AoAAbilities.LEVEL_RESTRICTION.getId()) + ".description." + reqEntry.getKey())).append(":"));
                    for (ObjectIntPair<ResourceLocation> pair : reqEntry.getValue()) {
                        AoASkill skill = AoASkills.getSkill((ResourceLocation)pair.first());
                        lines.add(index++, Component.literal((String)"    ").withStyle(ChatFormatting.GOLD).append(pair.valueInt() + " ").append((Component)skill.getName()));
                    }
                }
                lines.add(index, Component.literal((String)""));
            } else {
                lines.add(1, LocaleUtil.getLocaleMessage(LocaleUtil.createGenericLocaleKey("gui", "tooltip.skillReq.hidden"), ChatFormatting.DARK_RED, new Component[0]));
            }
        }
    }

    private static void onFogRender(ViewportEvent.RenderFog ev) {
        ClientLevel level = (ClientLevel)ClientOperations.getLevel();
        DimensionSpecialEffects dimensionSpecialEffects = level.effects();
        if (dimensionSpecialEffects instanceof AoADimensionEffectsRenderer) {
            AoADimensionEffectsRenderer aoaEffects = (AoADimensionEffectsRenderer)dimensionSpecialEffects;
            aoaEffects.adjustFogRender(level, ev.getMode(), ev.getType(), ev.getCamera(), farPlaneValue -> {
                ev.setFarPlaneDistance(farPlaneValue);
                ev.setCanceled(true);
            }, nearPlaneValue -> {
                ev.setNearPlaneDistance(nearPlaneValue);
                ev.setCanceled(true);
            });
        }
    }

    private static void onEntityTick(EntityTickEvent.Post ev) {
        Entity entity;
        if (((Boolean)AoAConfigs.CLIENT.partyDeaths.get()).booleanValue() && (entity = ev.getEntity()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            if (entity2.deathTime >= 10) {
                AABB boundingBox = entity2.getBoundingBox();
                double width = boundingBox.maxX - boundingBox.minX;
                double depth = boundingBox.maxZ - boundingBox.minZ;
                double height = boundingBox.maxY - boundingBox.minY;
                int i = 0;
                while ((double)i < 3.0 + 10.0 * width * depth * height) {
                    ParticleBuilder.forRandomPosInBounds((ParticleOptions)((ParticleOptions)AoAParticleTypes.GENERIC_DUST.get()), (AABB)entity2.getBoundingBox()).scaleMod(0.1f).power(new Vec3(RandomUtil.randomScaledGaussianValue((double)0.05), 0.0, RandomUtil.randomScaledGaussianValue((double)0.05))).colourOverride((float)RandomUtil.randomGaussianValue(), (float)RandomUtil.randomGaussianValue(), (float)RandomUtil.randomGaussianValue(), 1.0f).spawnParticles(entity2.level());
                    ++i;
                }
            }
        }
    }
}

