/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.clientextension.fluid;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.util.ColourUtil;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ToxicWasteClientExtension
implements IClientFluidTypeExtensions {
    public static final ResourceLocation OVERLAY = AdventOfAscension.id("block/toxic_waste_overlay");
    public static final ResourceLocation UNDERWATER = AdventOfAscension.id("textures/block/toxic_waste_overlay.png");
    public static final ResourceLocation FLOWING = AdventOfAscension.id("block/toxic_waste_flow");
    public static final ResourceLocation STILL = AdventOfAscension.id("block/toxic_waste_still");

    public int getTintColor() {
        return ColourUtil.ARGB(38, 42, 23, 255);
    }

    public ResourceLocation getStillTexture() {
        return STILL;
    }

    @Nullable
    public ResourceLocation getOverlayTexture() {
        return OVERLAY;
    }

    public ResourceLocation getFlowingTexture() {
        return FLOWING;
    }

    @Nullable
    public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
        return UNDERWATER;
    }

    public void renderOverlay(Minecraft mc, PoseStack stack) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getRenderOverlayTexture(mc));
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        float uOffset = mc.player.getYRot() / 512.0f + (float)mc.player.tickCount / 1800.0f;
        float vOffset = mc.player.getXRot() / 1024.0f + (float)mc.player.tickCount / 3600.0f;
        Matrix4f matrixStack = stack.last().pose();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
        buffer.addVertex(matrixStack, -1.0f, -1.0f, -0.5f).setUv(uOffset, 1.0f + vOffset).setNormal(0.0f, 1.0f, 0.0f);
        buffer.addVertex(matrixStack, 1.0f, -1.0f, -0.5f).setUv(1.0f + uOffset, 1.0f + vOffset).setNormal(0.0f, 1.0f, 0.0f);
        buffer.addVertex(matrixStack, 1.0f, 1.0f, -0.5f).setUv(1.0f + uOffset, vOffset).setNormal(0.0f, 1.0f, 0.0f);
        buffer.addVertex(matrixStack, -1.0f, 1.0f, -0.5f).setUv(uOffset, vOffset).setNormal(0.0f, 1.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableBlend();
    }
}

