/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.gui.adventgui.AdventMainGui;
import net.tslat.aoa3.client.player.ClientPlayerDataManager;

public class AoAKeybinds {
    private static final String CATEGORY = "key.categories.aoa3";
    public static KeyMapping RESOURCE_GUI;
    public static KeyMapping SKILL_GUI;
    public static KeyMapping ADVENT_GUI;
    public static KeyMapping ABILITY_ACTION;
    public static boolean statusResourceGui;
    public static boolean statusSkillGui;
    public static boolean statusResourceGuiMessage;
    public static boolean statusSkillGuiMessage;

    public static void init() {
        NeoForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, InputEvent.Key.class, AoAKeybinds::onKeyDown);
        AdventOfAscension.getModEventBus().addListener(EventPriority.NORMAL, false, RegisterKeyMappingsEvent.class, ev -> {
            RESOURCE_GUI = new KeyMapping(AoAKeybinds.keyName("resources"), (IKeyConflictContext)KeyConflictContext.IN_GAME, AoAKeybinds.getKey(79), CATEGORY);
            ev.register(RESOURCE_GUI);
            SKILL_GUI = new KeyMapping(AoAKeybinds.keyName("skills"), (IKeyConflictContext)KeyConflictContext.IN_GAME, AoAKeybinds.getKey(-1), CATEGORY);
            ev.register(SKILL_GUI);
            ADVENT_GUI = new KeyMapping(AoAKeybinds.keyName("adventGui"), (IKeyConflictContext)KeyConflictContext.IN_GAME, AoAKeybinds.getKey(261), CATEGORY);
            ev.register(ADVENT_GUI);
            ABILITY_ACTION = new KeyMapping(AoAKeybinds.keyName("abilityAction"), (IKeyConflictContext)KeyConflictContext.IN_GAME, AoAKeybinds.getKey(86), CATEGORY);
            ev.register(ABILITY_ACTION);
        });
    }

    private static String keyName(String id) {
        return "key.aoa3." + id;
    }

    private static InputConstants.Key getKey(int keyCode) {
        return InputConstants.Type.KEYSYM.getOrCreate(keyCode);
    }

    private static void onKeyDown(InputEvent.Key ev) {
        if (RESOURCE_GUI.consumeClick()) {
            statusResourceGui = !statusResourceGui;
            statusResourceGuiMessage = false;
        }
        if (SKILL_GUI.consumeClick()) {
            statusSkillGui = !statusSkillGui;
            statusSkillGuiMessage = false;
        }
        Minecraft mc = Minecraft.getInstance();
        if (ADVENT_GUI.consumeClick() && mc.player != null) {
            if (mc.screen instanceof AdventMainGui) {
                mc.setScreen(null);
            } else if (mc.screen == null) {
                mc.setScreen((Screen)new AdventMainGui((Player)Minecraft.getInstance().player));
            }
        }
        if (ev.getAction() == 1 && Minecraft.getInstance().screen == null) {
            ClientPlayerDataManager.get().handleKeyInput(ev.getKey());
        }
    }

    static {
        statusResourceGui = false;
        statusSkillGui = false;
        statusResourceGuiMessage = true;
        statusSkillGuiMessage = true;
    }
}

