/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advent;

import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.ConfigurationTask;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.event.RegisterConfigurationTasksEvent;
import net.tslat.aoa3.advent.InDevMeasurements;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.client.AoAClientSetup;
import net.tslat.aoa3.common.misc.NativePatching;
import net.tslat.aoa3.common.networking.AoANetworking;
import net.tslat.aoa3.common.networking.configtask.PlayerHalosHandshakeTask;
import net.tslat.aoa3.common.networking.configtask.SkillReqsHandshakeTask;
import net.tslat.aoa3.common.registration.AoAAdvancementTriggers;
import net.tslat.aoa3.common.registration.AoACommands;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.common.registration.AoADatapackLoaders;
import net.tslat.aoa3.common.registration.AoADispensables;
import net.tslat.aoa3.common.registration.AoAGameRules;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.entity.AoAEntitySpawnPlacements;
import net.tslat.aoa3.common.registration.entity.AoAEntityStats;
import net.tslat.aoa3.common.registration.entity.AoAVillagerTrades;
import net.tslat.aoa3.content.capability.AoACapabilityAttachments;
import net.tslat.aoa3.event.EntityEvents;
import net.tslat.aoa3.event.GlobalEvents;
import net.tslat.aoa3.event.PlayerEvents;
import net.tslat.aoa3.event.RestrictionEventHandler;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriptions;
import net.tslat.aoa3.integration.IntegrationManager;
import net.tslat.aoa3.util.WebUtil;

@Mod(value="aoa3")
public class AdventOfAscension {
    private static String VERSION;
    public static final String MOD_ID = "aoa3";
    private static IEventBus MOD_EVENT_BUS;
    private static final ResourceLocation BASE_ID;
    public static final UUID ENTRANCE_MESSAGE_UUID;

    public AdventOfAscension(ModContainer modContainer, IEventBus modBus) {
        VERSION = modContainer.getModInfo().getVersion().toString();
        MOD_EVENT_BUS = modBus;
        Logging.logStatusMessage("!~ Advent of Ascension v" + VERSION + " ~!");
        AdventOfAscension.initRegistrations(modContainer);
        AdventOfAscension.initEventHandlers();
        NativePatching.init();
        IntegrationManager.init();
    }

    private static void initRegistrations(ModContainer modContainer) {
        AoAConfigs.init(modContainer);
        AoARegistries.init();
        AoADatapackLoaders.init();
        AoACommands.init();
        AoAAdvancementTriggers.init();
        AoANetworking.init();
        AoAEntityStats.init();
        AoAVillagerTrades.init();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            AoAClientSetup.init(modContainer);
        }
    }

    private static void initEventHandlers() {
        MOD_EVENT_BUS.addListener(EventPriority.NORMAL, false, FMLCommonSetupEvent.class, AdventOfAscension::commonSetup);
        MOD_EVENT_BUS.addListener(EventPriority.NORMAL, false, FMLClientSetupEvent.class, AdventOfAscension::clientSetup);
        MOD_EVENT_BUS.addListener(EventPriority.NORMAL, false, FMLLoadCompleteEvent.class, AdventOfAscension::loadFinished);
        MOD_EVENT_BUS.addListener(EventPriority.NORMAL, false, RegisterConfigurationTasksEvent.class, AdventOfAscension::playerConfigListeners);
        AoACapabilityAttachments.init();
        RestrictionEventHandler.preInit();
        DynamicEventSubscriptions.init();
        PlayerEvents.preInit();
        GlobalEvents.preInit();
        EntityEvents.preInit();
        AoAEntitySpawnPlacements.init();
        if (!FMLEnvironment.production && FMLEnvironment.dist == Dist.CLIENT) {
            InDevMeasurements.init();
        }
    }

    private static void commonSetup(FMLCommonSetupEvent ev) {
        ev.enqueueWork(() -> {
            AoAGameRules.lateInit();
            AoADispensables.lateInit();
            IntegrationManager.lateInit();
            MOD_EVENT_BUS = null;
        });
    }

    private static void clientSetup(FMLClientSetupEvent ev) {
        AoAClientSetup.postInit(arg_0 -> ((FMLClientSetupEvent)ev).enqueueWork(arg_0));
    }

    private static void loadFinished(FMLLoadCompleteEvent ev) {
        WebUtil.doHTTPTasks();
    }

    private static void playerConfigListeners(RegisterConfigurationTasksEvent ev) {
        ev.register((ConfigurationTask)new PlayerHalosHandshakeTask(ev.getListener()));
        ev.register((ConfigurationTask)new SkillReqsHandshakeTask(ev.getListener()));
    }

    public static ResourceLocation id(String path) {
        return BASE_ID.withPath(path);
    }

    public static boolean isAoA(ResourceLocation path) {
        return path.getNamespace().equals(MOD_ID);
    }

    public static String getVersion() {
        return VERSION;
    }

    public static IEventBus getModEventBus() {
        return MOD_EVENT_BUS;
    }

    static {
        BASE_ID = ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"");
        ENTRANCE_MESSAGE_UUID = UUID.fromString("2459b511-ca45-43d8-808d-f0eb30a63be4");
    }
}

