/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.Nullable;

public class LoadedChunksToPoints {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PolygonData recalculateChunks(Iterable<ChunkHolder> chunks) {
        HashMap<FullChunkStatus, HashMultimap> statusMap = new HashMap<FullChunkStatus, HashMultimap>();
        statusMap.put(FullChunkStatus.FULL, HashMultimap.create());
        statusMap.put(FullChunkStatus.BLOCK_TICKING, HashMultimap.create());
        statusMap.put(FullChunkStatus.ENTITY_TICKING, HashMultimap.create());
        statusMap.put(FullChunkStatus.INACCESSIBLE, HashMultimap.create());
        Iterable<ChunkHolder> iterable = chunks;
        synchronized (iterable) {
            for (ChunkHolder holder : chunks) {
                ChunkPos chunk = holder.getPos();
                FullChunkStatus status = holder.getFullStatus();
                Multimap edges = (Multimap)statusMap.get(status);
                LoadedChunksToPoints.addNewEdge((Multimap<ChunkPos, ChunkPos>)edges, new ChunkPos(chunk.x, chunk.z), new ChunkPos(chunk.x + 1, chunk.z));
                LoadedChunksToPoints.addNewEdge((Multimap<ChunkPos, ChunkPos>)edges, new ChunkPos(chunk.x + 1, chunk.z), new ChunkPos(chunk.x + 1, chunk.z + 1));
                LoadedChunksToPoints.addNewEdge((Multimap<ChunkPos, ChunkPos>)edges, new ChunkPos(chunk.x + 1, chunk.z + 1), new ChunkPos(chunk.x, chunk.z + 1));
                LoadedChunksToPoints.addNewEdge((Multimap<ChunkPos, ChunkPos>)edges, new ChunkPos(chunk.x, chunk.z + 1), new ChunkPos(chunk.x, chunk.z));
            }
        }
        List<Polygon> full = LoadedChunksToPoints.buildPolygon((Multimap<ChunkPos, ChunkPos>)((Multimap)statusMap.get(FullChunkStatus.FULL)));
        List<Polygon> block = LoadedChunksToPoints.buildPolygon((Multimap<ChunkPos, ChunkPos>)((Multimap)statusMap.get(FullChunkStatus.BLOCK_TICKING)));
        List<Polygon> entity = LoadedChunksToPoints.buildPolygon((Multimap<ChunkPos, ChunkPos>)((Multimap)statusMap.get(FullChunkStatus.ENTITY_TICKING)));
        List<Polygon> inaccessible = LoadedChunksToPoints.buildPolygon((Multimap<ChunkPos, ChunkPos>)((Multimap)statusMap.get(FullChunkStatus.INACCESSIBLE)));
        return new PolygonData(full, entity, block, inaccessible);
    }

    private static List<Polygon> buildPolygon(Multimap<ChunkPos, ChunkPos> edges) {
        ArrayList<Polygon> polygonOverlays = new ArrayList<Polygon>();
        ArrayList outerPolygons = new ArrayList();
        HashMultimap holesPolygons = HashMultimap.create();
        while (!edges.isEmpty()) {
            boolean clockwise;
            ChunkPos edge2;
            ChunkPos starting = (ChunkPos)Collections.min(edges.keySet(), (e1, e2) -> e1.x == e2.x ? e1.z - e2.z : e1.x - e2.x);
            ArrayList<ChunkPos> arrayList = new ArrayList<ChunkPos>();
            Object edge = starting;
            int direction = 1;
            do {
                arrayList.add((ChunkPos)edge);
                Iterator it = edges.get(edge).iterator();
                edge2 = (ChunkPos)it.next();
                while (it.hasNext() && Integer.signum(direction) == Integer.signum(edge2.x - ((ChunkPos)edge).x + ((ChunkPos)edge).z - edge2.z)) {
                    edge2 = (ChunkPos)it.next();
                }
                edges.remove(edge, (Object)edge2);
                direction = edge2.x - ((ChunkPos)edge).x + edge2.z - ((ChunkPos)edge).z;
            } while (!(edge = edge2).equals((Object)starting));
            boolean bl = clockwise = ((ChunkPos)arrayList.get((int)0)).x != ((ChunkPos)arrayList.get((int)1)).x;
            if (clockwise) {
                outerPolygons.add(arrayList);
                continue;
            }
            ChunkPos ray = (ChunkPos)arrayList.getFirst();
            ChunkPos outerFound = null;
            for (int i = 0; i < 999; ++i) {
                for (List list : outerPolygons) {
                    ChunkPos outerStart = (ChunkPos)list.getFirst();
                    if (list.contains(ray)) {
                        outerFound = outerStart;
                        break;
                    }
                    for (List hole : holesPolygons.get((Object)outerStart)) {
                        if (!hole.contains(ray)) continue;
                        outerFound = outerStart;
                        break;
                    }
                    if (outerFound == null) continue;
                    break;
                }
                if (outerFound != null) break;
                ray = new ChunkPos(ray.x - 1, ray.z);
            }
            if (outerFound == null) continue;
            holesPolygons.put(outerFound, arrayList);
        }
        for (List list : outerPolygons) {
            LoadedChunksToPoints.removeCollinear(list);
            for (List hole : holesPolygons.get((Object)((ChunkPos)list.getFirst()))) {
                LoadedChunksToPoints.removeCollinear(hole);
            }
        }
        for (List list : outerPolygons) {
            Points polygon = new Points(list.stream().map(c -> new BlockPos(c.getMinBlockX(), 70, c.getMinBlockZ()).asLong()).toList());
            ArrayList<Points> polygonHoles = null;
            if (holesPolygons.containsKey(list.getFirst())) {
                polygonHoles = new ArrayList<Points>();
                for (List hole : holesPolygons.get((Object)((ChunkPos)list.getFirst()))) {
                    polygonHoles.add(new Points(hole.stream().map(c -> new BlockPos(c.getMinBlockX(), 70, c.getMinBlockZ()).asLong()).toList()));
                }
            }
            polygonOverlays.add(new Polygon(polygon, polygonHoles));
        }
        return polygonOverlays;
    }

    private static void removeCollinear(List<ChunkPos> chunks) {
        if (chunks.size() <= 4) {
            return;
        }
        ChunkPos prev = chunks.getFirst();
        for (int i = chunks.size() - 1; i > 0; --i) {
            ChunkPos next = chunks.get(i - 1);
            if (prev.x == next.x || prev.z == next.z) {
                chunks.remove(i);
            }
            if (i >= chunks.size()) continue;
            prev = chunks.get(i);
        }
    }

    private static void addNewEdge(Multimap<ChunkPos, ChunkPos> edges, ChunkPos from, ChunkPos to) {
        if (!edges.remove((Object)to, (Object)from)) {
            edges.put((Object)from, (Object)to);
        }
    }

    public record PolygonData(List<Polygon> full, List<Polygon> entity, List<Polygon> block, List<Polygon> inaccessible) {
        public static final Gson GSON = new GsonBuilder().create();

        public String toJsonString() {
            return GSON.toJson((Object)this);
        }
    }

    record Points(List<Long> points) {
    }

    record Polygon(Points outerArea, @Nullable List<Points> holes) {
    }
}

